#encoding: utf-8
class AgglomerationsAbfrageController < AbstractAbfrageController
  include ActiveModel::AttributeAssignment
  attr_accessor :conditions, :condition_parameters

  before_action :login_required
  layout "application"
  NAME = 'Agglomeration'
  PLURAL = 'Agglomerationen'

  include ApplicationHelper

  def filter_columns
     @aggloms = Generica.new('agglomerations', session[:user])
     session[:agg_query] = Hash.new()
     session[:agg_query][:jahr] = params[:jahr]
     session[:agg_query][:untergrenze] = params[:untergrenze]
     session[:agg_query][:obergrenze] = params[:obergrenze]
     session[:agg_query][:grossstadt] = params[:grossstadt]
     session[:agg_query][:name] = params[:name]
     session[:agg_query][:id] = params[:id]
     session[:agg_query][:eu_key] = params[:eu_key]
     session[:agg_query][:federal_state_id] = params[:federal_state_id]
  end

  def index
    @reporting_periods = ActiveRecord::Base.connection.execute("SELECT key_report FROM reporting_periods ORDER BY key_report").to_a.collect { |e| [e['key_report']]  }
    @reporting_periods.unshift ["Alle", ""]
    @act_period = ActiveRecord::Base.connection.execute("SELECT key_report FROM reporting_periods WHERE state = 1 LIMIT 1").first['key_report']

    @federal_states = ActiveRecord::Base.connection.execute("SELECT id, name FROM l_federal_state WHERE id < 18 ORDER BY name").to_a.collect  { |e| [e['name'], e['id']]  }
    @federal_states.unshift ["Alle", ""]
    @default_federal_state = theUser(session).get_default_federal_state

  end

  def result
    session[:agg_query][:columns] = params[:columns] unless params[:columns].nil?

    @datensatz = 'agglomerations'
    spalten = session[:agg_query][:columns]
    @where = 'agg_query'
    @gen = Generica.new(@datensatz, session[:user])
    @user = theUser(session)
    form_where
    if params['amount'].to_i > 0
      @user.update_attributes(:rows_per_page => params['amount'])
    end
    @data, @order = @gen.all( @conditions, @condition_parameters, spalten, @user.rows_per_page, params['offset']) #|| STANDARDLISTENLAENGE,params['offset'] || 0)
    render :template => 'layouts/list'
  end

  def edit()
    redirect_to :controller => :agglomerations, :action => :edit, :id => params[:id]
  end

  def delete
    redirect_to :controller => :agglomerations, :action => :delete, :id => params[:id]
  end

  def heading
    return self.class::PLURAL
  end

  def form_where()
    # Die Bundesländer werden nun von generica.all automatisch der where-Clause vorangestellt
    @conditions = " "
    @condition_parameters = []
    #einbau der Abfragen
    where_equals(session[:agg_query][:jahr], 'agglomerations.rep_code')
    where_greater(session[:agg_query][:untergrenze], 'agglomerations.ag_nload')
    where_smaller(session[:agg_query][:obergrenze],'agglomerations.ag_nload')
    where_equals(session[:agg_query][:grossstadt],'agglomerations.ag_city')
    where_like(session[:agg_query][:name],'agglomerations.ag_name')
    where_like(session[:agg_query][:id],'agglomerations.agg_key')
    where_like(session[:agg_query][:eu_key],'agglomerations.agg_eu_key')
    where_equals(session[:agg_query][:federal_state_id],'agglomerations.federal_state_id')
  end

  def self.form_where_mit_parameter(session)
    tmp = self.new

    tmp.conditions = " "
    tmp.condition_parameters = []

    #einbau der Abfragen
    tmp.where_equals(session[:agg_query][:jahr], 'agglomerations.rep_code')
    tmp.where_greater(session[:agg_query][:untergrenze], 'agglomerations.ag_nload')
    tmp.where_smaller(session[:agg_query][:obergrenze],'agglomerations.ag_nload')
    tmp.where_equals(session[:agg_query][:grossstadt],'agglomerations.ag_city')
    tmp.where_like(session[:agg_query][:name],'agglomerations.ag_name')
    tmp.where_like(session[:agg_query][:id],'agglomerations.agg_key')
    tmp.where_like(session[:agg_query][:eu_key],'agglomerations.agg_eu_key')
    tmp.where_equals(session[:agg_query][:federal_state_id],'agglomerations.federal_state_id')

    return [ tmp.conditions, tmp.condition_parameters ]
  end

  def self.form_spalten(session)
    return session[:agg_query][:columns]
  end

end
