#encoding: utf-8
class EinleitstellenAbfrageController < AbstractAbfrageController
  include ActiveModel::AttributeAssignment
  before_action :login_required
  layout "application"
  NAME = 'Einleitstelle'
  PLURAL = 'Einleitstellen'

  attr_accessor :conditions, :condition_parameters

  include ApplicationHelper

  def index
    @waters = ActiveRecord::Base.connection.execute("SELECT description, id FROM l_waters").to_a.collect { |e| [e['description'],e['id']]  }
    @waters.unshift ["Alle", ""]
    @reporting_periods = ActiveRecord::Base.connection.execute("SELECT key_report FROM reporting_periods ORDER BY key_report").to_a.collect { |e| [e['key_report']]  }
    @reporting_periods.unshift ["Alle", ""]
    @act_period = ActiveRecord::Base.connection.execute("SELECT key_report FROM reporting_periods WHERE state = 1 LIMIT 1").first['key_report']

    @federal_states = ActiveRecord::Base.connection.execute("SELECT id, name FROM l_federal_state WHERE id < 18 ORDER BY name").to_a.collect  { |e| [e['name'], e['id']]  }
    @federal_states.unshift ["Alle", ""]
    @default_federal_state = theUser(session).get_default_federal_state

    @river_basin_districts = ActiveRecord::Base.connection.execute("SELECT id, key FROM l_river_basin_districts ORDER BY key").to_a.collect  { |e| [e['key'], e['id']]  }
    @river_basin_districts.unshift ["Alle", ""]
  end

  def filter_columns
    @points = Generica.new('discharge_points', session[:user])
    session[:dp_query] = Hash.new()
    session[:dp_query][:jahr] = params[:jahr]
    session[:dp_query][:area] = params[:area]
    session[:dp_query][:aktiv] = params[:aktiv]
    session[:dp_query][:vorfluter] = params[:vorfluter]
    session[:dp_query][:name] = params[:name]
    session[:dp_query][:rb_name] = params[:rb_name]
    session[:dp_query][:id] = params[:id]
    session[:dp_query][:eu_key] = params[:eu_key]
    session[:dp_query][:federal_state_id] = params[:federal_state_id]
    session[:dp_query][:rb_rbd_id] = params[:rb_rbd_id]
  end

  def result
    session[:dp_query][:columns] = params[:columns] unless params[:columns].nil?
    @datensatz = 'discharge_points'
    spalten =  session[:dp_query][:columns]
    @where = 'dp_query'          #wird benötigt für csv-export
    @gen = Generica.new(@datensatz, session[:user])
    @user = theUser(session)
    form_where
    if params['amount'].to_i > 0
      @user.update_attributes(:rows_per_page => params['amount'])
    end
    @data, @order = @gen.all(@conditions, @condition_parameters, spalten, @user.rows_per_page, params['offset']) #|| STANDARDLISTENLAENGE,params['offset'] || 0)
    render :template => 'layouts/list'

  end

  def self.form_spalten(session)
    return session[:dp_query][:columns]
  end
  
  def form_where()
    @conditions = " "
    @condition_parameters = []
    # Die Bundesländer werden nun von generica.all automatisch der where-Clause vorangestellt
    #einbau der Abfragen
    where_equals(session[:dp_query][:jahr],'discharge_points.rep_code')
    where_int(session[:dp_query][:area],'discharge_points.rb_type_id')
    where_like(session[:dp_query][:name],'discharge_points.dp_name')
    where_like(session[:dp_query][:rb_name],'discharge_points.rb_name')
    where_like(session[:dp_query][:id],'discharge_points.dp_key')
    where_like(session[:dp_query][:eu_key],'discharge_points.dp_eu_key')
    where_equals(session[:dp_query][:federal_state_id],'discharge_points.federal_state_id')
    where_equals(session[:dp_query][:rb_rbd_id],'discharge_points.rb_rbd_id')
    where_int(session[:dp_query][:aktiv],'discharge_points.dp_state_active')
    where_int(session[:dp_query][:vorfluter],'discharge_points.dp_mon')
  end

  def self.form_where_mit_parameter(session)
    tmp = self.new
    tmp.conditions = " "
    tmp.condition_parameters = []

    # Die Bundesländer werden nun von generica.all automatisch der where-Clause vorangestellt
    #einbau der Abfragen
    tmp.where_equals(session[:dp_query][:jahr],'discharge_points.rep_code')
    tmp.where_int(session[:dp_query][:area],'discharge_points.rb_type_id')
    tmp.where_like(session[:dp_query][:name],'discharge_points.dp_name')
    tmp.where_like(session[:dp_query][:rb_name],'discharge_points.rb_name')
    tmp.where_like(session[:dp_query][:id],'discharge_points.dp_key')
    tmp.where_int(session[:dp_query][:aktiv],'discharge_points.dp_state_active')
    tmp.where_int(session[:dp_query][:vorfluter],'discharge_points.dp_mon')
    tmp.where_like(session[:dp_query][:eu_key],'discharge_points.agg_eu_key')
    tmp.where_equals(session[:dp_query][:federal_state_id],'discharge_points.federal_state_id')
    tmp.where_equals(session[:dp_query][:rb_rbd_id],'discharge_points.rb_rbd_id')

    return [ tmp.conditions, tmp.condition_parameters ]
  end

  # def self.form_spalten(session)
  #   return session[:dp_query][:columns]
  # end

  def edit()
    redirect_to :controller => :discharge_points, :action => :edit, :id => params[:id]
  end

  def delete
    redirect_to :controller => :discharge_points, :action => :delete, :id => params[:id]
  end

  def heading
    return self.class::PLURAL
  end

end
