#encoding: utf-8
module StartHelper

  def option_groups_from_collection_for_select(collection, group_method, group_label_method, option_key_method, option_value_method, selected_key = nil)
    collection.inject("") do |options_for_select, group|
      group_label_string = eval("group.#{group_label_method}")
      options_for_select += "<optgroup label=\"#{html_escape(group_label_string)}\" title=\"#{html_escape(group_label_string)}\">"
      options_for_select += options_from_collection_for_select(eval("group.#{group_method}"), option_key_method, option_value_method, selected_key)
      options_for_select += '</optgroup>'
    end
  end

  def options_for_select(container, selected = nil)
     container = container.to_a if Hash === container
     options_for_select = container.inject([]) do |options, element|
       text, value = option_text_and_value(element)
       selected_attribute = ' selected="selected"' if option_value_selected?(value, selected)
       options << %(<option value="#{html_escape(value.to_s)}" #{selected_attribute} title=\"#{html_escape(text.to_s)}\">#{html_escape(text.to_s)}</option>)
     end
     options_for_select.join("\n").html_safe
   end

  def required_int2de(int)
    return ['Nein','Ja','Schlüsselfeld','Automatisch'][int.to_i]
  end

  def ref_type_int2de(int)
    return ['Text',
     'Referenz',
     'Referenz auf Standardliste',
     'Ja/Nein',
     'Datum',
     'Funktion auf id von Zeile',
     'Bundeslaender (je Nutzer beschraenkt)',
     'Langtext',
     'Ganzzahl',
     'Gleitkommazahl',
     'Liste mit Bundeslandbeschraenkung',
     'Name der Sonderfunktion in surrounding_function',
     'Spezialtyp Wassertypen',
     'Spezialtyp dp_Anlagenreferenz (mit Bundeslandbschr.)'][int.to_i] rescue int
  end
end
