#encoding: utf-8
# vim: sw=2 ts=2 et syntax=ruby

class UsersController < ApplicationController
  before_action :login_required
  layout "application"

  include ApplicationHelper

  # GET /users
  # GET /users.xml
  def index
    if theUser(session).is_admin?
      @users = User.order(:team_id, :loginname).to_a
    else
      if theUser(session).is_team_admin?
        @users = User.find(session[:user]).team.users
      else
        # user sollen ihr eigenes Kennwort immerhin ändern können
        @users = [ User.find(session[:user]) ]
        # flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>".html_safe
        # redirect_to :controller => :start, :action => :index and return false
      end
    end

    if params[:sorting] != nil
      case params[:sorting]
        when "0"
          puts "BINDA"
          @users = @users.sort_by { |k| k.loginname.downcase }
        when "1"
          puts "BINDO"
          @users = @users.sort_by { |k| k.team.name.downcase }
        when "2"
          puts "BINDU"
          @users = @users.sort_by { |k| k.federal_states.map { |x| x.name }.join(' ')}
        when "3"
          @users = @users.sort_by { |k| 1 - k.disabled }
      end
    end

    respond_to do |format|
      unless session[:nojs]
        format.html # index.html.erb
        format.xml  { render :xml => @users }
      else
        format.html { render :action => 'index_nojs.html.erb' }
      end
    end
  end

  # GET /users/new
  # GET /users/new.xml
  def new
    if theUser(session).is_admin?
      @user = User.new
    else
      if theUser(session).is_team_admin?
        @user = User.new
        @user.team_id = theUser(session).team_id
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>".html_safe
        redirect_to :controller => :start, :action => :index and return false
      end
    end

    respond_to do |format|
      format.html # new.html.erb
      format.xml  { render :xml => @user }
    end
  end

  def unsudo
    if session.key?("sudo_user")
      @user = User.find(session[:sudo_user])
      @current_user = theUser(session)
    else
      flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>".html_safe
      redirect_to :controller => :start, :action => :index and return false
    end

    log_in(@user)
    redirect_to :controller => :users, :action => :index
  end

  def sudo
    if theUser(session).is_admin?
      @user = User.find(params[:id])
      @current_user = theUser(session)
    else
      flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>".html_safe
      redirect_to :controller => :start, :action => :index and return false
    end

    do_sudo(@user, @current_user)
    redirect_to :controller => :start, :action => :index
  end

  # GET /users/1/edit
  def edit_role
    if theUser(session).is_admin?
      @user = User.find(params[:id])
    else
      flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>".html_safe
      redirect_to :controller => :start, :action => :index and return false
    end

    respond_to do |format|
      format.html # edit_role.html.erb
      format.xml  { render :xml => @user }
    end
  end

  # GET /users/1/edit
  def edit_pwd
    if theUser(session).is_admin?
      @user = User.find(params[:id])
    else
      if theUser(session).is_team_admin?
        @user = User.find(params[:id])
        unless theUser(session).is_master_to?(@user)
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>".html_safe
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>".html_safe
        redirect_to :controller => :start, :action => :index and return false
      end
    end
    @user.password = ''

    respond_to do |format|
      format.html # edit_pwd.html.erb
      format.xml  { render :xml => @user }
    end
  end

  def show_state_fields
    @user = User.find(params[:id])
    @states = FederalState.order(:id).to_a.collect() {|s| [s[:name],s[:id]]}
    existing_states = @user.federal_states.collect() {|s| [s[:name],s[:id]]}
    @states.delete_if {|s| existing_states.include?(s)}

    respond_to do |format|
      format.js
    #  format.html { render :partial => "state_field"}
    end
  end

  def hide_state_fields
    @user = User.find(params[:id])
    respond_to do |format|
      format.html { render :partial => "state_btn", :locals => {:user => @user}}
    end
  end

    def show_password_fields
    @user = User.find(params[:id])
    respond_to do |format|
      #format.html { render :partial => "pwd_field"}
      format.js
    end
  end

  def hide_password_fields
    @user = User.find(params[:id])
    respond_to do |format|
      format.html { render :partial => "pwd_btn", :locals => {:user => @user}}
    end
  end

  def show_role_fields
    @user = User.find(params[:id])
    respond_to do |format|
      format.js
      #format.html { render :partial => "role_field"}
    end
  end

  def hide_role_fields
    @user = User.find(params[:id])
    respond_to do |format|
      format.html { render :partial => "role_btn", :locals => {:user => @user}}
    end
  end

  def activate
    if theUser(session).is_admin?
      @user = User.find(params[:id])
    else
      if theUser(session).is_team_admin?
        @user = User.find(params[:id])
        unless @user.team_id == theUser(session).team_id && @user.admin_level == 0
#          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
#          redirect_to :controller => :users, :action => :index and return false
          render :text => '<b style="color:red">Fehler</b>' and return false
        end
      else
#        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
#        redirect_to :controller => :start, :action => :index and return false
        render :text => '<b style="color:red">Fehler</b>' and return false
      end
    end

    @user.update_attributes(:disabled => (params[:disable] && params[:disable]!='false') ? 1 : 0 )

    respond_to do |format|
      format.js

      # TODO: Fehler- / Erfolgsmeldung anzeigen

    end
  end

  # POST /users
  # POST /users.xml
  def create
    if theUser(session).is_admin?
      @user = User.new(user_params)
    else
      if theUser(session).is_team_admin?
        @user = User.new(user_params)
        @user.team_id = theUser(session).team_id
        @user.admin_level = 0
        unless theUser(session).includes_states?(@user.federal_states)
            flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
            redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
        redirect_to :controller => :users, :action => :index and return false
      end
    end

    respond_to do |format|
      if @user.save
        flash[:notice] = 'Der Benutzer wurde erfolgreich angelegt.'
        format.html { redirect_to :action => :index}
        format.xml  { render :xml => @user, :status => :created, :location => @user }
      else
        format.html { render :action => "new" }
        format.xml  { render :xml => @user.errors, :status => :unprocessable_entity }
      end
    end
  end

  def add_state
    @state = FederalState.find(params[:federal_state]) rescue nil
    if @state.nil?
      flash[:notice] = "<b style=\"color:red\">Es existiert kein Bundesland mit dieser ID!</b>".html_safe
      redirect_to :controller => :start, :action => :index and return false
    end
    if theUser(session).is_admin?
      @user = User.find(params[:id])
    else
      if theUser(session).is_team_admin?
        @user = User.find(params[:id])
        unless theUser(session).is_master_to?(@user) && theUser(session).includes_states?([@state])
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
        redirect_to :controller => :start, :action => :index and return false
      end
    end

    respond_to do |format|
      # die zu überschreibenden attribute werden hier explizit angegeben, da sonst jemand, der nur team_admin Rechte hat seine rolle ändern
      if @user.federal_states << @state
        flash[:notice] = 'Das Bundesland wurde erfolgreich hinzugefügt.'
      else
        flash[:notice] = 'Das Bundesland konnte nicht hinzugefügt werden.'
      end
        format.html { redirect_to :action => :index }
        format.xml  { head :ok }
    end
  end

  def delete_state
    @user = User.find(params[:id])
    unless theUser(session).is_admin?
      if theUser(session).is_team_admin?
        unless theUser(session).is_master_to?(@user)
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
        redirect_to :controller => :start, :action => :index and return false
      end
    end
    @state = @user.federal_states.find(params[:federal_state]) rescue nil
    if @state.nil?
      flash[:notice] = "<b style=\"color:red\">Es existiert kein Bundesland mit dieser ID!</b>".html_safe
      redirect_to :controller => :start, :action => :index and return false
    end

    respond_to do |format|
      # die zu überschreibenden attribute werden hier explizit angegeben, da sonst jemand, der nur team_admin Rechte hat seine rolle ändern
      # TODO: flash anzeigen
      if @user.federal_states.delete(@state)
        #flash[:notice] = 'Das Bundesland wurde erfolgreich entfernt.'
      else
        #flash[:notice] = 'Das Bundesland konnte nicht entfernt werden.'
      end
        format.html { redirect_to :action => :index }
        format.xml  { head :ok }
        format.js
    end
  end

  # PUT /users/1
  # PUT /users/1.xml
  def update_pwd
    if theUser(session).is_admin?
      @user = User.find(params[:id])
    else
      if theUser(session).is_team_admin?
        @user = User.find(params[:id])
        unless (@user.team_id == theUser(session).team_id && @user.admin_level == 0) || @user.id == session[:user]
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        if params[:id].to_i == session[:user].to_i
          @user = User.find(session[:user])
        else
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
          redirect_to :controller => :start, :action => :index and return false
        end
      end
    end

    respond_to do |format|
      # die zu überschreibenden attribute werden hier explizit angegeben, da sonst jemand, der nur team_admin Rechte hat seine rolle ändern
      @user.update_attributes(:password=>params[:user][:password], :password_confirmation => params[:user][:password_confirmation])
      if @user.save
        flash[:notice] = 'Das Passwort wurde erfolgreich geändert.'
        format.html { redirect_to :action => :index }
        format.xml  { head :ok }
      else
        format.html { render :action => "edit_pwd"}
        format.xml  { render :xml => @user.errors, :status => :unprocessable_entity }
      end
    end
  end

  # PUT /users/1
  # PUT /users/1.xml
  def update_role
    if theUser(session).is_admin?
      @user = User.find(params[:id])
    else
      flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
      redirect_to :controller => :start, :action => :index and return false
    end

    respond_to do |format|
      if @user.update_attributes(user_params)
        flash[:notice] = 'Die Benutzerrolle wurde erfolgreich geändert.'
        format.html { redirect_to :action => :index }
        format.xml  { head :ok }
      else
        flash[:notice] = @user.to_json
        format.html { render :action => "edit_role" }
        format.xml  { render :xml => @user.errors, :status => :unprocessable_entity }
      end
    end
  end

  # DELETE /users/1
  # DELETE /users/1.xml
  def delete
    begin
      destroy
    rescue ActiveRecord::StatementInvalid=>e
      if e.to_s.include?("PGError: FEHLER:  Aktualisieren oder Löschen in Tabelle »users« verletzt Fremdschlüssel-Constraint »agglomerations_fk1_owner« von Tabelle »agglomerations«")
            flash[:notice] = '<b style="color:red">Der Benutzer konnte nicht gelöscht werden, da ihm Einträge zugeordnet sind.<br />
        Bitte deaktivieren Sie ihn stattdessen.</b>'.html_safe
      else
        flash[:notice] = '<b style="color:red">Der Benutzer konnte nicht gelöscht werden.</b>'.html_safe
      end

      respond_to do |format|
        format.html { redirect_to(users_url) }
        format.xml  { head :ok }
      end
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = 'Der Benutzer konnte nicht gelöscht werden, da er nicht in der Datenbank gefunden wurde.<br />
      Evtl. haben Sie doppelt auf das Kreuz geklickt. Vergewissern Sie sich bitte, ob der Nutzer nicht bereits gelöscht ist.'.html_safe

      respond_to do |format|
        format.html { redirect_to(users_url) }
        format.xml  { head :ok }
      end
    end
  end

  def destroy
    if theUser(session).is_admin?
      @user = User.find(params[:id])
    else
      if theUser(session).is_team_admin?
        @user = User.find(params[:id])
        unless (@user.team_id == theUser(session).team_id && @user.admin_level == 0) || @user.id == session[:user]
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>".html_safe
        redirect_to :controller => :start, :action => :index and return false
      end
    end
    if @user.destroy
        flash[:notice] = 'Der Benutzer wurde erfolgreich gelöscht.'
    else
        flash[:notice] = 'Der Benutzer konnte nicht gelöscht werden.'
    end

    respond_to do |format|
      format.html { redirect_to :action => :index }
      format.xml  { head :ok }
    end
  end

  private

  def user_params
    params.require(:user).permit(:loginname, :password, :password_confirmation, :team_id, :admin_level, federal_state_ids: [])
  end
end
