#encoding: utf-8
class AgglomerationsController < ApplicationController
  include DataController #stellt index, new, edit, update, create zur verfügung
  before_action :login_required
  layout "application"
  NAME = 'Agglomeration'
  PLURAL = 'Agglomerationen'
  LINK = 'https://wiki.e-kommu.de/index.php/Agglomerationen_%28gemeindliche_Gebiete%29'

  def update_plant_agg_percent
    @gen = gen
    try_update = @gen.update_plant_agg_percent(params[:id], params[:plant_id], params[:percent])
    if try_update
      render :json => {'status': 'OK'}
    else
      render :json => {'status': 'ERROR'}
    end
  end

  def add_plant
    @gen = gen
    try, msg = @gen.insert_plant_to_agglomeration(params[:agglomeration_id],params[:plant_id],params[:percent])

    if try
      flash[:plant_notice] = msg.html_safe
    else
      if msg
        flash[:plant_error] = msg.html_safe
      else
        flash[:plant_error] = 'Die Anlage konnte der Agglomeration nicht hinzugefügt werden.'
      end
    end

    render :text => plants_select_with_add(params[:agglomeration_id])

  end

  def delete_agg_plant

    @gen = gen
    try, error_msg = @gen.delete_plant_from_agglomeration(params[:agglomeration_id],params[:plant_id])

    if try
      flash[:plant_notice] = 'Die Zuordnung der Anlage zur Agglomeration wurde erfolgreich aufgehoben.'.html_safe
    else
      if error_msg
        flash[:plant_error] = error_msg.html_safe
      else
        flash[:plant_error] = 'Die Zuordnung der Anlage zur Agglomeration konnte nicht aufgehoben werden.'.html_safe
      end
    end

    render :text => plants_select_with_add(params[:agglomeration_id])
  end

  def get_plant_possibs
    show_all = params[:show_all] == 'true'
    sql_statement = "SELECT pl_key || ' - ' || pl_name as title,
                            pl_key,
                            pl_name,
                            pl.id as id
        FROM plants pl
        JOIN model.reporting_periods rp ON pl.date_to = rp.date_to and rp.state = 1"
    sql_statement << "
        JOIN agglomerations agg ON agg.federal_state_id = pl.federal_state_id AND agg.id = #{params[:id]}" unless show_all
    filter_text = params[:filter_text]
    sql_statement << "
        AND (pl.pl_key ILIKE '%#{filter_text}%' OR pl.pl_name ILIKE '%#{filter_text}%')"unless filter_text.blank?
    sql_statement << "
        ORDER BY pl_key"
    return ActiveRecord::Base.connection.query(sql_statement) #query liefert integer indizierten array, was für options_for_select hilfreich ist
  end

  def show_plant_fields

    @show_all = params[:show_all] == 'true'
    sql_statement = "SELECT agglomerations.agg_c1_ka - coalesce(SUM(agg_percent_plant),0) as diff
    FROM agglomerations
    LEFT JOIN agglomerations_plants on agglomerations.id = agglomerations_plants.agglomeration_id
    WHERE agglomerations.id = ?
    GROUP BY agglomeration_id, agglomerations.agg_c1_ka"
    @agg_c1_ka = ActiveRecord::Base.execute_sql(sql_statement, params[:id]).to_a[0]['diff']
    @plant_possibs = get_plant_possibs
    #render( :partial => 'agglomerations/plants_field', :locals => {:plant_possibs => get_plant_possibs, :id => params[:id], :show_all => show_all ? 'true' : 'false', :plant_id=>params[:plant_id]} )

    respond_to do |format|
        format.html
        format.js
    end
  end

  def get_plant_possibs_json
    render :partial => 'layouts/filter_table', :locals => {:options => get_plant_possibs}
  end

  def hide_plant_fields
    render :html => plants_select_with_add(params[:id])
  end

  def plants_select(id, locked = false)

    sql_statement = "SELECT pl.pl_key || ' - ' || pl.pl_name as title,
        pl.id as id,
        ap.agg_percent_plant as percent,
        CASE WHEN pl.pl_state_active=0 OR pl.pl_to_be_reported=0 THEN true
        ELSE false
        END as \"invalid\"
      FROM agglomerations_plants ap
      LEFT JOIN plants pl ON pl.id = ap.plant_id
      WHERE agglomeration_id = ?
      ORDER BY pl.pl_key"
    plants = ActiveRecord::Base.execute_sql(sql_statement, id).to_a

    return render_to_string( :partial => 'agglomerations/plants_btn', :locals => {:plants => plants, :id => id, :locked => locked ? 'true' : 'false'} ).html_safe, plants.length, locked
  end

  def plants_select_with_add(id)
    str, count, locked = plants_select(id)
    # m_n = ActiveRecord::Base.query_sql("select fs.uses_m_n_rel from public.agglomerations a
    #   join public.l_federal_state fs on a.federal_state_id = fs.id
    #   where a.id = ?", id)[0][0]=='t'
    # if m_n || count == 0
    #     mode = 'add'
    # elsif

    str << render_to_string( :partial => 'agglomerations/plants_add_btn', :locals => {:id => id, :locked => locked ? 'true' : 'false'} ).html_safe
    return str
  end


  #
  # successor actions for agglomerations
  #
  def get_successor_possibs
    all = params[:show_all] == 'true'
    sql_statement = "SELECT coalesce(ag.agg_key,'') || ' - ' || coalesce(ag.ag_name,'') as title,
                            ag.agg_key as key, 
                            ag.ag_name as name,
                            ag.id as id
        FROM agglomerations ag
        JOIN model.reporting_periods rp ON ag.date_to = rp.date_to and rp.state = 1
        WHERE ag.agg_state_active = 0
          AND (#{all ? 'true' : 'false'} OR ROW(ag.federal_state_id) = (SELECT federal_state_id FROM agglomerations WHERE id = ?))
          AND (ag.agg_key ILIKE ? OR ag.ag_name ILIKE ?)
        ORDER BY ag.agg_key"
    filter_text = "%#{params[:filter_text]}%"
    return ActiveRecord::Base.query_sql(sql_statement,params[:id],filter_text,filter_text) #query liefert integer indizierten array, was für options_for_select hilfreich ist
  end

  def successor_select(id)
    sql_statement = "SELECT coalesce(ag.agg_key,'') || ' - ' || coalesce(ag.ag_name,'') as title,
        ag.id as id
      FROM agglomerations_successors s
      LEFT JOIN agglomerations ag ON ag.id = s.agglomeration_pre_id
      WHERE agglomeration_succ_id = ?
      ORDER BY ag.agg_key"
    successors = ActiveRecord::Base.execute_sql(sql_statement, id).to_a
    return render_to_string( :partial => 'layouts/successor_btn', :locals => {:successors => successors, :id => id} ).html_safe
  end

  protected
  def gen
    @datensatz = 'agglomerations'
    return Generica.new(@datensatz, session[:user])
  end
end
