# encoding: utf-8
#encoding: utf-8
# Filters added to this controller apply to all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

# The StartController (start_controller.rb) was unable to read the VERSIONS.
# That is fixed but if it occurs again, look at the StartController!

VERSION = "0.5.9"
VERSIONS = [
            ["0.1.0", "", "04.06.2010"],
            ["0.1.1", "Neugestaltung des Erscheinungsbildes", "17.06.2010"],
            ["0.1.2", "Vereinheitlichung der NUTS- und Anlagen-DropDownListen in das Schlüssel-Name Format", "09.07.2010"],
            ["0.1.3", "Filter-Funktion für zu große DropDownListen (NUTS, zugehörige Anlagen, Vorgänger) hinzugefügt.<br>
                      Diese kann durch Klick auf die Lupe neben dem Auswahlfeld aufgerufen werden.", "20.07.2010"],
            ["0.1.4", "Im \"Anlage Bearbeiten\" Formular werden nun zugeordnete Agglomerationen angezeigt.", "21.07.2010"],
            ["0.1.5", "Tabellen können durch Klick auf Spaltennamen nach ein oder mehreren Spalten sortiert werden.<br>
          Die Anzahl der pro Seite anzuzeigenden Datensätze wird sich nun für jeden Nutzer gemerkt.<br>
          Die in Version 0.1.3 eingeführte Filter-Funktion funktioniert nun unabhängig von Groß- und Kleinschreibung.<br>
          Einleitstellen können nun auch nach Name abgefragt werden.", "29.07.2010"],
            ["0.1.6", "Im Formular werden nun bedingte Pflichtfelder gelb markiert, sofern diese nicht Berichtspflichtkonform sind.", "24.09.2010"],
            ["0.1.7", "Objekte verlinken sich in Formular und Ergebnisstabelle bei Referenzen gegenseitig", "27.09.2010"], #inkl. datenbankänderung in risa_select_* funktionen
            ["0.1.8", "Implementation der Qualitätssicherungsabfragen mit Abgleichsfunktion für nicht mehr vorhandene EU-Schlüssel.", "06.10.2010"],
            ["0.1.9", "CSV-Import: Erhebliche Beschleunigung des Einleitstellenimports.<br>
          Diverse Korrekturen (leere Statusmeldungen akzeptieren, gesperrte Sätze melden, rep_code-Meldung überprüfen und ignorieren, etc.).<br>
          Neuer Importmodus \"Überschreiben und leere Felder löschen\".<br>
          Kontrolle der Importrechte überarbeitet", "02.11.2010"],
            ["0.2.0", "Zusammenführung und Verbesserung der Unvollständigkeits- und Inkonsistenzprüfung zu einer QS mit enstprechender Einfärbung im Formular.<br>
              Zugeordnete Einleitstellen werden nun im Anlagenformular angezeigt", "08.11.2010"],
            ["0.2.1", "Reimplementation der CSV-Export-Funktion.<br>
          Korrektur der Unvollständigkeitsprüfung bezüglich der Überwachungswerte.<br>
          Vorgängerobjekte werden nun auch in der Ergebnisstabelle aufgelistet.<br>
          Der Navigationsleistenknopf `Datenfelder` bietet eine Liste der Datenfelder mit einigen Details. Für eine ausführlichere Dokumentation sollte aber weiterhin das Wiki zur Rate gezogen werden.", "02.12.2010"],
            ["0.2.2", "Anteil des Abwassers von der Agglomeration zur Anlage kann nun editiert werden.", "12.01.2011"],
            ["0.2.3", "Neue Spalten über Behandlung der Schmutzfracht eingeführt.", "22.08.2011"],
            ["0.2.4", "CVS-Import versteht nun mehrzeilige Einträge und versteht das Zeichensatzkommando.", "02.09.2011"],
            ["0.2.5", "Gesperrte Felder werden nun beim Import ignoriert.", "14.09.2011"],
            ["0.2.6", "Toleranz für numerische Unstimmigkeiten.<br />
          Korrektur QS Unvollständige Einleitstellen und Agglomerationen.<br />
          Hinweis wenn Agglomeration inaktiver oder nicht berichteter Anlage zugewiesen wird.", "14.09.2011"],
            ["0.2.7", "QS: Fehlender Einleitstellen werden nur für aktive, berichtete Anlagen bemängelt.<br />
          QS: Toleranzen auf 0,1% erhöht.", "18.10.2011"],
            ["0.2.8", "Upgrade der Rails-Version auf 3.0 und Korrektur von überholtem Code", "31.10.2013"],
            ["0.3.0", "Abschluss der Migration auf Rails 4.0.2 und Ruby 2.1", "14.01.2014"],
            ["0.3.1", "Anpassungen mit Schwerpunkt auf QS-Prüfungen und Optimierung des Berichtprozesses. Einführung der Möglichkeit Objekte aus anderen Bundesländern zu verwalten, sofern vom Eigentümer deligiert", "11.12.2015"],
            ["0.3.2", "Migration Ruby 2.1 auf 2.2", "21.10.2016"],
            ["0.3.3", "Migration Ruby 2.2 auf 2.3", "28.10.2016"],
            ["0.3.4", "Migration Rails 4.0 auf 4.1", "09.11.2016"],
            ["0.3.5", "Migration Rails 4.1 auf 4.2", "22.11.2016"],
            ["0.3.6", "Migration Rails 4.2 auf 5.0", "30.11.2016"],
            ["0.4.0", "Arbeiten zur Vorbereitung der Datenkampagne DE2018 und zur Ergänzung der QS-Prüfungen sowie der Erhöhung Anwenderfreundlichkeit:<br />
          Erweiterung der QS-Prüfungen um Großstadtverwendung und Warnung bei Abweichung des Bundeslandes der Agglomeration von dem der Großstadt,<br />
          Aktualisierung der Kapitelnummern der QS-Prüfungen für Fehlerprüfungen Vollständigkeit und Konsistenz,<br />
          Ergänzung der \"Zur Online-Dokumentation der Prüfung \"-Links für die (z. B. ersten vier Vollständigkeitsprüfungen),
          für die der Link bislang nicht angezeigt wurde,<br />
          Aktualisierung der NUTS-Regionen (von DESTATIS) und der BigCity-(Großstadt-)Liste (von EIONET),<br />
          wobei die BigCity-Liste anschließend um eine Bundeslandinformation ergänzt wurde,<br />
          neue Importprüfung für NUTS-Regionen, die sicher stellt, dass zum Berichtsperiodenstichtag der zu importierende NUTS-Eintrag auch gültig ist und
          folglich veralte NUTS-Einträge nicht mehr importiert werden können,<br />
          Einführung zweier Karten-Links (OpenStreetMap OSM und Google) in diejenigen Formulare, die Koordinaten enthalten,<br />
          Ergänzung des Anlagen-Links im Formular der Einleistelle, damit von der Einleitstelle zur Anlage gewechselt werden kann,<br />
          Ergänzung eines bzw. zweier Links im jeweiligen Formular (Agglomeration, Anlage, Einleitstelle, landesspez. Daten)
          zum Wechsel zur Vorperiode und aus einer Vorperiode auch zum Wechsel zur Folgeperiode und<br />
          Überarbeitung der QS-Dokumentation im Wiki.", "17.02.2020"],
            ["0.4.1", "Erweiterung der Abfragen um das Bundesland und den EU-Key, bei Einleistellen auch das Flusseinzugsgebiet,<br />
          Abfragen starten nun mit Voreinstellung der aktiven Berichtsperiode und, sofern nur ein Bundesland
          bearbeitet werden darf, mit der Voreinstellung des Bundeslandes,<br />
          das Einleistellenformular wurde korrigiert, so dass eine neue Einleitstelle nun wieder mit einer Anlage
          verknüpft werden kann.", "19.02.2020"],
            ["0.4.2", "Überarbeitung des CSV-Imports, so dass Objekte (Agglomerationen, Anlagen, Einleitstellen),
          die mittels ihres Keys gesucht werden, nicht nur aus der Menge der Objekte des eigenen Bundeslandes
          stammen können, sondern auch aus anderen Bundesländern, wenn sie denn vom eigenen Bundesland verwaltet
          werden.<br />
          Beseitigung eines Fehlers beim Import von Einleitstellen im Überschreib-Modus, der bei Verwendung
          von \"Zugehörige Anlage\" (pl_id_ref) auftrat.", "19.02.2020"],
            ["0.4.3", "Beseitigung eines Fehlers beim Import von Agglomerationen bzgl. der Großstädte:<br />
          Es werden nun nur die für die aktuelle Kampagne gültigen Großstädte für den Import verwendet.", "23.03.2020"],
            ["0.4.4", "Beseitigung eines Fehlers in der Qualitätssicherung<br />
          \"Konsistenz - Agglomerationen mit Syntaxfehler im EU-Schlüssel (6.1.a)\":<br />
          Der Begriff \"Anlage\" in den Spaltenüberschriften von ID und Name wurde durch \"Agglomeration\" ersetzt.",
             "02.06.2020"],
            ["0.4.5",
          "Import von Anlagen<br />
          Es wird nun auch beim Import von Anlagen zunächst mit einem ggf. gelieferten EU-Schlüssel
          ein korrespondierender Datensatz in der Datenbank gesucht. So kann sich nun auch bei Anlagen
          der Land-interne Schlüssel ändern und trotzdem kann ein ggf. bereits vorhandener Anlagendatensatz
          beim Import mit Hilfe des (hoffentlich unveränderten!) EU-Schlüssels gefunden werden.
          Dies ist zur Vermeidung von Duplikaten notwendig.<br />
          Erweiterung kleine Kläranlagen<br />
          Datenbank und Anwendung wurden um die Felder zur KOM-Exportunterdrückung für die
          gefahrlose Aufnahme kleiner Kläranlagen (50 EW bis < 2000 EW) bei Agglomerationen (ag_com_report),
          Anlagen (pl_com_report) und Einleitstellen (dp_com_report) erweitert.<br />
          Ist dort kein Wert eingetragen (statt Ja/Nein), wird auch nicht exportiert.<br />
          Bei den Daten der Berichtskampagne DE2018 wurden diese Felder generell mit „Ja“
          gefüllt, denn es handelt sich durchgängig nicht um kleine Kläranlagen (50 EW bis < 2000 EW).
          Somit sind die Einträge beim Vortragen der Daten von DE2018 auf DE2020 zumindest für
          die Anlagen ab 2 kEW bereits korrekt gesetzt.<br />
          Ist eine Agglomeration etc. auf „X wird dieses Jahr berichtet“ = Nein gesetzt,
          wird sie natürlich trotzdem nicht regulär an KOM berichtet.<br />
          QS-Prüfungen im Zusammenhang mit kleinen Kläranlagen<br />
          Die QS-Prüfungen wurden angepasst, so dass es durch die Aufnahme von kleinen Kläranlagen
          nicht zu Fehlermeldungen kommt, denen kein echter Fehler zugrunde liegt.
          ENDA hat freundlicherweise einen Datensatz mit kleinen Kläranlagen erhalten.<br />
          Erweiterung INSPIRE-IDs<br />
          Datenbank und Anwendung wurden bei der Anlage um ein Feld (pl_inspire_id) zur Aufnahme der
          INSPIRE-IDs (IIDs) für Anlagen ab 100 kEW erweitert. Dafür wurde eine Liste der IIDs angelegt,
          die Gültigkeitszeiträume trägt, um sich von Berichtsperiode zu Berichtsperiode ändernde
          IIDs aufnehmen zu können.<br />
          UBA und ENDA haben, wo dies möglich war, bereits in den Daten der Berichtsperiode DE2018
          die Anlagen (ab 100 kEW) mit der Verknüpfung zur IID versehen, um den diesbezüglichen
          Zusatzbearbeitungsaufwand in DE2020 möglichst gering zu halten. (Wenn die Daten von DE2018
          auf DE2020 vorgetragen werden, ist die IID dann ggf. bereits vorhanden.)<br />
          Importrückmeldungen korrigiert<br />
          Der Importer liefert beim Import von Agglomerationen/Anlagen/Einleistellen keine
          Fehlermeldung mehr, wenn das Objekt noch nicht in der Datenbank vorhanden war
          und gibt stattdessen einen Hinweis aus.<br />
          Interne Betriebsführung<br />
          Der Anwendungsserver und der Datenbankserver wurden neu aufgesetzt und dabei
          mit neueren Softwareversionen versehen.",
             "15.10.2020"],
            ["0.4.6", "Fehlerkorrekturen und eine Verbesserung:<br />
          Beseitigung eines Fehlers beim Export der verschiedenen Abfrageergebnisse,<br />
          der CSV-Export (alle Dateien) schreibt die Zahlen der \"agg_percent_plant\" (Prozentualer Anteil<br />
          der in der Agglomeration erzeugten Belastung, die in der zugeordneten Kläranlage gereinigt wird)<br />
          nun wieder mit Dezimalkomma und<br />
          die Ausgabe des CSV-Exports (alle Dateien) erfolgt nun sortiert.", "01.02.2022"],
            ["0.4.7", "Fehlerkorrektur am Export der Einleitstellen, Änderungen am Importverhalten,
          Fehlerkorrekturen an der Anwendungsoberfläche<br />
          Der Export der Einleitstellen exportiert nun auch die Verknüpfung zur Anlage.<br />
          Der Importer gibt bei Fehler- und Warnmeldungen nun die EU-Schlüssel der betreffenden Objekte mit
          aus, wenn diese in der Importdatei angegeben sind.
          Das Einleistellenformular zeigt nun Wasser- und Grundwasserkörper auch dann an, wenn diese
          aus einem anderen Bundesland stammen.<br />
          Die Änderung des prozentualen Anteils der in der Agglomeration erzeugten und in Kläranlagen gereinigten
          Abwasserbelastung, der in der zugehörigen Anlage gereinigt wird (agg_percent_plant),
          ist nun sowohl im Agglomerations- als auch im Anlagenformular möglich.<br />
          Der Import von Wasserkörpern, Großstädten und NUTS-Regionen akzeptiert nun auch solche, die aus
          einem anderen Bundesland stammen. Das ist fachlich selten zwingend erforderlich,
          da alle Bundesland-grenzüberschreitenden Wasserkörper jeweils zweimal existieren und
          auch die NUTS-Region und die zugehörige Großstadt aus demselben Bundesland
          wie die Agglomeration stammen sollten.<br />
          Da diese Unsauberkeiten jedoch aus vergangenen Kampagnen nun auch im aktuellen Datenbestand
          sind und das Ergebnis des Exports re-importierbar sein sollte, wurden diese Änderungen
          durchgeführt.", "04.03.2022"],
            ["0.4.8", "Fehlerkorrektur und Verbesserung am Importer<br />
          Der Importer erkennt nun Leerzeilen, meldet diese und ignoriert sie.<br />
          Der Export aus Excel gibt mitunter beim CSV-Export mehr Zeilen aus, als tatsächlich
          in der Tabelle gefüllt sind. Diese werden als Zeilen mit ausschließlich Trennzeichen
          am Ende mit ausgegeben.<br />
          Durch einen nun behobenen Fehler wurde die letzte echte Datenzeile dann so oft wiederholt,
          wie sich Leerzeilen am Ende befanden, ggf. inklusive der Meldung von Fehlern oder Warnungen
          aus der letzten echten Datenzeile.", "11.03.2022"],
            ["0.4.9", "Fehlerkorrektur am Importer<br />
          Der Importer verarbeitet nun auch sehr lange Ziffernfolgen in agg_key, pl_id und dp_key
          als Zeichenkette und wandelt diese nicht versehentlich in Zahlen (z. B. 9,7751E+12) um.",
          "14.03.2022"],
            ["0.5.0", "Fehlerkorrektur QS kleine Anlagen/Einleitstellen<br />
          Die QS-Prüfung \"Einleitstellen mit alten Anlagen (interne Prüfung)\" ist nun
          für Einleistellen kleiner Kläranlagen (51-1999 EW) deaktiviert.",
             "23.03.2022"],
            ["0.5.1", "Fehlerkorrektur Importer<br />
          Wenn der Importmodus \"Überschreiben und leere Felder löschen\" gewählt wurde und der Importdatensatz
          eine Spalte für den rep_code (die Berichtsperiode) enthielt und die Angabe der Berichtsperiode
          (z. B. DE2020) unterlassen wurde, kam es beim Versuch der Aktualisierung des Datensatzes auf
          der Datenbank zu einem Fehler (\"We're sorry, but something went wrong.\").<br />
          Das Problem ist behoben.",
             "24.03.2022"],
            ["0.5.2", "Fehlerkorrektur Importer<br />
          Wenn in der Importdatei für Einleitstellen sowohl ein Landschlüssel (dp_key) als auch ein
          EU-Schlüssel (dp_eu_key) angegeben werden und diese auf unterschiedliche Einleitstellen
          zeigen, konnte es zu einem Datenbankfehler kommen.<br />
          Diese Art von Fehlern wird nun detektiert, eine entsprechende Fehlermeldung ausgegeben
          und die betreffende Datenzeile wird jeweils nicht importiert.<br />
          ACHTUNG: Diese Fehlererkennung ist bei Agglomerationen und Anlagen noch nicht
          programmiert.",
             "28.03.2022"],
            ["0.5.3", "Fehler- und Meldungskorrekturen Importer<br />
          Wenn in der Importdatei für Agglomerationen oder Anlagen sowohl ein Landschlüssel
          als auch ein EU-Schlüssel angegeben werden und diese auf unterschiedliche Objekte
          zeigen, konnte es zu einem Datenbankfehler kommen.<br />
          Diese Korrektur für Agglomerationen und Anlagen fehlte in Version 0.5.2 und ist nun
          programmiert.<br />
          Doppelte Meldungen über nicht gefundene Objekte, unabhängig ob mit Land- oder EU-
          Schlüssel, unterbleiben nun.",
             "29.03.2022"],
            ["0.5.4", "Fehlerkorrektur Importer<br />
          Im Modus Überschreiben und leere Felder löschen kam es beim Import von Einleitstellen
          zu einem Fehler, der durch die Korrektur des Exports der Einleitstellen verursacht
          wurde.",
             "29.03.2022"],
            ["0.5.5", "Fehlerkorrektur Importer<br />
          Bei der Suche nach Großstädten kam es bereits beim Hochladen zu einem Fehler.",
             "29.03.2022"],
            ["0.5.6", "Deaktivierung weiterer QS-Prüfungen für Anlagen 51..1999 EW:<br />
          * Einleitstellen mit inaktiven Anlagen (1.v.5.2)<br />
          * Agglomerationen mit inaktiven Anlagen (1.v.5.1)
          sind nun auch von der Prüfung ausgenommen.",
             "31.03.2022"],
            ["0.5.7", "Fehlerkorrektur Einleistellenformular<br />
          Das Einleitstellenformular zeigt nun eine verknüpfte Anlage auch dann an, wenn
          der Datensatz freigegeben, also für die Bearbeitung gesperrt ist.",
             "02.06.2022"],
            ["0.5.8", "Umzug auf eigene Domain<br />
          Sowohl die Webanwendung als auch die Hilfe (Wiki) sind auf die neue Domain e-kommu.de
          umgezogen und nun unter https://app.e-kommu.de und https://wiki.e-kommu.de erreichbar.
          Das Impressum (sowohl das über die Login-Seite erreichbare, also auch das von innerhalb
          der Anwendung erreichbare) wurde aktualisiert.",
             "30.08.2022"],
            ["0.5.9", "Hilfe-Menü angelegt<br />
          Das Menü wird um den Punkt \"Hilfe\" erweitert. Dort finden sich die Links zum Wiki
          sowie zu den Video-Tutorials.",
             "02.09.2022"],
]


class ApplicationController < ActionController::Base
  protect_from_forgery with: :exception

  include LoginHelper
  helper :all # include all helpers, all the time
  #protect_from_forgery with: :null_session

  include ApplicationHelper

#  def rescue_action(exception)
#    case exception
#    when ActiveRecord::RecordNotFound, ActionController::UnknownAction, ActionController::RoutingError
#      redirect_to errors_path(404), :status=>301
#    else
#      redirect_to errors_path(500)
#    end
#  end

  def login_required
    unless theUser(session)
      flash[:notice] = "Sie müssen eingeloggt sein, um diese Seite zu sehen!".html_safe
      redirect_to :controller => :login, :action => :index, :goal => request.path_parameters['controller'] and return false
    end
    if theUser(session).disabled == 1
      flash[:notice] = "Ihr Benutzerkonto wurde deaktiviert! Bei Fragen wenden Sie sich bitte an Ihren Systemadministrator.".html_safe
      redirect_to :controller => :login, :action => :logout and return false
    end
    return true
  end

  # This seems to be superfluous but I am frightened, so I keep it as comment (2021-10-15)
  # def VERSION
  #   ::VERSION
  # end

end

class Float
  def to_3signdigits

    f = ("%.3G" % self).to_f

    if f >= 100
      s = "%.0f" % f
    elsif f >= 10
      s = "%.1f" % f
    elsif f >= 1
      s = "%.2f" % f
    elsif f >= 0.1
      s = "%.3f" % f
    elsif f >= 0.01
      s = "%.4f" % f
    elsif f >= 0.001
      s = "%.5f" % f
    elsif f >= 0.0001
      s = "%.6f" % f
    elsif f >= 0.00001
      s = "%.7f" % f
    elsif f >= 0.000001
      s = "%.8f" % f
    elsif f >= 0.0000001
      s = "%.9f" % f
    else
      s = "%.10f" % f
    end

    return s
  end
end
