#encoding: utf-8
class CsvController < ApplicationController
  before_action :login_required
  layout "application"

  include ApplicationHelper

  def index
    unless theUser(session).can_import_any?
      flash[:notice] = "Sie haben keine Importberechtigungen"
      redirect_to :controller => :start
    end
    unless theUser(session).can_write?
      flash[:notice] = "Sie haben keine Schreibberechtigungen, daher können sie keine CSV-Dateien importieren"
      redirect_to :controller => :start
    end
  end

  # This method is triggered by the "Import durchführen" button on the form
  def upload
    if params[:sfile]
      @csv_file = CsvFile.new(params[:sfile], session[:user], params[:mode], session[:session_id], session)
      @csv_file.process_csv_file

      puts "Serialisierung beginnt #{now}"
      # tempfiles werden automatisch abgeräumt, wenn der Prozess terminiert. Daher diese merkwürdige Logik.
      # ... eigentlich sogar schon, wenn sie aus dem Scope gehen ...
      require 'tempfile'
      tf = Tempfile.new('ekommu-import', '/dev/shm')
      session[:tmpFilePath] = tf.path + '-'
      tf.close!
      tf = File.new(session[:tmpFilePath], 'w')
      @csv_file.cleanupForSerialization
      Marshal::dump(@csv_file, tf)
      puts "Serialisierung endet #{now} - marshalled to #{tf.size} bytes"
      tf.flush
      tf.close
      # flash[:notice] = "Hotzenplotz sagt: die Länge des serialisierten ist #{tf.size}; schreibe nach #{tf.path}".html_safe
    else
      # @csv_file = CsvFile.new(nil, nil, nil, nil, nil)
      # @csv_file.create_upload_error
      flash[:notice] = "<b style='color:red'>Bitte wählen Sie zunächst eine Datei für den Import aus.</b>".html_safe
      redirect_to :controller => :csv
    end
  end

  def commit
    # IMPORT-Action
    # flash[:notice] = "Hotzenplotz sagt: wir lesen #{session[:tmpFilePath]}<br/>".html_safe
    puts "De-Serialisierung beginnt #{now}"
    tf = File.new(session[:tmpFilePath])
    @csv_file = Marshal::load(tf)
    @csv_file.reinsertSessionAfterDeserialization(session)
    puts "De-Serialisierung endet #{now}"
    @csv_file.import
    File.delete(tf.path)
  end

  def discard
    tf = File.new(session[:tmpFilePath])
    File.delete(tf.path)
    redirect_to :controller => :start
  end

end
