#encoding: utf-8
module CsvExportHelper

  def numberise (text)
    return nil if text.nil?

    text = text.to_s
    text = text.gsub(/ /u, '');
    if /[^.]+[.].+[,]/u.match(text)
      # 300.000,0 dt -> 300000.0
      text = text.gsub(/[.]/u, '')
      text = text.gsub(/[,]/u, '.')
    elsif /[^,]+[,].+[.]/u.match(text)
      # 300,000.0 en -> 300000.0
      text = text.gsub(/[,]/u, '')
    else
      text = text.gsub(/[,]/u, '.')
    end
    return text
  end

  def de_numberise (text)
    return nil if text.nil?

    text = text.to_s
    text = text.gsub(/ /u, '');
    if /[^.]+[.].+[,]/u.match(text)
      # 300.000,0 dt -> 300000,0
      text = text.gsub(/[.]/u, '')
    elsif /[^,]+[,].+[.]/u.match(text)
      # 300,000.0 en -> 300000,0
      text = text.gsub(/[,]/u, '')
      text = text.gsub(/[.]/u, ',')
    else
      text = text.gsub(/[.]/u, ',')
    end
    return text
  end


end
