#encoding: utf-8
module InkonsistenzenHelper
   def prepare_columns
     @columns.collect do |col|
       unless col[:row_id].nil?
          col[:url_options] = {
            :controller => col[:controller].nil? ? @datensatz : col[:controller],
            :action => (col[:action].nil? ? 'edit' : col[:action]),
          }
          col[:link_txt] ||= content_tag(:span, content_tag(:i, "", class: "fa fa-pencil", title: "Bearbeiten"))
          col[:link_title] ||= 'Bearbeiten'
          col[:human_name] ||= 'Bearbeiten'
       else
         col
       end
       col
     end
   end

   def make_link(row,col)
     col[:url_options][:id] = row[col[:col_name].nil? ? 'row_id' : col[:col_name]]
     return link_to(col[:link_txt], col[:url_options], {:title => col[:link_title], :target => '_BLANK'}).html_safe
   end

   def format_link_list(id_pipe_txt_arr,url_options)
     result = []
     id_pipe_txt_arr.split("\n").each do |id_pipe_txt|
       id,*txt = id_pipe_txt.split('|')
       txt = txt.join('|')
       url_options[:id] = id
       result << link_to(content_tag(:span, content_tag(:i, "", class: "fa fa-search inherit-color"))+txt, url_options, {:title => 'Ansehen', :target => '_BLANK'})
     end
     return result.join("<br/>\n").html_safe
   end
end
