class ReportingPeriod < ActiveRecord::Base
  self.table_name = 'reporting_periods'
  self.primary_key = 'key_report'

  validates :key_report, presence: true
  validates :state, presence: true

  def self.get_current
    begin 
      return ReportingPeriod.find_by(state:1)
    rescue 
      return ReportingPeriod.order(key_report: :desc).take
    end
  end
end
