class Team < ActiveRecord::Base
   #has_many :permissions_teams, :dependent => :destroy
   #has_and_belongs_to_many :permissions

   has_many :permissions_teams, :dependent => :destroy
   has_many :permissions, :through => :permissions_teams

   has_many :users, -> { order(:loginname) }

   validates_uniqueness_of :name

   def permission_ids=(ids)
      PermissionsTeam.delete_all("team_id = "+self.id.to_s)
      for id in ids do
         PermissionsTeam.new({:team_id => self.id, :permission_id => id}).save
      end
   end
end
