#!/usr/bin/ruby
# -*- coding: utf-8 -*-
#
# e-Kommu XML Export
# (c) ENDA GmbH & Co. KG, 2016, 2014, 2013, 2012, 2011, 2010
#
# by mlt
#
# Main Purpose:
# Read Data from e_kommu Postgres database and write Art. 15 XML export file for the COM
# Side Purpose:
# Read some trivial hard coded values and create Art. 17 XML export file for the COM
#
# Hints:
# XML-File is found by MY_CONSTANT_XML_PATH constant here in this file
# Database connection is set in xml_exporter_rb.get_connection
#
# dnf -y install ruby-libglade2
# gem install dbi
# gem install dbd-pg
# gem install pg
# 
# Suggested future improvements
# * File Selection to replace MY_CONSTANT_XML_PATH
# * Automated file name generation by usage of deployment campain id (e.g. "DE2014"),
#   art15/art17-phrase and iso date
# * Automated zipping when schema validation succeeds
# * Implementation of pre-Tests for inactive discharge points and plants, at least on the
#   already documented and know problem bears pl_kan_id (TP) and
#   dp_surface_id and plant_id (DP)
#
# Rel-1-3-5
#   2016-08-02 mlt: XML-Art.15-Export erweitert um Art. 5.4-Angaben zu Anlagenzahl, -kapazität
#   und -frachten N in/out, P in/out sowie einem XML-Kommentar zur Differenzierung von KKA und KA
# Rel-1-3-4
#   2016-06-29 mlt: XML-Art.15-Export mit Prüfung der Tabelle agglomerations_plants versehen
# Rel-1-3-3
#   2016-06-28 17:58 mlt: XML-Art.15-Export mit Dummy-Werten versehen
# Rel-1-3-1
#   2016-06-17 13:00 mlt: Finished implementation works for art. 17 and adjustment works
#   for art. 15 XML export
#
# Rel-1-3-0
#   2016-06-13 11:00 mlt: Inception of implementation works for art. 17 XML export
#
# Rel-1-2-2
#   2014-08-22 14:53 mlt: xml_art15_exporter.rb: def get_connection entschärft und umbenannt, damit
#   auf keinen Fall die Verbindungsinformationen in das öffentliche Repository gelangen.
#   Für interne Nutzung: # vor load 'get_connection.rb' entfernen, get_connection von mlt beschaffen.
#
# Rel-1-2-1
#   2014-05-27 11:37 mlt: Plants bekommen keinen uwwE-PRTRCode mehr. Ist auch nicht Schema-konform.
#
#
#

begin
  load 'xml_art15_exporter.rb'
  load 'xml_art15_checker.rb'
  load 'xml_art17_exporter.rb'
  load 'get_connection.rb'
  require 'libglade2'
  require '../../ruby_enda/lib/stnd'
  load 'test1.rb'
  load 'gui_callbacks.rb'
  require 'rubygems'
  require 'xml/libxml'
  # require 'iconv'
  require 'logger'
  # require 'activerecord'
  require 'dbi'

  include RbConfig

  APPNAME = "e-Kommu XML Exporter"
  APPVERSION = "1.3.5"
  ABOUT = <<EOS

(c) ENDA, 2016, 2014, 2013, 2012, 2011, 2010

Besuchen Sie die Homepage der Firma ENDA unter
https://enda.eu
für Informationen über die ENDA GmbH & Co. KG
EOS

  MY_CONSTANT_XML_PATH = "../daten/e_kommu.xml"
  MY_CONSTANT_ART17_XML_PATH = "../daten/e_kommu_art17.xml"
  # MY_CONSTANT_XML0_PATH = "../daten/XML0_T1.xml"
  # MY_CONSTANT_XML0_PATH = "../daten/XML0_T2.xml"
  # MY_CONSTANT_XML0_PATH = "../daten/XML0_T3.xml"
  # MY_CONSTANT_XML0_PATH = "../daten/XML0_T4.xml"
  
  class Gui
    include Gui_callbacks
    # include GetText
    attr :glade

    def initialize(path_or_data, root = nil, domain = nil, localedir = nil, flag = GladeXML::FILE)
      # bindtextdomain(domain, localedir, nil, "UTF-8")
      @glade = GladeXML.new(path_or_data, root, domain, localedir, flag) {|handler| method(handler)}
    end
  end

  # Main program
  if __FILE__ == $0
    # Set values as your own application.
    PROG_PATH = "xml_export.glade"

    # Einziger Unterschied, wenn diese Zeile kommt, ist, dass beim About-Dialog der "Mitwirkende" Knopf noch ein kleines Sternchen hat:
    # Gnome::Program.new(Test4::NAME, Test4::VERSION)

    gui = Gui.new(PROG_PATH, nil, APPNAME)
    print gui.glade.to_s, " Glade Filename: <", gui.glade.filename, ">\n"

    Gtk.main
  end

rescue Exception => rumms
  puts "Unexpected Exc <#{rumms}>"
  print rumms.backtrace.join("\n")
end
