#!/usr/bin/ruby
# -*- coding: utf-8 -*-
#
# e-PRTR P-Modul HTML Generator
# (c) 2016, 2013 Matthias Lüttgert, 2012 Rory Michele, ENDA GmbH & Co. KG
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# Please note and understand the notices and instructions in the README-file.
#
#
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
#
# Bitte beachten Sie auch die Hinweise in der README-Datei vor Verwendung der Software.
#
#


require 'rubygems'
#~ require 'debugger'; debugger

require 'erb'
require_relative "db_controller.rb"
require_relative 'entry.rb'
require_relative 'betrieb.rb'
require_relative 'freis_manager.rb'
require_relative 'abfall_manager.rb'
require_relative 'gk_collecting_array.rb'
require_relative 'aggregating_array.rb'
require_relative 'render_engine'
require_relative 'freis_array'

APPNAME = "E-PRTR P-Modul HTML Renderer"
APPVERSION = "1.2.0"
# CHANGES
# 1.0.1:
# - Separate Freisetzung für CO2 nicht-biogener Anteil
# - Hinweis wenn kein Abfall in einer Kategorie angegeben wurde
# - Überschriften um ein Level erhöht (Zahl nach h um 1 verringert)
# - colspan für Vertraulichkeitslegenden im Tabellenfuß angepasst
# - Alternativtext für Karte angegeben
# - Voreingestellte Zoomstufe der Karte auf 1500 erhöht
# 1.0.2:
# - Mehr Details ausblenden wenn Vertraulichkeit
# - Vertraulichkeitslegende Betrieb trotzdem anzeigen
# - auch optionale Betriebs-Felder und Nebentätigkeiten mit &mdash; belegen wenn leer
# 1.0.3:
# - NBioFracht ab 2009
# - EPS-3: Keine Überschriften generieren, wenn keine Emission (Überschriften ohne Stoffe weglassen)
# 1.0.4:
# - wegen Mail von Fr. Grimm (UBA) vom 02.05.2013
# - 1. vbstaat mit ausgeben im HTML
# - 2. nicht nach PRTR berichtet Überschrift angepasst
# - nicht nach PRTR berichtet Überschrift Weglassen wenn zu allen Kategorien etwas angegeben
# 1.0.5:
# - nbiofracht nicht ausgeben wenn =jfrach oder null
# 1.1.0:
# - Umstellung auf englische Ausgabe
# 1.2.0:
# - Migration Ruby v1.9 nach v2.3
ABOUT = <<EOS


(c) ENDA GmbH & Co. KG, 2016, 2013, 2012;

Besuchen Sie die Homepage der Firma ENDA unter
https://enda.eu
für Informationen über die ENDA GmbH & Co. KG
EOS

$lang = { 'de' => true, 'en' => true, 'fr' => false }

class Float
  def to_3signdigits

    f = ("%.3G" % self).to_f

    if f >= 100
      s = "%.0f" % f
    elsif f >= 10
      s = "%.1f" % f
    elsif f >= 1
      s = "%.2f" % f
    elsif f >= 0.1
      s = "%.3f" % f
    elsif f >= 0.01
      s = "%.4f" % f
    elsif f >= 0.001
      s = "%.5f" % f
    elsif f >= 0.0001
      s = "%.6f" % f
    elsif f >= 0.00001
      s = "%.7f" % f
    elsif f >= 0.000001
      s = "%.8f" % f
    elsif f >= 0.0000001
      s = "%.9f" % f
    else
      # s = "%.10f" % f
      s = "%.2f" % f
    end

    return s
  end

  def to_html(numberof_integral_places = nil)
    # zweck dieser funktion ist, eine kommazahl in einzelnen spans (für gleichanordnung) mit numberof_integral_places vorkommastellen (oder platzhaltern) darzustellen
    # zweck ist einfacher das ausrichten am komma
    parts=self.to_3signdigits.split('.')
#    puts "#{identifier} #{@data[identifier]} mit #{numberof_integral_places} Stellen"
    i=0
    numberof_integral_places ||= parts[0].length
    integral_digits = parts[0].reverse
    integral_digits_html = []
    while i <= numberof_integral_places-3
      integral_digits_html.push (i >= integral_digits.length ? '<span class="digit">&nbsp;</span>' : %Q^<span class="digit">#{integral_digits[i]}</span>^)
      integral_digits_html.push (i+1 >= integral_digits.length ? '<span class="digit">&nbsp;</span>' : %Q^<span class="digit">#{integral_digits[i+1]}</span>^)
      integral_digits_html.push ( i+2 >= integral_digits.length ? '<span class="digit">&nbsp;</span>' : %Q^<span class="digit">#{integral_digits[i+2]}</span>^)
      integral_digits_html.push ( %Q^<span class="seperator">#{i+3 >= integral_digits.length ? '&nbsp;' : '.'}</span>^)
      i+=3
#      puts "run #{i}"
    end
    (numberof_integral_places%3).times do
      integral_digits_html.push i > integral_digits.length ? '<span class="digit">&nbsp;</span>' : %Q^<span class="digit">#{integral_digits[i]}</span>^
      i+=1
    end
#    puts integral_digits_html.inspect
    str = integral_digits_html.reverse.join
#    puts str
    unless parts[1].nil? || parts[1].empty? || parts[1].eql?('0')
      str << '<span class="seperator">,</span>'
      parts[1].each_char { |d| str << %Q^<span class="digit">#{d}</span>^ }
    end
    return str
  end
end


#returns resultset
def query(stmt)
  begin
    DbController.get_connection.execute(stmt)
  rescue
    warn "Fehler bei Datenbankabfrage: #{stmt}"
    raise
  end
end

#returns no resultset
def execute(stmt)
  begin
    dbh = DbController.get_connection
    #~ puts "Executing: #{stmt}"
    dbh.do(stmt)
    dbh.commit
  rescue
    warn "Fehler bei Datenbankabfrage: #{stmt}"
    raise
  end
end

begin
  puts "Starte #{Time.now}"
  puts "Lösche index"
  execute("delete from html_index") if $lang['de']
  execute("delete from html_index_en") if $lang['en']
  years_rs = query("SELECT DISTINCT jahr FROM p_betrieb ORDER BY jahr")
#  puts years_rs.inspect
  years = years_rs.collect { |row| row[0]  }
  years.each do |jahr|
    #   mlt, 2014-03-31, Notfall, Jahre 2007-2011 wurden verarbeitet, 2012 ist abgestürzt.
    #   mlt ff.: Daher Jahre < 2012 überspringen, denn es eilt:
	  next if jahr.to_i < 2014
    #   mlt: Wieder auskommentiert aber drin gelassen, falls Falk es nochmal braucht :)
    if  $lang['de'] then
      puts "Bearbeite Jahr #{jahr}"
      puts "Lösche Daten von HTML-Tabelle für Jahr #{jahr}"
      execute("TRUNCATE betriebe_html_#{jahr}")
      rs = query(%Q^SELECT b.id,b.ido,
      coalesce (b.name1,'')||' '||coalesce (b.name2,'') as name,
      b.kennnr,
      b.jahr,
      st_x(b.geo_etrs89_utm32) as geo_x,
      st_y(b.geo_etrs89_utm32) as geo_y,
      coalesce(b.strasse,'')||' '||coalesce(b.nr,'')||'<br />'||coalesce(b.plzstr,'')||' '||coalesce(b.ort) as address,
      fs.ltext as buland,
      feg.ltext as flusseinzugsgebiet,
      coalesce (b.bname1,'')||' '||coalesce (b.bname2,'') as muttergesellschaft,
      b.eigname,
      b.betname,
      b.prodvol,
      b.anlzahl,
      b.betriebh,
      b.prtrinfo,
      n.schl nace_key,
      n.ktext nace_text
  FROM p_betrieb b
  LEFT JOIN l_bundeslaender fs ON fs.id = b.land_id
  LEFT JOIN public.l_flusseinzugsgebiete feg ON feg.id = b.flezgeb_id
  LEFT JOIN public.l_nace_wirtschaftszweige n on n.id = b.nace_id
  WHERE
    jahr = '#{jahr}'
    -- AND b.ido IN (38303, 41398, 47945, 50038, 50044)
    ^)

      $template = ERB.new(File.read('templates/betrieb.erb'))
      rs.each do |row|
        begin
          betrieb = Betrieb.new(row,'de') #used in ERB
          @no_emission_list = []
          puts "bearbeite #{betrieb['jahr']}:#{betrieb['kennnr']}"
          
          execute("insert into betriebe_html_#{betrieb['jahr']} (id,p_betrieb_id,content) VALUES (#{betrieb['ido']},#{betrieb['id']}, $$#{$template.result(binding)}$$)")
          execute("insert into html_index (id, p_betrieb_id,jahr,bgk,tgk,ntaet,
            nfreisl, nfreisw, nfreisb, nvabw, aggregated,
            fgkl,fgkw,fgkb,wgk,
            ngefinv,ngefauv,nnigefv,
            ngefinb,ngefaub,nnigefb,
            aniggk, agefgk)
        VALUES (#{betrieb['id']},#{betrieb['ido']},'#{betrieb['jahr']}',#{betrieb.geheimk.length},#{betrieb.taet.first.geheimk.length rescue 0},#{betrieb.taet.length},
            #{betrieb.freis[1].length},#{betrieb.freis[2].length},#{betrieb.freis[3].length},#{betrieb.vabw.length}, '#{betrieb.which_aggregated}',
            #{betrieb.freis[1].gklist.length},#{betrieb.freis[2].gklist.length},#{betrieb.freis[3].gklist.length},#{betrieb.vabw.gklist.length},
            #{betrieb.vabf[:gefin][:ver].length},#{betrieb.vabf[:gefaus][:ver].length},#{betrieb.vabf[:nigef][:ver].length},
            #{betrieb.vabf[:gefin][:bes].length},#{betrieb.vabf[:gefaus][:bes].length},#{betrieb.vabf[:nigef][:bes].length},
            #{betrieb.vabf[:gehnig].length},#{betrieb.vabf[:gehgef].length})")
        rescue SystemExit, Interrupt => x
          raise x
        rescue Exception => rumms
          warn "Fehler bei Betrieb: #{row.to_h}"
          warn rumms.message
          warn rumms.backtrace.join("\n")
          #      rs.finish
          #      raise rumms
        end
      end
    end
    if $lang['en']
      puts "Working on year #{jahr}"
      puts "Deleting year #{jahr} data from HTML _en_ table"
      execute("TRUNCATE betriebe_html_en_#{jahr}")
      rs = query(%Q^SELECT b.id,b.ido,
      coalesce (b.name1,'')||' '||coalesce (b.name2,'') as name,
      b.kennnr,
      b.jahr,
      st_x(b.geo_etrs89_utm32) as geo_x,
      st_y(b.geo_etrs89_utm32) as geo_y,
      coalesce(b.strasse,'')||' '||coalesce(b.nr,'')||'<br />'||coalesce(b.plzstr,'')||' '||coalesce(b.ort) as address,
      fs.ltext_en as buland,
      feg.ltext_en as flusseinzugsgebiet,
      coalesce (b.bname1,'')||' '||coalesce (b.bname2,'') as muttergesellschaft,
      b.eigname,
      b.betname,
      b.prodvol,
      b.anlzahl,
      b.betriebh,
      b.prtrinfo,
      n.schl nace_key,
      n.ktext_en nace_text
  FROM p_betrieb b
  LEFT JOIN l_bundeslaender fs ON fs.id = b.land_id
  LEFT JOIN public.l_flusseinzugsgebiete feg ON feg.id = b.flezgeb_id
  LEFT JOIN public.l_nace_wirtschaftszweige n on n.id = b.nace_id
  WHERE
    jahr = '#{jahr}'
    -- AND b.ido IN (38303, 41398, 47945, 50038, 50044)
    ^)

      $template = ERB.new(File.read('templates/betrieb_en.erb'))
      rs.each do |row|
        begin
          betrieb = Betrieb.new(row,'en') #used in ERB
          @no_emission_list = []
          puts "working on #{betrieb['jahr']}:#{betrieb['kennnr']}"

          execute("insert into betriebe_html_en_#{betrieb['jahr']} (id,p_betrieb_id,content) VALUES (#{betrieb['ido']},#{betrieb['id']}, $$#{$template.result(binding)}$$)")
          execute("insert into html_index_en (id, p_betrieb_id,jahr,bgk,tgk,ntaet,
            nfreisl, nfreisw, nfreisb, nvabw, aggregated,
            fgkl,fgkw,fgkb,wgk,
            ngefinv,ngefauv,nnigefv,
            ngefinb,ngefaub,nnigefb,
            aniggk, agefgk)
        VALUES (#{betrieb['id']},#{betrieb['ido']},'#{betrieb['jahr']}',#{betrieb.geheimk.length},#{betrieb.taet.first.geheimk.length rescue 0},#{betrieb.taet.length},
            #{betrieb.freis[1].length},#{betrieb.freis[2].length},#{betrieb.freis[3].length},#{betrieb.vabw.length}, '#{betrieb.which_aggregated}',
            #{betrieb.freis[1].gklist.length},#{betrieb.freis[2].gklist.length},#{betrieb.freis[3].gklist.length},#{betrieb.vabw.gklist.length},
            #{betrieb.vabf[:gefin][:ver].length},#{betrieb.vabf[:gefaus][:ver].length},#{betrieb.vabf[:nigef][:ver].length},
            #{betrieb.vabf[:gefin][:bes].length},#{betrieb.vabf[:gefaus][:bes].length},#{betrieb.vabf[:nigef][:bes].length},
            #{betrieb.vabf[:gehnig].length},#{betrieb.vabf[:gehgef].length})")
        rescue SystemExit, Interrupt => x
          raise x
        rescue Exception => rumms
          warn "Error at facility: #{row.to_h}"
          warn rumms.message
          warn rumms.backtrace.join("\n")
          #      rs.finish
          #      raise rumms
        end
      end
    end
    rs.finish
    puts "Done with year #{jahr}"
  end


  puts "Fertig um #{Time.now}"
  puts "Fülle ble_releases:"

  time = Time.now
  db_rel = query("SELECT max(release) from releases").to_a[0][0]
  execute("INSERT INTO public.ble_releases (db_release,html_generator_version,release_date,release_time,ble_date)
    VALUES ('#{db_rel}','#{APPVERSION}',#{time.strftime("%Y%m%d")},#{time.strftime("%H%M%S")},'#{time.strftime("%d.%m.%Y")}'
    )")
  puts "OK, jetzt aber Fertig!"
rescue SystemExit, Interrupt
  raise
rescue Exception => rumms
  puts "Unexpected Exc <#{rumms}>"
  print rumms.backtrace.join("\n")
  DbController.close_connection
  puts "Abgebrochen um #{Time.now}"
end
