# -*- coding: utf-8 -*-
# 
# Änderungen:
# 2014-04-15, mlt: Änderung Sprachunterscheidung für CO2, gesamt und CO2, nicht-biogener Anteil. War vorher nur englisch.
# 
class Betrieb < Entry
  attr_accessor :taet, :freis, :vabw, :vabf
  def initialize(row,lang)
    @lang = lang
    super(row,'p_betrieb',lang)
    @jahr = row['jahr']
    ### Tätigkeiten

    if lang == 'de'
      # rs = query("SELECT t.id, prtr.ktext || ' (IVU: ' || coalesce(ivu.ktext,'&mdash;') || ' )' as text
      rs = query("SELECT t.id, prtr.ktext as text
      FROM p_taet t
      -- LEFT JOIN l_taetigkeiten_anhang1_ivu ivu ON ivu.id = t.nrivu_id
      LEFT JOIN l_taetigkeiten_anhang1_eprtr prtr ON prtr.id = t.nrprtr_id
      WHERE p_betrieb_id=#{self['id']} AND jahr = '#{@jahr}'
      ORDER BY t.htprtr DESC")
    elsif lang == 'en'
      # rs = query("SELECT t.id, prtr.ktext_en || ' (IPPC: ' || coalesce(ivu.ktext_en,'&mdash;') || ' )' as text
      rs = query("SELECT t.id, prtr.ktext_en as text
      FROM p_taet t
      -- LEFT JOIN l_taetigkeiten_anhang1_ivu ivu ON ivu.id = t.nrivu_id
      LEFT JOIN l_taetigkeiten_anhang1_eprtr prtr ON prtr.id = t.nrprtr_id
      WHERE p_betrieb_id=#{self['id']} AND jahr = '#{@jahr}'
      ORDER BY t.htprtr DESC")
    end
    @taet = []
    #    puts "Neuer Betrieb: #{self['id']}"
    rs.each do |row|
      @taet.push(Entry.new(row,'p_taet',lang))
    end
    rs.finish

    ### Freisetzungen
    @freis = FreisManager.new(lang)
    if lang == 'de'
    rs = query("select f.id, f.medium_id, f.jfracht , f.vfracht, sg.ktext as stoffgruppe, s.ktext as stoffname, s.cas_nr, s.schwellenwert_luft, s.schwellenwert_boden, s.schwellenwert_wasser, bm.ltext as bmeth, bv.schl as bverf, f.stoffnr_id, f.nbiofracht
from public.p_freis f
left join public.l_bestimmungsmethoden_ermittlungsarten bm on f.bestim_id = bm.id
left join public.l_bestimmungsverfahren bv on f.bvcode_id = bv.id
left join public.l_stoffe s on f.stoffnr_id=s.id
left join public.l_schadstoffgruppen sg on f.sgruppe_id = sg.id
where jahr = '#{@jahr}' and p_betrieb_id=#{self['id']}
order by f.medium_id, f.sgruppe_id, f.stoffnr_id")
    elsif lang == 'en'
      rs = query("select f.id, f.medium_id, f.jfracht , f.vfracht, sg.ktext_en as stoffgruppe, s.ktext_en as stoffname, s.cas_nr, s.schwellenwert_luft, s.schwellenwert_boden, s.schwellenwert_wasser, bm.ltext_en as bmeth, bv.schl as bverf, f.stoffnr_id, f.nbiofracht
from public.p_freis f
left join public.l_bestimmungsmethoden_ermittlungsarten bm on f.bestim_id = bm.id
left join public.l_bestimmungsverfahren bv on f.bvcode_id = bv.id
left join public.l_stoffe s on f.stoffnr_id=s.id
left join public.l_schadstoffgruppen sg on f.sgruppe_id = sg.id
where jahr = '#{@jahr}' and p_betrieb_id=#{self['id']}
order by f.medium_id, f.sgruppe_id, f.stoffnr_id")
    end
    rs.each do |row|
      # BUBE hat NULL oder sogar 0.0 in nbiofracht auf jfracht gesetzt. was bei Nichtane geschieht wird momentan juristisch geklärt.
      if @jahr >= '2009' && row['stoffnr_id'].to_i==3 && !row['nbiofracht'].nil? && row['jfracht'] > row['nbiofracht'] #letzte Bedingung temporär fix, siehe Kommentar in Zeile hierrüber
        # Hier knallte es mitunter. Ursache war (2016-05-31, mlt) ein Bug im dbi-0.4.5-Gem.
        # cd /var/lib/gems/2.3.0/gems/dbi-0.4.5/lib/dbi; emacs -nw row.rb; Zeile 212: Sollte auch Ruby 2.x matchen:
        #   if RUBY_VERSION =~ /^1\.9/ || RUBY_VERSION =~ /^2/
        # Speichern, fertig, Problem behoben.
        begin
          total_row = row.clone
        rescue Exception => rumms
          warn "Fehler bei Freisetzung: #{row.to_h}"
          warn rumms.message
          warn rumms.backtrace.join("\n")
          puts "----------"
          raise rumms
        end
        if lang == 'de'
          total_row['stoffname'] = "CO2, gesamt"
        else
          total_row['stoffname'] = "CO2, total"
        end
        
        @freis.push(total_row)

        nonbio_row = row.clone
        if lang == 'de'
          nonbio_row['stoffname'] = "CO2, nicht-biogener Anteil"
        else
          nonbio_row['stoffname'] = "CO2, non-biogenic part"
        end
        nonbio_row['jfracht'] = row['nbiofracht'] unless row['nbiofracht'].nil? #wenn nbiofracht==nil wird angenommen, dass der gesamte Anteil aus nicht-biogener Herkunft ist
        nonbio_row['vfracht'] = nil # will be replaced by mdash; in float_value
        @freis.push(nonbio_row)        
      else
        @freis.push(row)
      end
    end
    rs.finish
    @freis.sort

    ### Verbringungen mit dem Abwasser
    @vabw = FloatTrackingArray.new(['jfracht','vfracht','schwellenwert'])
    if lang == 'de'
    rs = query("select f.id, f.jfracht, sg.ktext as stoffgruppe, s.ktext as stoffname, s.cas_nr, s.schwellenwert_wasser as schwellenwert,  bm.ltext as bmeth, bv.schl as bverf
from public.p_vabw f
left join public.l_bestimmungsmethoden_ermittlungsarten bm on f.bestim_id = bm.id
left join public.l_bestimmungsverfahren bv on f.bvcode_id = bv.id
left join public.l_stoffe s on f.stoffnr_id=s.id
left join public.l_schadstoffgruppen sg on f.sgruppe_id = sg.id
where jahr = '#{@jahr}' and p_betrieb_id=#{self['id']}
order by f.sgruppe_id, f.stoffnr_id")
    elsif lang == 'en'
      rs = query("select f.id, f.jfracht, sg.ktext_en as stoffgruppe, s.ktext_en as stoffname, s.cas_nr, s.schwellenwert_wasser as schwellenwert,  bm.ltext_en as bmeth, bv.schl as bverf
from public.p_vabw f
left join public.l_bestimmungsmethoden_ermittlungsarten bm on f.bestim_id = bm.id
left join public.l_bestimmungsverfahren bv on f.bvcode_id = bv.id
left join public.l_stoffe s on f.stoffnr_id=s.id
left join public.l_schadstoffgruppen sg on f.sgruppe_id = sg.id
where jahr = '#{@jahr}' and p_betrieb_id=#{self['id']}
order by f.sgruppe_id, f.stoffnr_id")
    end
    rs.each do |row|
      @vabw.push(Entry.new(row,'p_vabw',lang), ['jfracht','vfracht','schwellenwert'])
    end
    rs.finish
    @vabw.sort_by('jfracht')

    ### Verbringungen mit dem Abfall
    @vabf = AbfallManager.new(lang)
    #TODO: treat verbes_id is null
    if lang == 'de'
    rs = query("select f.id, f.menge, f.abfart_id, f.aland_id, coalesce(f.verbes_id, 1) as verbes_id, bm.ltext as bmeth, bv.schl as bverf,
    f.vbname,
coalesce(f.vbstr,'')||' '|| coalesce(f.vbstrnr,'') as vbstr,
coalesce(f.vbplz,'')||' '|| coalesce(f.vbort,'') as vbort,
lvbstaat.ktext as vbstaat,
coalesce(f.vbsstr,'')||' '|| coalesce(f.vbsstrnr,'') as vbsstr,
coalesce(f.vbsplz,'')||' '|| coalesce(f.vbsort,'') as vbsort,
lvbsstaat.ktext as vbsstaat
from public.p_vabf f
left join public.l_bestimmungsmethoden_ermittlungsarten bm on f.bestim_id = bm.id
left join public.l_bestimmungsverfahren_abfall bv on f.bvcode_id = bv.id
left join public.l_staaten lvbstaat  on coalesce(f.vbstaat_id, f.astaat_id) = lvbstaat.id
left join public.l_staaten lvbsstaat on coalesce(f.vbsstaat_id,f.astaat_id) = lvbsstaat.id
where jahr = '#{@jahr}' and p_betrieb_id=#{self['id']}
order by abfart_id, aland_id, verbes_id")
    elsif lang == 'en'
      rs = query("select f.id, f.menge, f.abfart_id, f.aland_id, coalesce(f.verbes_id, 1) as verbes_id, bm.ltext_en as bmeth, bv.schl_en as bverf,
    f.vbname,
coalesce(f.vbstr,'')||' '|| coalesce(f.vbstrnr,'') as vbstr,
coalesce(f.vbplz,'')||' '|| coalesce(f.vbort,'') as vbort,
lvbstaat.ktext_en as vbstaat,
coalesce(f.vbsstr,'')||' '|| coalesce(f.vbsstrnr,'') as vbsstr,
coalesce(f.vbsplz,'')||' '|| coalesce(f.vbsort,'') as vbsort,
lvbsstaat.ktext_en as vbsstaat
from public.p_vabf f
left join public.l_bestimmungsmethoden_ermittlungsarten bm on f.bestim_id = bm.id
left join public.l_bestimmungsverfahren_abfall bv on f.bvcode_id = bv.id
left join public.l_staaten lvbstaat  on coalesce(f.vbstaat_id, f.astaat_id) = lvbstaat.id
left join public.l_staaten lvbsstaat on coalesce(f.vbsstaat_id,f.astaat_id) = lvbsstaat.id
where jahr = '#{@jahr}' and p_betrieb_id=#{self['id']}
order by abfart_id, aland_id, verbes_id")
    end
    rs.each do |row|
      @vabf.push(row)
    end
    rs.finish
    @vabf.sort
  end

  #def wrapped_confidentiable_value(identifier,replacement=nil)
  #  return super(identifier, replacement) unless replacement.nil?
  #  return super(identifier, '<p class="confidentialTag">vertraulich</p>')
  #end
  #
  #def html_value(identifier)
  #  return "" if self[identifier].nil?
  #  return self[identifier].to_s
  #end

  def confidentiable_value(identifier, replacement = nil)
    return html_value(identifier) if !confidential?
    return replacement unless replacement.nil?
    return 'vertraulich'
  end


  def [](identifier)
    return case identifier
    when 'nace' then "#{@data['nace_key'][0..1]}.#{@data['nace_key'][2..3]} - #{@data['nace_text']}" rescue " "
    else super
    end
  end

  def which_aggregated
    return 'luft' if @freis[1].has_aggregated
    return 'wasser' if @freis[2].has_aggregated
    return 'boden' if @freis[3].has_aggregated
    return 'vabw' if @vabw.has_aggregated
    return "none"
  end
end
