# -*- coding: utf-8 -*-
class FloatTrackingArray < AggregatingArray
  
  def initialize(identifiers)
    @digits = {}
    identifiers.each do |identifier|
      @digits[identifier] = 0
    end
    super()
  end

  def push(freis,identifiers)
    identifiers.each do |identifier|
      set_digit_length(identifier, freis[identifier])
    end
    super freis
  end

  def set_digit_length(identifier, value)
    length = value.to_s.split('.')[0].length rescue 0
    @digits[identifier] = length if length > @digits[identifier]
#    puts "#{identifier} #{@digits[identifier]}"
  end


  def get_digit_length(identifier)
    @digits[identifier]
  end

  def sort_by(identifier)
    self.sort! { |a,b| -(a[identifier] <=> b[identifier]).to_i }
  end
end