# -*- coding: utf-8 -*-
GEHEIMHALTUNGSGRUENDE = [
  ['A',	'Nachteilige Auswirkungen auf Internationale Beziehungen'],#0
  ['B',	'Nachteilige Auswirkungen auf Verteidigung'],#1
  ['C',	'Nachteilige Auswirkungen auf Schutzgüter der öffentlichen Sicherheit'],#2
  ['D',	'Nachteilige Auswirkungen auf ein laufendes Gerichtsverfahren'],#3
  ['E',	'Nachteilige Auswirkungen auf den Anspruch einer Person auf ein faires Verfahren'],#4
  ['F',	'Nachteilige Auswirkungen auf rechtliche Ermittlungen (Straf-, Disziplinarrecht, Ordnungswidrigkeit)'],#5
  ['G',	'Schutz personenbezogener Daten'],#6
  ['H',	'Rechte am geistigen Eigentum verletzt werden'],#7
  ['I',	'Betriebsgeheimnisse'],#8
  ['J',	'Geschäftsgeheimnisse'],#9
  ['K',	'Steuergeheimnisse'],#10
  ['L',	'Statistikgeheimnisse']#11
]
CONFIDENTIALITY_REASONS = [
    ['A',	'Adverse effects on international relations'],#0
    ['B',	'Adverse effects on the national defense'],#1
    ['C',	'Adverse effects on protected interests of public security'],#2
    ['D',	'Adverse effects on the implementation of the course of justice'],#3
    ['E',	'Adverse effectc on the right of any individual to a fair trial'],#4
    ['F',	'Adverse effects on the conducting of a criminal, misdemeanor legal or disciplinary investigations'],#5
    ['G',	'Protection of personal data'],#6
    ['H',	'Intellectual property rights'],#7
    ['I',	'Industrial secrets'],#8
    ['J',	'Commercial secrets'],#9
    ['K',	'Tax secrets'],#10
    ['L',	'Statistical secrets']#11
]

class Entry
  attr_accessor :geheimk, :aggr_vfracht
  def initialize(row,gk_table,lang)
    @lang = lang
    @data = row.to_h
    sql = "select geheimk_id from #{gk_table}_geheimk where #{gk_table}_id = #{@data['id']}"
    rs = query(sql)
    temp = rs.collect{|i| i[0]-1}
    rs.finish
    @geheimk = temp.collect{|i| GEHEIMHALTUNGSGRUENDE[i]} if lang == 'de'
    @geheimk = temp.collect{|i| CONFIDENTIALITY_REASONS[i]} if lang == 'en'
    @aggr_vfracht = false
  end

  def confidential?
    return !@geheimk.empty?
  end

  def wrapped_confidentiable_value(identifier,replacement = nil, tag='p')
    return wrapped_html_value(identifier,tag) if !confidential?
    return %Q^<#{tag} class="confidentialTag">#{confidentiable_value(identifier, replacement)}</#{tag}>^
  end

  def wrapped_html_value(identifier, tag='p')
    return "<#{tag}>#{html_value(identifier)}</#{tag}>"
  end

  def confidentiable_value(identifier, replacement = nil)
    return html_value(identifier) if !confidential?
    return replacement unless replacement.nil?
    return 'vertraulich'+get_kuerzel if @lang == 'de'
    return 'confidential'+get_kuerzel if @lang == 'en'
  end

  def html_value(identifier)
    return '&mdash;' if self[identifier].nil? || self[identifier].to_s.strip.eql?('-')
    return self[identifier].to_s
  end

  def float_value(identifier,numberof_integral_places)
    return '&mdash;' if @data[identifier].nil? || numberof_integral_places==0
    @data[identifier].to_html(numberof_integral_places)
#    # zweck dieser funktion ist, eine kommazahl in einzelnen spans (für gleichanordnung) mit numberof_integral_places vorkommastellen (oder platzhaltern) darzustellen
#    # zweck ist einfacher das ausrichten am komma
#    return '' if @data[identifier].nil?
#    parts=@data[identifier].to_s.split('.')
##    puts "#{identifier} #{@data[identifier]} mit #{numberof_integral_places} Stellen"
#    i=0
#    integral_digits = parts[0].reverse
#    integral_digits_html = []
#    while i <= numberof_integral_places-3
#      integral_digits_html.push (i >= integral_digits.length ? '<span class="digit">&nbsp;</span>' : %Q^<span class="digit">#{integral_digits[i]}</span>^)
#      integral_digits_html.push (i+1 >= integral_digits.length ? '<span class="digit">&nbsp;</span>' : %Q^<span class="digit">#{integral_digits[i+1]}</span>^)
#      integral_digits_html.push ( i+2 >= integral_digits.length ? '<span class="digit">&nbsp;</span>' : %Q^<span class="digit">#{integral_digits[i+2]}</span>^)
#      integral_digits_html.push ( %Q^<span class="seperator">#{i+3 >= integral_digits.length ? '&nbsp;' : '.'}</span>^)
#      i+=3
##      puts "run #{i}"
#    end
#    (numberof_integral_places%3).times do
#      integral_digits_html.push i > integral_digits.length ? '<span class="digit">&nbsp;</span>' : %Q^<span class="digit">#{integral_digits[i]}</span>^
#      i+=1
#    end
##    puts integral_digits_html.inspect
#    str = integral_digits_html.reverse.join
##    puts str
#    unless parts[1].empty? || parts[1].eql?('0')
#      str << '<span class="seperator">,</span>'
#      parts[1].each_char { |d| str << %Q^<span class="digit">#{d}</span>^ }
#    end
#    return str
  end

  def get_kuerzel
    derory = @geheimk.collect{|i| '['+i[0]+']'}.join('')
    return derory
  end

  def [](identifier)
    return @data[identifier]
  end

  def []=(identifier, value)
    @data[identifier] = value
  end
  
  def inspect
    @data.inspect
  end
end