# -*- coding: utf-8 -*-
class FreisManager

  def initialize(lang)
    @lang = lang
    @freis = Array.new(3) { |index| FloatTrackingArray.new(['jfracht','vfracht','schwellenwert'])}
#    @freis[1] = AggregatingArray.new #Boden
#    @freis[2] = AggregatingArray.new #Luft
#    @freis[3] = AggregatingArray.new #Wasser
#    @digit = Array.new(3) { |index| {'jfracht'=>0,'vfracht'=>0,'schwellenwert'=>0} }
  end

  def push(row)
    freis = Entry.new(row,'p_freis',@lang)
    freis['schwellenwert'] = case row['medium_id']
      when 1 then row['schwellenwert_boden']
      when 2 then row['schwellenwert_luft']
      when 3 then row['schwellenwert_wasser']
    end
    @freis[row['medium_id']-1].push(freis, ['jfracht','vfracht','schwellenwert'])
  end

  def [](identifier)
    return @freis[identifier - 1] if (1..3) === identifier.to_i
    return case identifier
      when 'boden' then @freis[0]
      when 'luft' then @freis[1]
      when 'wasser' then @freis[2]
    else raise
    end
  end

  def sort
    @freis.each { |item| item.sort_by('jfracht') }
  end

end