-- SQL-Skript für diverse Korrekturen an den e-PRTR Daten
--
-- (c) ENDA GmbH & Co. KG, 2011
--
-- * INT (C) ETS         -> messverf(= Designation) wird auf 'nach Leitlinien des ETS' gesetzt, wenn messverf leer ist
-- * INT (C) IPCC        -> messverf(= Designation) wird auf 'nach Verfahren der IPCC-Guidelines' gesetzt, wenn messverf leer ist
-- * INT (C) UN-ECE/EMEP -> messverf(= Designation) wird auf 'nach dem EMEP/CORINAIR Emission Inventory Guidebook' gesetzt, wenn messverf leer ist
--
-- * Das gilt vor allem für Freisetzungen in die Luft, es werden aber auch die anderen Umweltkompartimente als auch für Verbringungen mit dem Abwasser abgearbeitet
--
--
-- 2011-03-23, Rev. 1, mlt: Nur noch bei fehlender Methode (messverf)
-- 2011-03-22, Rev. 0, mlt: Erstellung



--p_freis
UPDATE p_freis f SET messverf = 'nach Leitlinien des ETS'
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE f.p_betrieb_id = b.id
  and f.bvcode_id = 16
  and f.messverf is null
returning 4601 as korrektur,
  'Freisetzungen: Beschreibung (messverf) auf "nach Leitlinien des ETS" setzen, wenn Bestimmungsverfahren "INT (C) ETS" und keine Beschreibung vorliegt' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, f.id as p_freis_id;

UPDATE p_freis f SET messverf = 'nach Verfahren der IPCC-Guidelines'
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE f.p_betrieb_id = b.id
  and f.bvcode_id = 15
  and f.messverf is null
returning 4602 as korrektur,
  'Freisetzungen: Beschreibung (messverf) auf "nach Verfahren der IPCC-Guidelines" setzen, wenn Bestimmungsverfahren "INT (C) IPCC" und keine Beschreibung vorliegt' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, f.id as p_freis_id;

UPDATE p_freis f SET messverf = 'nach dem EMEP/CORINAIR Emission Inventory Guidebook'
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE f.p_betrieb_id = b.id
  and f.bvcode_id = 17
  and f.messverf is null
returning 4603 as korrektur,
  'Freisetzungen: Beschreibung (messverf) auf "nach dem EMEP/CORINAIR Emission Inventory Guidebook" setzen, wenn Bestimmungsverfahren "INT (C) UN-ECE/EMEP" und keine Beschreibung vorliegt' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, f.id as p_freis_id;


-- Diese sollten nie greifen, da ETS, IPCC und UN-ECE/EMEP *nur* *für* *Luft* verwandt werden können!:
--p_vabw
UPDATE p_vabw v SET messverf = 'nach Leitlinien des ETS'
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE v.p_betrieb_id = b.id
  and v.bvcode_id = 16
  and v.messverf is null
returning 4611 as korrektur,
  'Abwasser: Beschreibung (messverf) auf "nach Leitlinien des ETS" setzen, wenn Bestimmungsverfahren "INT (C) ETS" und keine Beschreibung vorliegt' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, v.id as p_vabw_id;

UPDATE p_vabw v SET messverf = 'nach Verfahren der IPCC-Guidelines'
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE v.p_betrieb_id = b.id
  and v.bvcode_id = 15
  and v.messverf is null
returning 4612 as korrektur,
  'Abwasser: Beschreibung (messverf) auf "nach Verfahren der IPCC-Guidelines" setzen, wenn Bestimmungsverfahren "INT (C) IPCC" und keine Beschreibung vorliegt' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, v.id as p_vabw_id;

UPDATE p_vabw v SET messverf = 'nach dem EMEP/CORINAIR Emission Inventory Guidebook'
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE v.p_betrieb_id = b.id
  and v.bvcode_id = 17
  and v.messverf is null
returning 4613 as korrektur,
  'Abwasser: Beschreibung (messverf) auf "nach dem EMEP/CORINAIR Emission Inventory Guidebook" setzen, wenn Bestimmungsverfahren "INT (C) UN-ECE/EMEP" und keine Beschreibung vorliegt' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, v.id as v_vabw_id;
