-- SQL-Skript für diverse Korrekturen an den e-PRTR Daten
--
-- (c) ENDA GmbH & Co. KG, 2011
--
-- * Leere Datenfelder mit '-' füllen
--
--
-- 2011-03-22, Rev. 0, mlt: Erstellung


-- * Berücksichtigung individueller Exportunterdrückungen über Korrekturtabelle k_suppressoren

-- Hilfsstatement zum Setzen der land_id aus p_betrieb:
--
-- update k_suppressoren ks set land_id = b.land_id
-- from p_betrieb b
-- where b.date_from = 20090101
--   and b.kennnr = ks.kennnr
--   and ks.land_id is null;


UPDATE p_betrieb b SET xml3export = 0
from p_betrieb b2
  inner join k_suppressoren ks
    on b2.land_id = ks.land_id
    and b2.kennnr = ks.kennnr
    and b2.date_from = ks.jahr * 10000 + 101
  inner join k_laender_fuer_aktualisierung ka
    on b2.date_from = ka.jahr * 10000 +  101
    and b2.date_to  = ka.jahr * 10000 + 1231
    and b2.land_id  = ka.land_id
WHERE b.id = b2.id
  and b2.xml3export is distinct from 0
returning 5201 as korrektur,
  'Individuelle EU-Exportunterdrückung: ' || coalesce(ks.grund, '') as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, null as sub_id;
