-- SQL-Skript für diverse Korrekturen an den e-PRTR Daten
--
-- (c) ENDA GmbH & Co. KG, 2011
--
-- * Leere Datenfelder mit '-' füllen
--
--
-- 2011-03-24, Rev. 0, mlt: Erstellung


-- * Berücksichtigung individueller Datenänderungsanweisungen für Abfall


update p_vabf a set aland_id = 2  -- Inland
from p_betrieb b
where b.id = a.p_betrieb_id
  and a.aland_id is null
  and b.date_from = 2007 * 10000 + 101
  and b.kennnr in (
'06-09-772-2204-0001',
'06-09-362-8000-0001',
'06-09-179-2066-0001',
'06-09-187-0001-0001',
'06-09-162-4199-0001',
'06-09-678-0044-0001',
'06-09-774-0077-0001',
'06-09-162-0950-0001',
'06-09-574-2173-0001',
'06-09-777-0249-0001',
'06-09-676-0008-0001',
'06-09-700-2022-0001',
'06-09-774-0040-0001',
'06-09-777-0073-0001'
)
returning 5401 as korrektur,
  'Individuelle Abfallkorrektur 2007 "HWIC". Es wird "Inland" gesetzt, wo keine Angabe zu Inland/Ausland erfolgte' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, a.id as p_vabf_id;



update p_vabf a set aland_id = 1  -- Ausland
from p_betrieb b
where b.id = a.p_betrieb_id
  and a.aland_id is null
  and b.date_from = 2007 * 10000 + 101
  and b.kennnr in (
'06-09-184-4-41-0001',
'06-09-772-0105-0001'
)
returning 5402 as korrektur,
  'Individuelle Abfallkorrektur 2007 "HWOC". Es wird "Ausland" gesetzt, wo keine Angabe zu Inland/Ausland erfolgte' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, a.id as p_vabf_id;


update p_vabf a set aland_id = 1  -- Ausland
from p_betrieb b
where b.id = a.p_betrieb_id
  and a.aland_id is null
  and b.date_from = 2007 * 10000 + 101
  and b.kennnr = '06-09-661-4059-0001'
  and a.id in (
'62015',
'62016',
'62017')
returning 5403 as korrektur,
  'Individuelle Abfallkorrektur 2007 "HWOC", "Duesmann & Hensel Recycling GmbH". Es wird für drei Abfälle "Ausland" gesetzt, wo keine Angabe zu Inland/Ausland erfolgte' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, a.id as p_vabf_id;

update p_vabf a set aland_id = 2  -- Inland
from p_betrieb b
where b.id = a.p_betrieb_id
  and a.aland_id is null
  and b.date_from = 2007 * 10000 + 101
  and b.kennnr = '06-09-661-4059-0001'
  and a.id in ('62018')
returning 5404 as korrektur,
  'Individuelle Abfallkorrektur 2007 "HWIC", "Duesmann & Hensel Recycling GmbH". Es wird für einen Abfall "Inland" gesetzt, wo keine Angabe zu Inland/Ausland erfolgte' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, a.id as p_vabf_id;

