-- Master-Skript Post-Import für manuelle Koordinatenneuberechnung
--   die bereits beim XML2-Import durchgeführt wird
--   was aber nichts nützt, wenn Rechts- und Hochwert nach dem Import
--   händisch auf der Datenbank korrigiert werden.
-- 
-- (c) ENDA GmbH & Co. KG, 2011, 2014, 2015
-- Dieses Skript steht unter GNU Gpl. V3
--
--
-- Rev. 2, 2015-02-20 16:08, mlt: ETRS89 UTM32-Verarbeitung eingefügt.
--   UTM33-Beschränkung auf Brandenburg bei korrekten Rechtswerten entfernt.
--   Soldner-Koordinatenerkennung verschärft, falls Berlin auch ETRS liefern sollte.
--   Mit jeder Koordinatenberechnung gleich ETRS89 UTM32- und WGS84-Koordinaten mitberechnet.
--   Test nach XML2-Import 2015-02-20 16:26 verlief erfolgreich.
-- Rev. 1, 2014-10-01 16:40, mlt: Stofflistenaktualisierung und Sequenzaktualisierung entfernt,
--   Rücksetzung der XML3-Exportunterdrückung entfernt,
--   Brandenburgs ETRS89 UTM33-Behandlung erheblich verfeinert:
--   korrekten Umgang mit 6- und 8-stelligen Rechtswerten ergänzt
-- Rev. 0, 2011-03-21 10:32, mlt: Abgeleitet aus import_master_2008.sql



-- KOORDINATENBERECHNUNG --

-- GK, 2. Streifen:
update p_betrieb b
set geo_src_gk2 = GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31466),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31466), 4326),
    geo_etrs89_utm32 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31466), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id in (3, 5, 7, 10)
  and b.rechtsw >= 2000000 and b.rechtsw < 3000000;

-- GK, 3. Streifen:
update p_betrieb b
set geo_src_gk3 = GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31467),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31467), 4326),
    geo_etrs89_utm32 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31467), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id in (1, 2, 3, 4, 5, 6, 7, 8, 10, 15, 16)
  and b.rechtsw >= 3000000 and b.rechtsw < 4000000;

-- GK, 4. Streifen:
update p_betrieb b
set geo_src_gk4 = GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31468),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31468), 4326),
    geo_etrs89_utm32 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31468), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id in (1, 3, 8, 9, 13, 14, 15, 16)
  and b.rechtsw >= 4000000 and b.rechtsw < 5000000;

-- GK, 5. Streifen: Brauchen wir derzeit nicht.
update p_betrieb b
set geo_src_gk5 = GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31469),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31469), 4326),
    geo_etrs89_utm32 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31469), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id in (8, 13, 14, 15, 16)
  and b.rechtsw >= 5000000 and rechtsw < 6000000;


-- ETRS89 UTM32
update p_betrieb b
set geo_etrs89_utm32 = GeometryFromText('POINT ' || '(' || b.rechtsw-32000000 || ' ' || b.hochw || ')', 25832),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw-32000000 || ' ' || b.hochw || ')', 25832), 4326)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.rechtsw >= 32000000
  and b.rechtsw < 33000000;

-- ETRS89 UTM33:
update p_betrieb b
set geo_etrs89_utm33 = GeometryFromText('POINT ' || '(' || b.rechtsw-33000000 || ' ' || b.hochw || ')', 25833),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw-33000000 || ' ' || b.hochw || ')', 25833), 4326),
    geo_etrs89_utm32 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw-33000000 || ' ' || b.hochw || ')', 25833), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.rechtsw >= 33000000
  and b.rechtsw < 34000000;

-- BBs ETRS89 UTM33 Flavour 2:
update p_betrieb b
set geo_etrs89_utm33 = GeometryFromText('POINT ' || '(' || b.rechtsw-3000000 || ' ' || b.hochw || ')', 25833),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw-3000000 || ' ' || b.hochw || ')', 25833), 4326),
    geo_etrs89_utm32 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw-3000000 || ' ' || b.hochw || ')', 25833), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id = 12
  and b.rechtsw > 3000000
  and b.rechtsw < 4000000;

-- BBs ETRS89 UTM33 Flavour 3:
update p_betrieb b
set geo_etrs89_utm33 = GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 25833),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 25833), 4326),
    geo_etrs89_utm32 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 25833), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id = 12
  and b.rechtsw < 1000000;



-- BEs Soldner:
update p_betrieb b
set geo_soeldner = GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 3068),
    geo_wgs84 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 3068), 4326),
    geo_etrs89_utm32 = st_transform(GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 3068), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id = 11
  and b.rechtsw < 100000
  and b.hochw < 100000;


-- ENDE des Koordinatenberechnungsskripts.
