-- SQL-Skript für diverse Korrekturen an den e-PRTR Daten
--
-- (c) ENDA GmbH & Co. KG, 2011
--
-- * Leere Datenfelder mit '-' füllen, wenn keine Geheimhaltung:
-- ** Name der Muttergesellschaft (bname1 is null and bname2 is null)
-- ** Straße
-- ** Hausnummer
-- * Generierung von Betriebsname "vertraulich" für diejenigen Betriebe, die weder
--   name1 noch name2 haben und Vertraulichkeitsgründe aufgeführt haben
--
--
-- 2011-03-22, Rev. 0, mlt: Erstellung


-- * Leere Datenfelder mit '-' füllen, wenn nicht Geheimhaltung

--  * Name der Muttergesellschaft (bname1 und bname2 konkateniert)
update p_betrieb b set bname1 = '-'
from p_betrieb b2
  inner join k_laender_fuer_aktualisierung ka
    on b2.date_from = ka.jahr * 10000 +  101
    and b2.date_to  = ka.jahr * 10000 + 1231
    and b2.land_id  = ka.land_id
  left join p_betrieb_geheimk pbk
    on pbk.p_betrieb_id = b2.id
where b.bname1 is null
  and b.bname2 is null
  and b2.id = b.id
  and pbk.id is null;

--  * Straße
update p_betrieb b set strasse = '-'
from p_betrieb b2
  inner join k_laender_fuer_aktualisierung ka
    on b2.date_from = ka.jahr * 10000 +  101
    and b2.date_to  = ka.jahr * 10000 + 1231
    and b2.land_id  = ka.land_id
  left join p_betrieb_geheimk pbk
    on pbk.p_betrieb_id = b2.id
where b.strasse is null
  and b2.id = b.id
  and pbk.id is null;

--  * Hausnummer
update p_betrieb b set nr = '-'
from p_betrieb b2
  inner join k_laender_fuer_aktualisierung ka
    on b2.date_from = ka.jahr * 10000 +  101
    and b2.date_to  = ka.jahr * 10000 + 1231
    and b2.land_id  = ka.land_id
  left join p_betrieb_geheimk pbk
    on pbk.p_betrieb_id = b2.id
where b.nr is null
  and b2.id = b.id
  and pbk.id is null;


-- * Generierung von Betriebsname "vertraulich" für diejenigen Betriebe, die weder
--   name1 noch name2 haben und Vertraulichkeitsgründe aufgeführt haben

update p_betrieb b set name1 = 'vertraulich'
from p_betrieb b2
  inner join k_laender_fuer_aktualisierung ka
    on b2.date_from = ka.jahr * 10000 +  101
    and b2.date_to  = ka.jahr * 10000 + 1231
    and b2.land_id  = ka.land_id
  left join p_betrieb_geheimk bg
    on bg.p_betrieb_id = b2.id
where b2.id = b.id
  and b2.name1 is null
  and b2.name2 is null
  and bg.id is not null
  and (b.geheimpd = 0 or b.geheimge = 0 or b.geheimbg = 0);
