-- SQL-Skript für diverse Korrekturen an den e-PRTR Daten
--
-- (c) ENDA GmbH & Co. KG, 2011
--
-- * INT(M) CEN/ISO -> OTH(M) für die Berechnungsverfahren, die keine Beschreibung (messverf = designation) haben
--
--
-- 2011-03-22, Rev. 0, mlt: Erstellung


-- Führe die vollautomatischen Korrekturen der Bestimmungsmethoden INT(M) CEN/ISO nach OTH(M)
-- für die Datensätze aus, die keine "Designation" (messverf) haben.

-- Bei den Freisetzungen (p_freis) NICHT auf Medium Wasser beschränken, sondern auch Luft ändern.


--p_freis
UPDATE p_freis f SET bvcode_id = 9
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE f.p_betrieb_id = b.id
  and f.medium_id in (2, 3)          -- medium_id 3 = Wasser, 2 = Luft
  and f.bvcode_id = 14
  and f.messverf is null
returning 5001 as korrektur,
  'Freisetzungen: INT (M) CEN/ISO -> OTH(M), wenn zum Bestimmungsverfahren keine Beschreibung (messverf) vorliegt und gilt: Medium ist Wasser oder Luft' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, f.id as p_freis_id;


--p_vabw
UPDATE p_vabw v SET bvcode_id = 9
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE v.p_betrieb_id = b.id
  and v.bvcode_id = 14
  and v.messverf is null
returning 5002 as korrektur,
  'Abwasser: INT (M) CEN/ISO -> OTH(M), wenn zum Bestimmungsverfahren keine Beschreibung (messverf) vorliegt' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, v.id as p_vabw_id;
