-- SQL-Skript für diverse Korrekturen an den e-PRTR Daten
--
-- (c) ENDA GmbH & Co. KG, 2011
--
-- * Leere Datenfelder mit '-' füllen
--
--
-- 2011-03-22, Rev. 0, mlt: Erstellung


-- * Berücksichtigung individueller Korrekturen an der bvcode_id über Korrekturtabelle k_bvcode_id

-- Hilfsstatement zum Setzen der land_id aus p_betrieb:
--
-- update k_bvcode_id kb set land_id = b.land_id
-- from p_betrieb b
-- where b.date_from = 20090101
--   and b.kennnr = kb.kennnr
--   and kb.land_id is null;


-- Freisetzungen:
UPDATE p_freis f SET bvcode_id = kb.bvcode_id_neu
from p_freis f2
  inner join p_betrieb b
    on b.id = f2.p_betrieb_id
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
  inner join k_bvcode_id kb
    on b.land_id = kb.land_id
    and b.date_from = kb.jahr * 10000 +  101
    and b.kennnr = kb.kennnr
    and f2.bvcode_id = kb.bvcode_id_alt
    and kb.tabelle = 'p_freis'
WHERE f.id = f2.id
returning 4801 as korrektur,
  'Freisetzungen: Individuelle Korrekturen des Bestimmungsverfahrens (bvcode_id) von ' || kb.bvcode_alt || ' nach ' || kb.bvcode_neu as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, f.id as p_freis_id;

-- Verbringungen mit dem Abwasser:
UPDATE p_vabw v SET bvcode_id = kb.bvcode_id_neu
from p_vabw v2
  inner join p_betrieb b
    on b.id = v2.p_betrieb_id
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
  inner join k_bvcode_id kb
    on b.land_id = kb.land_id
    and b.date_from = kb.jahr * 10000 +  101
    and b.kennnr = kb.kennnr
    and v2.bvcode_id = kb.bvcode_id_alt
    and kb.tabelle = 'p_vabw'
WHERE v.id = v2.id
returning 4802 as korrektur,
  'Abwasser: Individuelle Korrekturen des Bestimmungsverfahrens (bvcode_id) von ' || kb.bvcode_alt || ' nach ' || kb.bvcode_neu as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, v.id as p_vabw_id;
