# -*- coding: utf-8 -*-
#
# This file is part of the "e-PRTR P-Modul Datenbank Generator".
# For more information, see the release information on main.en.rb. 
#
# Diese Datei ist Teil des "e-PRTR P-Modul Datenbank Generator".
# Fuer weitere Informationen und Release-Informationen siehe mein.en.rb.
#

class Abf < Entry
  
 
#  @@initialized = false
  def initialize(row, gk_table)
    super(row,gk_table)
    #spezialauflösungen, siehe zugehörige listen
    @data['gefaehrlich'] = (@data['abfart_id'] == 2) ? 0 : @data['abfart_id']
    @data['ins_ausland'] = (@data['aland_id'] == 2) ? 0 : @data['aland_id']
    @data['verwertung'] = case @data['verbes_id'] #@data['verwertung'] = case @data['verbes_id'] 
                            when nil then nil
                            when 1 then "Destined for disposal"
                            when 2 then "Destined for recovery"
                          end
    @data['vb'] = ''
    @data['vb'].append_clean_address(@data['vbname'])
    @data['vb'].append_clean_address(@data['vbstr'].append_clean_address(@data['vbstrnr'], ' ')) unless @data['vbstr'].nil?
    @data['vb'].append_clean_address(@data['vbplz'].append_clean_address(@data['vbort'], ' '))
    @data['vb'].append_clean_address(@data['vbstaat'])
    
    
    @data['vbs'] = ''
    @data['vbs'].append_clean_address(@data['vbsstr'].append_clean_address(@data['vbsstrnr'], ' ')) unless @data['vbsstr'].nil?
    @data['vbs'].append_clean_address(@data['vbsplz'].append_clean_address(@data['vbsort'], ' '))
    @data['vbs'].append_clean_address(@data['vbsstaat'])
    
  end

  def write_out()
    $db_target.execute("INSERT INTO waste_transfers (
        id,
        facility_id,
        year,
        quantity,
        hazardous,
        foreign_country,
        disposition,
        determination_method,
        determination_procedure,
        waste_handler_party,
        site_address
      ) VALUES (
      #{sqlize('id')},
      #{sqlize('p_betrieb_id')},
      #{sqlize('jahr')},
      #{sqlize('menge')},
      #{sqlize('gefaehrlich')},
      #{sqlize('ins_ausland')},
      #{sqlize('disposition')},
      #{sqlize('bmeth')},
      #{sqlize('bverf')},
      #{sqlize('vb')},
      #{sqlize('vbs')}
      )")
    @geheimk.each do |gk|
      $db_target.execute("INSERT INTO waste_transfers_pdcc (waste_transfer_id, reason) VALUES (#{@data['id']},'#{gk[1]}')")
    end

  end

end
