# -*- coding: utf-8 -*-
#
# This file is part of the "e-PRTR P-Modul Datenbank Generator".
# For more information, see the release information on main.en.rb. 
#
# Diese Datei ist Teil des "e-PRTR P-Modul Datenbank Generator".
# Fuer weitere Informationen und Release-Informationen siehe mein.en.rb.
#

GEHEIMHALTUNGSGRUENDE = [
  ['A',	'Adverse effects on international relations'],#0
  ['B',	'Adverse effects on the national defense'],#1
  ['C',	'Adverse effects on protected interests of public security'],#2
  ['D',	'Adverse effects on the implementation of the course of justice'],#3
  ['E',	'Adverse effectc on the right of any individual to a fair trial'],#4
  ['F',	'Adverse effects on the conducting of a criminal, misdemeanor legal or disciplinary investigations'],#5
  ['G',	'Protection of personal data'],#6
  ['H',	'Intellectual property rights'],#7
  ['I',	'Industrial secrets'],#8
  ['J',	'Commercial secrets'],#9
  ['K',	'Tax secrets'],#10
  ['L',	'Statistical secrets']#11
]

class Entry

#  class << self; attr_accessor :initialized end
  
  attr_accessor :geheimk

  def initialize(row,gk_table)
    @data = row.to_h
    sql = "select geheimk_id from #{gk_table}_geheimk where #{gk_table}_id = #{@data['id']}"
    rs = $db_source.query(sql)
    @geheimk = rs.collect{|i| GEHEIMHALTUNGSGRUENDE[i[0]-1]}
    rs.finish
  end

  def sqlize(identifier)
    return 'null' if @data[identifier].nil?
    return '\'confidential\'' if identifier == 'name' && @data[identifier].strip == 'vertraulich'
    return clear_string(@data[identifier]) if @data[identifier].is_a?(String)
    if @data[identifier].is_a?(Float) && !(identifier =~ /^geo_/ui)
      return @data[identifier].to_3signdigits if @data[identifier].is_a?(Float)
    end
    return @data[identifier]
  end

  #removes values for null and quotes string
  def clear_string(str)
    ret = str.strip
    return 'null' if ret.empty?
    return 'null' if ret.eql?('-')
    return "'#{ret.gsub("'","''")}'"
  end

  def [](identifier)
    return @data[identifier]
  end

end
