# -*- coding: utf-8 -*-
class Inspire
#  attr_accessor :taet, :freis, :vabw, :vabf
#  @initialized = false

  def initialize(row)
    @data = row.to_h
  end

  def sqlize(identifier)
    return 'null' if @data[identifier].nil?
    return clear_string(@data[identifier]) if @data[identifier].is_a?(String)
    if @data[identifier].is_a?(Float) && !(identifier =~ /^geo_/ui || identifier =~ /^.w_wgs84$/ui || identifier =~ /^.w_etrs89_utm32$/ui)
      return @data[identifier].to_3signdigits if @data[identifier].is_a?(Float)
    end
    return @data[identifier]
  end

  #removes values for null and quotes string
  def clear_string(str)
    ret = str.strip
    return 'null' if ret.empty?
    return 'null' if ret.eql?('-')
    return "'#{ret.gsub("'","''")}'"
  end

  def [](identifier)
    return @data[identifier]
  end

  def write_out
    $db_target.execute("INSERT INTO inspire (
      jahr,
      bundesland,
      kennnummer,
      betriebsname,
      rw_wgs84,
      hw_wgs84,
      rw_etrs89_utm32,
      hw_etrs89_utm32,
      strasse,
      nr,
      plz,
      ort,
      gemeindeschluessel,
      gemeindename,
      process
      ) VALUES (
      #{sqlize('jahr')},
      #{sqlize('land_id')},
      #{sqlize('kennnr')},
      #{sqlize('name')},
      #{sqlize('rw_wgs84')},
      #{sqlize('hw_wgs84')},
      #{sqlize('rw_etrs89_utm32')},
      #{sqlize('hw_etrs89_utm32')},
      #{sqlize('strasse')},
      #{sqlize('nr')},
      #{sqlize('plzstr')},
      #{sqlize('ort')},
      #{sqlize('schl')},
      #{sqlize('ktext')},
      0
      )")
  end

end
