#!/usr/bin/ruby
# -*- coding: utf-8 -*-
#
# e-PRTR P-Modul Datenbank Generator
# (c) 2016, Matthias Lüttgert, 2012 Rory Michele, ENDA GmbH & Co. KG
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# Please note and understand the notices and instructions in the README-file.
#
#
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
#
# Bitte beachten Sie auch die Hinweise in der README-Datei vor Verwendung der Software.
#
#
# Rel-1-1-0, 2016-05-26, mlt: Migration ActiveRecord v2 auf v4, Ruby v1.9 auf v2.3



require 'rubygems'
#require 'ruby-debug19'
require_relative "application_controller.rb"

APPNAME = "E-PRTR P-Modul Datenbank Generator"
APPVERSION = "1.1.0"
# CHANGES
#
# 
ABOUT = <<EOS



(c) ENDA GmbH & Co. KG, 2016, 2012;

Besuchen Sie die Homepage der Firma ENDA unter
https://enda.eu
für Informationen über die ENDA GmbH & Co. KG
EOS



class Float
  def to_3signdigits

    f = ("%.3G" % self).to_f

    if f >= 100
      s = "%.0f" % f
    elsif f >= 10
      s = "%.1f" % f
    elsif f >= 1
      s = "%.2f" % f
    elsif f >= 0.1
      s = "%.3f" % f
    elsif f >= 0.01
      s = "%.4f" % f
    elsif f >= 0.001
      s = "%.5f" % f
    elsif f >= 0.0001
      s = "%.6f" % f
    elsif f >= 0.00001
      s = "%.7f" % f
    elsif f >= 0.000001
      s = "%.8f" % f
    elsif f >= 0.0000001
      s = "%.9f" % f
    else
      # s = "%.10f" % f
      s = "%.2f" % f
    end

    return s
  end
end

class String
  def append_clean_address(part, sep="\n")
    return self if part.nil?
    ret = part.strip
    return self if ret.empty?
    return self if ret.eql?('-')
    self << sep unless self.empty?
    self << ret
  end
end

class NilClass
  def append_clean_address(part, sep="\n")
    return self if part.nil?
    ret = part.strip
    return self if ret.empty?
    return self if ret.eql?('-')
    return ret
  end    
end

inspire = ARGV.any?{|arg| arg == '-i' || arg == '--inspire' }

ap = ApplicationController.new(inspire)
ap.run()

