#!/bin/bash
#
# e-PRTR P-Modul Datenbank Generator
# (c) 2014 Marcus Fritsche, ENDA GmbH & Co. KG
# (c) 2012 Rory Michele, ENDA GmbH & Co. KG
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# Please note and understand the notices and instructions in the README-file.
#
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
#
# Bitte beachten Sie auch die Hinweise in der README-Datei vor Verwendung der Software.
#

########################################################################################
####								   setup			     						####
####      Hier koennen einige programmspezifische Variablen angepasst werde.		####
########################################################################################


#folgend koennen die Verzeichnisse veraendert werden, wleche die dbs enthalten
shmdir="/dev/shm/" #pfad zum RAMfs-Mountpunkt
if [[ ${USER} = "uba" ]] ; then
    dbdir="/home/uba/prtr/db/" #pfad an den die dbs nach beschreiben kopiert werden
else
    dbdir="/home/mlt/dev/ptah/prtr/db/" #pfad an den die dbs nach beschreiben kopiert werden
fi

#die folgenden variablen referenzieren die namen welche in den .yml konfigurationsdateien angegeben sind.
#die namen muessen also gleich lauten wie diese aus den .yml konfigurationsdateien.
dbDe="prtr_de.db" #name unter dem die de db in shm liegt
dbEn="prtr_en.db" #name unter dem die en db in shm liegt
dbIn="prtr_inspire.db" #name unter dem die inspire db in shm liegt


########################################################################################
####								   /setup			     						####
########################################################################################

if [[ ${USER} = "uba" ]] ; then
    workingdir="/home/uba/dev/prtr/prtr-public-db/"
else
    workingdir="/home/mlt/dev/ptah/dev/prtr/prtr-public-db/"
fi
name=`basename $0`
basedir=$(pwd)
rev="0"

cd $workingdir


# Usage info
show_help() {
cat << EOF
Usage: $name [OPTION]
e-PRTR P-Modul Datenbank Generator
Zur Generierung deutscher und/oder englischer SQLite Datenbanken aus der e-PRTR Datenbank.

Optionen koennen nicht kombiniert werden.
Options:
   -h    Gibt diesen Hilfetext aus
   -n 	 Erstellt benoetigte Verzichnisse, SQlite-Datenbanktemplates, Konfigurationsdateien und richtet diese ein
         (Nach Neustart des Systems notwendig, da dann SQLite-Templates im shared memory fehlen)
   -a    Generiert eine deutsche, eine deutsche inspire- und eine englische SQLite Datenbank
   -d    Generiert eine deutsche SQLite Datenbank
   -e    Generiert eine englische SQLite Datenbank
   -i    Generiert eine deutsche SQLite Datenbank mit Inspiretabelle
EOF
}


user_input(){
	while true; do
	    read -p "$@" yn
	    case $yn in
	        [Yy]*) return 2
					;;
	        [Nn]*) return 3
					;;
	        * ) echo "Please answer y for yes or n for no.";;
	    esac
	done
}


make_new(){
	#erstelle benoetigte dirs
	echo "Erstelle benoetigte Verzeichnisse"
	mkdir -p data
	mkdir -p config

	#kopiere std configs
	echo "Kopiere benoetigte Konfigurationsdateien"
	cp -n ./setup/db_source.yml ./config/db_source.yml
	cp -n ./setup/db_target_de.yml ./config/db_target_de.yml
	cp -n ./setup/db_target_en.yml ./config/db_target_en.yml
	cp -n ./setup/db_target_inspire.yml ./config/db_target_inspire.yml

	#erstelle db templates 
	cd ./create_sql
	#erstelle en template
	echo "Erstelle prtr_en_template.db"
	cat *_en.sql | sqlite3 prtr_en_template.db
	if [[ $? == 0 ]]; then
		user_input "Soll die neue prtr_en_template.db nach $shmdir geschrieben werden? Achtung die aktuelle $dbEn in $shmdir wird dabei ueberschrieben yn: "
		if [[ $? == 2 ]]; then
			echo "(yes) schreibe prtr_en_template.db nach $shmdir$dbEn"
			cp prtr_en_template.db $shmdir$dbEn
		 else
		 	echo "(no) prtr_en_template.db wird nicht kopiert"
		fi
		mv prtr_en_template.db ./../data/prtr_en_template.db
	 else
	 	err "Fehler beim erstellen der prtr_de_template.db"
	fi
	#erstelle de template
	echo "Erstelle prtr_de_template.db"
	cat *_de.sql | sqlite3 prtr_de_template.db
	if [[ $? == 0 ]]; then
		user_input "Soll die neue prtr_de_template.db nach $shmdir geschrieben werden? Achtung die aktuelle $dbDe in $shmdir wird dabei ueberschrieben yn: "
		if [[ $? == 2 ]]; then
			echo "(yes) schreibe prtr_de_template.db nach $shmdir$dbDe"
			cp prtr_de_template.db $shmdir$dbDe
		 else
		 	echo "(no) prtr_de_template.db wird nicht kopiert"
		fi
		mv prtr_de_template.db ./../data/prtr_de_template.db
	 else
	 	err "Fehler beim erstellen der prtr_de_template.db"
	fi
	#erstelle inspire template
	echo "Erstelle prtr_inspire_template.db"
	cd ./../data/
	cp prtr_de_template.db prtr_inspire_template.db
	cat ./../create_sql/inspire.sql | sqlite3 prtr_inspire_template.db
	if [[ $? == 0 ]]; then
		user_input "Soll die neue prtr_inspire_template.db nach $shmdir geschrieben werden? Achtung die aktuelle $dbIn in $shmdir wird dabei ueberschrieben yn: "
		if [[ $? == 2 ]]; then
			echo "(yes) schreibe prtr_inspire_template.db nach $shmdir$dbIn"
			cp prtr_inspire_template.db $shmdir$dbIn
		 else
		 	echo "(no) prtr_inspire_template.db wird nicht kopiert"
		fi
	 else
	 	err "Fehler beim erstellen der prtr_de_template.db"
	fi

	cd $workingdir
	return 0
}


find_rev(){
	greatest="0"
	set $(find $dbdir -type f -regextype posix-extended -regex ".*prtr_rel[0-9]+_$1\.db" | grep -o [0-9]*)  >/dev/null
	for i in "$@"; do
		if [[ $i > $greatest ]]; then
			greatest=$i
		fi
	done
	rev=$(($greatest + 1))
}
prc_db(){

	local success="1"

	if [[ $1 == "de" ]]; then
		ruby lib/main.rb
		success=$?
	elif [[ $1 == "en" ]]; then
		ruby lib/main_en.rb
		success=$?
	elif [[ $1 == "inspire" ]]; then
		ruby lib/main.rb --inspire
		success=$?
	else
		err "Fehler bei interner Parameteruebergabe"
	fi

	if [[ $success == 0 ]]; then
		find_rev $1
		local dbPath=$dbdir"prtr_rel"$rev"_"$1".db"
		local shmPath=$shmdir"prtr_"$1".db"
		cp $shmPath $dbPath
		return 0
	else
	 	err "Fehler bei der Generierung der $1 SQLite Datenbank"
	fi
}

ext(){
	cd $basedir
	echo "done"	
	exit 0
}
err() { 
	1>&2 echo "$name: $@";
	1>&2 echo "Try '$name -h' for more information.";
	cd $basedir
	exit 1
}

# check option set
if [ -z $1 ] ; then 
	err "keine Option angegeben"
fi

while getopts 'hnaedi' OPTION ; do
  case "$OPTION" in
    h)  show_help
		cd $basedir
		exit 0
		;;
	n)  make_new
		ext
		;;
    a)	echo "Generiere de, de-inspire und en SQLite db"	
		echo "1/3 Generiere englische SQLite Datenbank"
		prc_db en
		echo "2/3 Generiere deutsche SQLite Datenbank"
		prc_db de
		echo "3/3 Generiere deutsche inspire SQLite Datenbank"
		prc_db inspire
		ext
		;;
    e)	echo "Generiere englische SQLite Datenbank"
		prc_db en
		ext
		;;
    d)	echo "Generiere deutsche SQLite Datenbank"
		prc_db de
		ext
		;;
	i)  echo "Generiere deutsche SQLite Datenbank mit Inspiretabelle"
		prc_db inspire
		ext
		;;
    *)  1>&2 echo "Try '$name -h' for more information."
		cd $basedir
     	exit 1
  esac
done
