# -*- coding: utf-8 -*-
GEHEIMHALTUNGSGRUENDE = [
  ['A',	'Nachteilige Auswirkungen auf Internationale Beziehungen'],#0
  ['B',	'Nachteilige Auswirkungen auf Verteidigung'],#1
  ['C',	'Nachteilige Auswirkungen auf Schutzgüter der öffentlichen Sicherheit'],#2
  ['D',	'Nachteilige Auswirkungen auf ein laufendes Gerichtsverfahren'],#3
  ['E',	'Nachteilige Auswirkungen auf den Anspruch einer Person auf ein faires Verfahren'],#4
  ['F',	'Nachteilige Auswirkungen auf rechtliche Ermittlungen (Straf-, Disziplinarrecht, Ordnungswidrigkeit)'],#5
  ['G',	'Schutz personenbezogener Daten'],#6
  ['H',	'Rechte am geistigen Eigentum verletzt werden'],#7
  ['I',	'Betriebsgeheimnisse'],#8
  ['J',	'Geschäftsgeheimnisse'],#9
  ['K',	'Steuergeheimnisse'],#10
  ['L',	'Statistikgeheimnisse']#11
]

class Entry

#  class << self; attr_accessor :initialized end
  
  attr_accessor :geheimk

  def initialize(row,gk_table)
    @data = row.to_h
    sql = "select geheimk_id from #{gk_table}_geheimk where #{gk_table}_id = #{@data['id']}"
    rs = $db_source.query(sql)
    @geheimk = rs.collect{|i| GEHEIMHALTUNGSGRUENDE[i[0]-1]}
    rs.finish
  end

  def sqlize(identifier)
    return 'null' if @data[identifier].nil?
    return clear_string(@data[identifier]) if @data[identifier].is_a?(String)
    if @data[identifier].is_a?(Float) && !(identifier =~ /^geo_/ui || identifier =~ /^.w_wgs84/ui || identifier =~ /^.w_etrs89_utm32/ui)
      return @data[identifier].to_3signdigits if @data[identifier].is_a?(Float)
    end
    return @data[identifier]
  end

  #removes values for null and quotes string
  def clear_string(str)
    ret = str.strip
    return 'null' if ret.empty?
    return 'null' if ret.eql?('-')
    return "'#{ret.gsub("'","''")}'"
  end

  def [](identifier)
    return @data[identifier]
  end

end
