# -*- coding: utf-8 -*-
#
# This file is part of the "e-PRTR P-Modul Datenbank Generator".
# For more information, see the release information on main.en.rb. 
#
# Diese Datei ist Teil des "e-PRTR P-Modul Datenbank Generator".
# Fuer weitere Informationen und Release-Informationen siehe mein.en.rb.
#

class Freis < Entry
#  @@initialized = false
  def initialize(row, gk_table)
    super(row,gk_table)
    @data['schwellenwert'] = case @data['kompartiment']
                               when 'Air' then @data['schwellenwert_luft']
                               when 'Water' then @data['schwellenwert_wasser']
                               when 'Soil' then @data['schwellenwert_boden']
    end
  end

  def write_out()
    $db_target.execute("INSERT INTO releases (
        id,
        facility_id,
        year,
        compartment,
        annual_load,
        annual_load_accident,
        annual_load_non_biogenic,
        substance_name,
        substance_group,
        substance_casnumber,
        substance_threshold,
        determination_method,
        determination_procedure
      ) VALUES (
      #{sqlize('id')},
      #{sqlize('p_betrieb_id')},
      #{sqlize('jahr')},
      #{sqlize('kompartiment')},
      #{sqlize('jfracht')},
      #{sqlize('vfracht')},
      #{sqlize('nbiofracht')},
      #{sqlize('stoffname')},
      #{sqlize('stoffgruppe')},
      #{sqlize('cas_nr')},
      #{sqlize('schwellenwert')},
      #{sqlize('bmeth')},
      #{sqlize('bverf')}
      )")
    @geheimk.each do |gk|
      $db_target.execute("INSERT INTO releases_pdcc (release_id, reason) VALUES (#{@data['id']},'#{gk[1]}')")
    end

  end


end
