#encoding: utf-8

class RenderController < ApplicationController
  before_filter :login_required
  protect_from_forgery :except => 'naces'
  layout "application"

  BETRIEB = [
    'coalesce (b.name1,\'\')||\' \'||coalesce (b.name2,\'\') as "Name Betriebseinrichtung"',
    'b.kennnr as "Kennnummer"',
    'b.jahr as "Berichtsjahr"',
    'coalesce(b.strasse,\'\')||\' \'||coalesce(b.nr,\'\')||\'<br />\'||coalesce(b.plzstr,\'\')||\' \'||coalesce(b.ort) as "Adresse"',
    'buland as "Bundesland"',
    'flusseinzugsgebiet as "Flusseinzugsgebiet"',
    'coalesce (b.bname1,\'\')||\' \'||coalesce (b.bname2,\'\') as "Name Muttergesellschaft"',
    'b.eigname as "Name Eigentümer"',
    'b.betname as "Name Betreiber"',
    ]
  BETRIEB_GK = [
    '\'vertraulich\' as "Name Betriebseinrichtung"',
    'b.kennnr as "Kennnummer"',
    'b.jahr as "Berichtsjahr"',
    '\'vertraulich\' as "Adresse"',
    'buland as "Bundesland"',
    'flusseinzugsgebiet as "Flusseinzugsgebiet"',
    '\'vertraulich\' as "Name Muttergesellschaft"',
    '\'vertraulich\' as "Name Eigentümer"',
    '\'vertraulich\' as "Name Betreiber"',
    ]


  TAETIGKEIT = [
    't.prtr_taet',
    't.ivu_taet',
  ]
  TAETIGKEIT_GK = [
    '\'vertraulich\' as prtr_taet',
    '\'vertraulich\' as ivu_taet',
  ]

    
  FREISETZUNG_LUFT =[
    'f.jfracht||\' kg\' as "Jahresfracht"',
    'f.vfracht||\' kg\' as "davon <br /> versehentlich"',
    'f.stoff_id as "ID Schadstoff"',
    'f.stoffbez as "Schadstoffbezeichnung lt. Anhang II E-PRTR-VO"',
    'f.cas_nr as "CAS-<br />Nummer"',
    'f.schwellenwert_luft||\' \'||f.einheit_luft as "<a href=""#glossar"">Schwellenwert**</a>  lt. Anhang II E-PRTR-VO"',
    'coalesce(f.bestim,\'\') || \'<method>\' || coalesce(f.bvschl,\'\') || \'<key>\' || coalesce(f.bvcode,\'\') as "Bestimmungsmethode"'
    #'coalesce(f.bvschl,\'\')||\'<key>\'||coalesce(f.bvcode,\'\') as "Bestimmungsverfahren"',
  ]
  FREISETZUNG_LUFT_GK =[
    'f.jfracht||\' kg\' as "Jahresfracht"',
    'f.vfracht||\' kg\' as "davon <br /> versehentlich"',
    'f.sgruppe_id as "ID Schadstoff"',
    'f.stoffgruppenbezeichnung as "Schadstoffbezeichnung lt. Anhang II E-PRTR-VO"',
    '\'vertraulich\' as "CAS-<br />Nummer"',
    '\'vertraulich\' as "<a href=""#glossar"">Schwellenwert**</a>  lt. Anhang II E-PRTR-VO"',
    'coalesce(f.bestim,\'\') || \' (vertraulich)\' as "Bestimmungsmethode"'
  ]

  
  FREISETZUNG_WASSER =[
    'f.jfracht||\' kg\' as "Jahresfracht"',
    'f.vfracht||\' kg\' as "davon <br /> versehentlich"',
    'f.stoff_id as "ID Schadstoff"',
    'f.stoffbez as "Schadstoffbezeichnung lt. Anhang II E-PRTR-VO"',
    'f.cas_nr as "CAS-<br />Nummer"',
    #'f.stoffnr as "Schadstoff-Nr. lt. Anhang II E-PRTR-VO"',
    'f.schwellenwert_wasser||\' \'||f.einheit_wasser as "<a href=""#glossar"">Schwellenwert**</a>  lt. Anhang II E-PRTR-VO"',
    'coalesce(f.bestim,\'\')||\'<method>\'||coalesce(f.bvschl,\'\')||\'<key>\'||coalesce(f.bvcode,\'\') as "Bestimmungsmethode"'
    #'coalesce(f.bvschl,\'\')||\'<key>\'||coalesce(f.bvcode,\'\') as "Bestimmungsverfahren"',
  ]
  FREISETZUNG_WASSER_GK =[
    'f.jfracht||\' kg\' as "Jahresfracht"',
    'f.vfracht||\' kg\' as "davon <br /> versehentlich"',
    'f.sgruppe_id as "ID Schadstoff"',
    'f.stoffgruppenbezeichnung as "Schadstoffbezeichnung lt. Anhang II E-PRTR-VO"',
    '\'vertraulich\' as "CAS-<br />Nummer"',
    '\'vertraulich\' as "<a href=""#glossar"">Schwellenwert**</a>  lt. Anhang II E-PRTR-VO"',
    'coalesce(f.bestim,\'\') || \' (vertraulich)\' as "Bestimmungsmethode"'
  ]
  

  FREISETZUNG_BODEN =[
    'f.jfracht||\' kg\' as "Jahresfracht"',
    'f.vfracht||\' kg\' as "davon <br /> versehentlich"',
    'f.stoff_id as "ID Schadstoff"',
    'f.stoffbez as "Schadstoffbezeichnung lt. Anhang II E-PRTR-VO"',
    'f.cas_nr as "CAS-<br />Nummer"',
    #'f.stoffnr as "Schadstoff-Nr. lt. Anhang II E-PRTR-VO"',
    'f.schwellenwert_boden||\' \'||f.einheit_boden as "<a href=""#glossar"">Schwellenwert**</a>  lt. Anhang II E-PRTR-VO"',
    'coalesce(f.bestim,\'\')||\'<method>\'||coalesce(f.bvschl,\'\')||\'<key>\'||coalesce(f.bvcode,\'\') as "Bestimmungsmethode"'
    #'coalesce(f.bvschl,\'\')||\'<key>\'||coalesce(f.bvcode,\'\') as "Bestimmungsverfahren"',
  ]
  FREISETZUNG_BODEN_GK =[
    'f.jfracht||\' kg\' as "Jahresfracht"',
    'f.vfracht||\' kg\' as "davon <br /> versehentlich"',
    'f.sgruppe_id as "ID Schadstoff"',
    'f.stoffgruppenbezeichnung as "Schadstoffbezeichnung lt. Anhang II E-PRTR-VO"',
    '\'vertraulich\' as "CAS-<br />Nummer"',
    '\'vertraulich\' as "<a href=""#glossar"">Schwellenwert**</a>  lt. Anhang II E-PRTR-VO"',
    'coalesce(f.bestim,\'\') || \' (vertraulich)\' as "Bestimmungsmethode"'
  ]


  VERB_ABWASSER_GK = [
    'w.jfracht||\' kg\' as "Jahresfracht"',
    'w.sgruppe_id as "ID Schadstoff"',
    'w.stoffgruppenbezeichnung as "Schadstoffbezeichnung lt. Anhang II E-PRTR-VO"',
    '\'vertraulich\' as "CAS-Nummer"',
    '\'vertraulich\' as "<a href=""#glossar"">Schwellenwert**</a>  lt. Anhang II E-PRTR-VO"',
    'coalesce(w.bestim,\'\') || \' (vertraulich)\' as "Bestimmungsmethode"'
  ]
  VERB_ABWASSER = [
    'w.jfracht||\' kg\' as "Jahresfracht"',
    'w.stoff_id as "ID Schadstoff"',
    'w.stoffbez as "Schadstoffbezeichnung lt. Anhang II E-PRTR-VO"',
    'w.cas_nr as "CAS-Nummer"',
    'w.schwellenwert_wasser||\' \'||w.einheit_wasser as "<a href=""#glossar"">Schwellenwert**</a>  lt. Anhang II E-PRTR-VO"',
    'coalesce(w.bestim,\'\')||\'<method>\'||coalesce(w.bvschl,\'\')||\'<key>\'||coalesce(w.bvcode,\'\') as "Bestimmungsmethode"'
  ]


  VERB_NICHT_ABFALL = [
    'v.menge||\' t/Jahr\' as "Abfallmenge"',
    'coalesce(v.bestim,\'\')||\'<method>\'||coalesce(v.bvschl,\'\')||\'<key>\'||coalesce(v.bvcode,\'\') as "Bestimmungsmethode"'
 #   'coalesce(v.bvschl,\'\')||\'<key>\'||coalesce(v.bvcode,\'\') as "Bestimmungsverfahren"'
  ]

  VERB_ABFALL_INLAND = [
    'v.menge||\' t/Jahr\' as "Abfallmenge"',
    'coalesce(v.bestim,\'\')||\'<method>\'||coalesce(v.bvschl,\'\')||\'<key>\'||coalesce(v.bvcode,\'\') as "Bestimmungsmethode"'
 #   'coalesce(v.bvschl,\'\')||\'<key>\'||coalesce(v.bvcode,\'\') as "Bestimmungsverfahren"'
  ]
  
  VERB_ABFALL_AUSLAND_VERW = [
    'v.menge||\' t/Jahr\' as "Abfallmenge"',
    'coalesce(v.bestim,\'\')||\'<method>\'||coalesce(coalesce(v.bvschl,\'\'),\'\')||\'<key>\'||coalesce(v.bvcode,\'\') as "Bestimmungsmethode"',
   # 'coalesce(coalesce(v.bvschl,\'\'),\'\')||\'<key>\'||coalesce(v.bvcode,\'\') as "Bestimmungsverfahren"',
    'coalesce(v.vbname,\'\') ||\', \'|| coalesce(v.vbstr,\'\')||\' \'|| coalesce(v.vbstrnr,\'\')||\', \'|| coalesce(v.vbplz,\'\')||\' \'|| coalesce(v.vbort,\'\') as "Verwerter"',
    'coalesce(v.vbsstr,\'\')||\' \'|| coalesce(v.vbsstrnr,\'\')||\', \'|| coalesce(v.vbsplz,\'\')||\' \'|| coalesce(v.vbsort,\'\')||\', \'|| coalesce(v.astaat,\'\') as "Verwertungsstandort"',
  ]
  
  VERB_ABFALL_AUSLAND_BES = [
    'v.menge||\' t/Jahr\' as "Abfallmenge"',
    'coalesce(v.bestim,\'\')||\'<method>\'||coalesce(coalesce(v.bvschl,\'\'),\'\')||\'<key>\'||coalesce(v.bvcode,\'\') as "Bestimmungsmethode"',
   #'coalesce(coalesce(v.bvschl,\'\'),\'\')||\'<key>\'||coalesce(v.bvcode,\'\') as "Bestimmungsverfahren"',
    'coalesce(v.vbname) ||\', \'|| coalesce(v.vbstr)||\' \'|| coalesce(v.vbstrnr)||\', \'|| coalesce(v.vbplz)||\' \'|| coalesce(v.vbort)  as "Beseitiger"',
    'coalesce(v.vbsstr)||\' \'|| coalesce(v.vbsstrnr)||\', \'|| coalesce(v.vbsplz)||\' \'|| coalesce(v.vbsort)||\', \'|| coalesce(v.astaat) as "Beseitigungsstandort"',
  ]


  def log_html(txt)
    puts txt
    return txt+"<br> \n"
  end


  def get_geheim(p_betrieb_id, x_id)
      vertraulich = ActiveRecord::Base.connection.execute("select b.geheimpd, b.geheimge, b.geheimbg, bg.id
        from p_betrieb b, p_betrieb_geheimk bg
        where b.id = #{p_betrieb_id}
          and bg.p_betrieb_id = b.id
          and (b.geheimpd = 0 or b.geheimge = 0 or b.geheimbg = 0) ")
      if vertraulich.num_tuples > 0
        @log += log_html('Generiere HTML für vertraulichen Betrieb mit ID: '+ p_betrieb_id + " (xID: " + x_id + ")")
        return true
      else
        @log += log_html('Generiere HTML für Betrieb mit ID: '+ p_betrieb_id + " (xID: " + x_id + ")")
        return false
      end
  end


  def get_permission(p_betrieb_id)
    vertraulich = ActiveRecord::Base.connection.execute("select b.geheimpd, b.geheimge, b.geheimbg
      from p_betrieb b
      where b.id = #{p_betrieb_id}")
    vertraulich.each do |tupel|
      if tupel["geheimpd"].to_i > 0 || tupel["geheimge"].to_i > 0 ||tupel["geheimbg"].to_i > 0
        puts "Tupel <", tupel["geheimpd"], tupel["geheimge"], tupel["geheimbg"], ">"
        @any_permission_counter += 1
      end
      return true if tupel["geheimpd"].to_i == 1 && tupel["geheimge"].to_i == 1 &&tupel["geheimbg"].to_i == 1
    end
    return false
  end


  def render_html_for_dummies
    #render_html_for_dummies_per_year('2007')
    #puts "#{@any_permission_counter} Betriebe haben mindestens eine von drei Freigaben erteilt."

    render_html_for_dummies_per_year('2008')
    puts "#{@any_permission_counter} Betriebe haben mindestens eine von drei Freigaben erteilt."

    #render_html_for_dummies_per_year('2009')
    #puts "#{@any_permission_counter} Betriebe haben mindestens eine von drei Freigaben erteilt."

    render_html_for_dummies_per_year('2010')
    puts "#{@any_permission_counter} Betriebe haben mindestens eine von drei Freigaben erteilt."

    render :text => @log
  end

  def render_html_for_dummies_per_year(jahr)
    @log = ''
     #jahr = '2009'
#    jahr = session[:reporting_period]
    puts "jahr is of class #{jahr.class} and has value <#{jahr}>"
    @vertraulich_text = 'vertraulich'
    @any_permission_counter = 0
    @permission_counter = 0
    # where p_betrieb_id in (33040)
    # where id in (4949, 4998, 5011, 10407, 4985, 10865)
    @entries = ActiveRecord::Base.connection.execute(
      "select p_betrieb_id, id from betriebe_html_#{jahr}
      order by p_betrieb_id")
    @entries.each do |e|
      where = "id=" + e['p_betrieb_id'].to_s + " AND jahr='" + jahr + "' "
      @geheim = get_geheim(e["p_betrieb_id"], e["id"])
      @permit = get_permission(e["p_betrieb_id"])
      if @permit then
        @permission_counter += 1
        # permit overrides matters of protection:
        @geheim = false
      end
      select_felder = ''
      if @geheim
        BETRIEB_GK.each() { |col| select_felder += col+',' }
      else
        BETRIEB.each() { |col| select_felder += col+',' }
      end
      @betrieb = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from betriebe b where '+where)
      @gis = ActiveRecord::Base.connection.execute("select st_x(b.geo_etrs89_utm32) as rechtswert,
             st_y(b.geo_etrs89_utm32) as hochwert from betriebe_gis_#{jahr} b where p_betrieb_id="+e["p_betrieb_id"].to_s)
      
      #      @log += log_html('Betriebsdaten gefunden...')

      select_felder = ''
      if @geheim
        TAETIGKEIT_GK.each() { |col| select_felder += col+',' }
        @nace = ActiveRecord::Base.connection.execute('select \'vertraulich\' as "nace" from betriebe')
        @taet = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from taetigkeit t where p_betrieb_'+where+' ORDER BY htprtr')
      else
        TAETIGKEIT.each() { |col| select_felder += col+',' }
        @nace = ActiveRecord::Base.connection.execute('select coalesce(nace,\'\')||\' - \'||coalesce(nace_text,\'\') as "nace" from betriebe where '+where+'')
        @taet = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from taetigkeit t where p_betrieb_'+where+' ORDER BY htprtr')
      end
#      @log += log_html(@taet.num_tuples().to_s+' Tätigkeiten gefunden...')
      
      select_felder = ''
      if @geheim
        FREISETZUNG_LUFT_GK.each() { |col| select_felder += col+',' }
        @freis_luft = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from freisetzung f where p_betrieb_'+where+' AND medium=\'Luft\' ORDER BY f.jfracht DESC')
      else
        FREISETZUNG_LUFT.each() { |col| select_felder += col+',' }
        @freis_luft = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from freisetzung f where p_betrieb_'+where+' AND medium=\'Luft\' ORDER BY f.jfracht DESC')
      end
#      @log += log_html(@freis_luft.num_tuples().to_s+' Freisetzungen in die Luft gefunden...')

      select_felder = ''
      if @geheim
        FREISETZUNG_BODEN_GK.each() { |col| select_felder += col+',' }
        @freis_boden = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from freisetzung f where p_betrieb_'+where+' AND medium=\'Boden\' ORDER BY f.jfracht DESC')
      else
        FREISETZUNG_BODEN.each() { |col| select_felder += col+',' }
        @freis_boden = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from freisetzung f where p_betrieb_'+where+' AND medium=\'Boden\' ORDER BY f.jfracht DESC')
      end
      #      @log += log_html(@freis_boden.num_tuples().to_s+' Freisetzungen in den Boden gefunden...')
      
      select_felder = ''
      if @geheim
        FREISETZUNG_WASSER_GK.each() { |col| select_felder += col+',' }
        @freis_wasser = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from freisetzung f where p_betrieb_'+where+' AND medium=\'Wasser\' ORDER BY f.jfracht DESC')
      else
        FREISETZUNG_WASSER.each() { |col| select_felder += col+',' }
        @freis_wasser = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from freisetzung f where p_betrieb_'+where+' AND medium=\'Wasser\' ORDER BY f.jfracht DESC')
      end
      #      @log += log_html(@freis_wasser.num_tuples().to_s+' Freisetzungen in das Wasser gefunden...')
      
      select_felder = ''
      if @geheim
        VERB_ABWASSER_GK.each() { |col| select_felder += col+',' }
        @abw = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from verb_abwasser w where p_betrieb_'+where+' ORDER BY w.jfracht DESC')
      else
        VERB_ABWASSER.each() { |col| select_felder += col+',' }
        @abw = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from verb_abwasser w where p_betrieb_'+where+' ORDER BY w.jfracht DESC')
      end
      #      @log += log_html(@abw.num_tuples().to_s+' Abwasser gefunden...')

      if @geheim
        @abfall = ActiveRecord::Base.connection.execute(
                 "select distinct b.id, b.kennnr, a.abfart_id
                    from p_betrieb b, p_vabf a
                    where a.p_betrieb_id = b.id
                    and b.id = " + e["p_betrieb_id"])
      else
        # Nicht geheim:
        select_felder = ''
        VERB_NICHT_ABFALL.each() { |col| select_felder += col+',' }
        @abfnv = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from verb_abfall v where p_betrieb_'+where+' AND v.abfartschl=\'2\' AND v.verbesschl=\'R\'')
        #      @log += log_html(@abfnv.num_tuples().to_s+' Nicht gefährliche zu verwertende Abfälle gefunden...')

        select_felder = ''
        VERB_NICHT_ABFALL.each() { |col| select_felder += col+',' }
        @abfnb = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'2\' AND v.verbesschl=\'D\'')
        #      @log += log_html(@abfnb.num_tuples().to_s+' Nicht gefährliche zu beseitigende Abfälle gefunden...')
        @abfnc = ActiveRecord::Base.connection.execute('select sum(v.menge)||\' t/Jahr\' as summe from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'2\'')

        select_felder = ''
        VERB_ABFALL_INLAND.each() { |col| select_felder += col+',' }
        @abfiv = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'1\' AND v.alandschl=\'I\' AND v.verbesschl=\'R\'')
        #      @log += log_html(@abfiv.num_tuples().to_s+' Gefährliche im Inland zu verwertende Abfälle gefunden...')

        select_felder = ''
        VERB_ABFALL_INLAND.each() { |col| select_felder += col+',' }
        @abfib = ActiveRecord::Base.connection.execute('select '+select_felder.chop+' from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'1\' AND v.alandschl=\'I\' AND v.verbesschl=\'D\'')
        #      @log += log_html(@abfib.num_tuples().to_s+'Gefährliche im Inland zu beseitigende Abfälle gefunden...')
        @abfic = ActiveRecord::Base.connection.execute('select sum(v.menge)||\' t/Jahr\' as summe from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'1\' AND v.alandschl=\'I\'')

        select_felder = ''
        VERB_ABFALL_AUSLAND_VERW.each() { |col| select_felder += col+',' }
        statement = 'select '+select_felder.chop+' from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'1\' AND v.alandschl=\'A\' AND v.verbesschl=\'R\''
        # puts statement
        @abfav = ActiveRecord::Base.connection.execute(statement)
        #      @log += log_html(@abfav.num_tuples().to_s+'Gefährliche im Ausland zu verwertende Abfälle gefunden...')
        @abfavc = ActiveRecord::Base.connection.execute('select sum(v.menge)||\' t/Jahr\' as summe from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'1\' AND v.alandschl=\'A\' AND v.verbesschl=\'R\'')

        select_felder = ''
        VERB_ABFALL_AUSLAND_BES.each() { |col| select_felder += col+',' }
        statement = 'select '+select_felder.chop+' from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'1\' AND v.alandschl=\'A\' AND v.verbesschl=\'D\''
        # puts statement
        @abfab = ActiveRecord::Base.connection.execute(statement)
        #@log += log_html(@abfab.num_tuples().to_s+' Gefährliche im Ausland zu beseitigende Abfälle gefunden...')
        @abfabc = ActiveRecord::Base.connection.execute('select sum(v.menge)||\' t/Jahr\' as summe from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'1\' AND v.alandschl=\'A\' AND v.verbesschl=\'D\'')
        @abfac = ActiveRecord::Base.connection.execute('select sum(v.menge)||\' t/Jahr\' as summe from verb_abfall v where p_betrieb_'+where+'AND v.abfartschl=\'1\' AND v.alandschl=\'A\'')

      end

      # Schutzgründe
      statement = "select lsg.ltext as schutzgrund
        from p_betrieb pb, p_betrieb_geheimk pbg, l_schutzgruende lsg
        where pb.id = #{e['p_betrieb_id'].to_s}
          and pbg.p_betrieb_id = pb.id
          and pbg.geheimk_id = lsg.id
        order by lsg.sortier"
      @schutzgruende = ActiveRecord::Base.connection.execute(statement)

      #@log += log_html('Aktualisiere Datensatz...')
      #
      ## RENDERING ##

      @is_entry = ActiveRecord::Base.connection.execute("select id from betriebe_html_#{jahr} where p_betrieb_id=" + e["p_betrieb_id"].to_s)
      if @geheim
        renderer_template = 'render/betrieb_gk'
      else
        renderer_template = 'render/betrieb'
      end
      if @is_entry.num_tuples()==0
        @result = ActiveRecord::Base.connection.execute(
          "INSERT INTO betriebe_html_#{jahr} (content, p_betrieb_id, id) VALUES ($$" +
            render_to_string(:template => renderer_template, :layout => false) +
            '$$ , ' + e["p_betrieb_id"].to_s + ', ' + e["p_betrieb_id"].to_s + ')'  )
      else
        @result = ActiveRecord::Base.connection.execute("UPDATE betriebe_html_#{jahr} SET content=$$" +
            render_to_string(:template => renderer_template, :layout => false) +
            '$$ where p_betrieb_id=' + e["p_betrieb_id"].to_s)
      end
      @write_additional_file = true
      if @write_additional_file
        File.open("log/betriebe/betrieb_id_#{e["p_betrieb_id"].to_s}.html", "w") do |file|
          file.syswrite(render_to_string(:template => renderer_template, :layout => false))
        end
      end

      #      @log += log_html('Aktualisierung beendet. ')
      if @geheim
        @abfall.clear()
      else
        @abfab.clear()
        @abfabc.clear()
        @abfac.clear()
        @abfav.clear()
        @abfavc.clear()
        @abfib.clear()
        @abfic.clear()
        @abfiv.clear()
        @abfnb.clear()
        @abfnc.clear()
        @abfnv.clear()
      end
      @abw.clear()
      @taet.clear()
      @betrieb.clear()
      @freis_boden.clear()
      @freis_luft.clear()
      @freis_wasser.clear()
      @is_entry.clear()
      @result.clear()
      @schutzgruende.clear()
    end

  end

  def view_betrieb
    jahr = session[:reporting_period]
    id = params[:id]
    id ||= 3788.to_s
    @res = ActiveRecord::Base.connection.execute("select content from betriebe_html_#{jahr} b where p_betrieb_id="+id.to_s)
    raise ActionController::RoutingError.new('Not Found') if @res.num_tuples==0 
    parts=@res[0]["content"].split('<link type="text/css" rel="stylesheet" media="screen" href="./stylesheets/style.css">')
    render :text => parts[0]+'<link type="text/css" rel="stylesheet" media="screen" href="/stylesheets/style.css">'+parts[1]
  end

  def glossar
    @bv = ActiveRecord::Base.connection.execute('select schl, ltext from l_bestimmungsverfahren')
    @bva = ActiveRecord::Base.connection.execute('select schl, ltext from l_bestimmungsverfahren_abfall')
  end

#  def log_for_html(text)
#    puts text;
#  end

  
end
