#encoding: utf-8

class AbfrageController < ApplicationController

  def fracht_versehentlich
    jahr = session[:reporting_period]
    zaehler = -1
    @ergebnis = Array.new
    sql_string = %Q$select b.kennnr as "Kennnummer",
          b.jahr as "Berichtsjahr",
          f.jfracht::varchar as "Freisetzung:Jahresfracht(kg/a)",
          f.vfracht::varchar as "Freisetzung:Fracht versehentlich(kg/a)" from betriebe b,
          freisetzung f
        where b.jahr = '#{jahr}'
        and b.id = f.p_betrieb_id
        and f.vfracht > f.jfracht$
    @result = ActiveRecord::Base.connection.execute(sql_string)

    if @result
      @result.each do |row|
        tmp = Array.new
        for i in 0..@result.fields.length-1
          tmp[i] = row[@result.fields[i]].to_s
        end
        zaehler += 1
        @ergebnis[zaehler] = tmp
      end
    end
    @betriebe = zaehler + 1
  end

  def betriebspflichtfelder
  #TODO: Vereinheitlichen mit anderen Prüfungen - rmi (2013-05-15) 
    jahr = session[:reporting_period]
    @ergebnis = Array.new
    zaehler1 = -1
    sql_string = %Q/select b.kennnr as "Kennnummer", b.bname1 as "Muttergesellschaft:Name Teil 1 ", b.name1 as "Betriebseinrichtung:Name Teil 1", b.strasse as "Betriebseinrichtung:Straße", b.nr as "Betriebseinrichtung:Hausnr.", b.plzstr as "Betriebseinrichtung:PLZ", b.ort as "Betriebseinrichtung:Ort", flusseinzugsgebiet as "Betriebseinrichtung :Flusseinzugsgebiet", nace as "Betriebseinrichtung:NACE",
                    collect_geheimk(b.id, \'p_betrieb\', \'<br>\') as "Vertraulichkeit:Geheimhaltungsgrund", geheimpd,geheimge,geheimbg from betriebe b
                    where b.jahr = '#{jahr}'
                    and ((b.bname1 is null and (collect_geheimk(b.id, 'p_betrieb', '<br>')='' or (geheimpd+geheimge+geheimbg=3 and exists(select * from p_betrieb_geheimk g where b.id = g.p_betrieb_id and (g.geheimk_id in (7,8,9,10,11,12) ))))) or
                          (b.name1 is null and (collect_geheimk(b.id, 'p_betrieb', '<br>')='' or (geheimpd+geheimge+geheimbg=3 and exists(select * from p_betrieb_geheimk g where b.id = g.p_betrieb_id and (g.geheimk_id in (7,8,9,10,11,12) ))))) or
                          (b.strasse is null and (collect_geheimk(b.id, 'p_betrieb', '<br>')='' or (geheimpd+geheimge+geheimbg=3 and exists(select * from p_betrieb_geheimk g where b.id = g.p_betrieb_id and (g.geheimk_id in (7,8,9,10,11,12) ))))) or
                          (b.nr is null and (collect_geheimk(b.id, 'p_betrieb', '<br>')='' or (geheimpd+geheimge+geheimbg=3 and exists(select * from p_betrieb_geheimk g where b.id = g.p_betrieb_id and (g.geheimk_id in (7,8,9,10,11,12) ))))) or
                          (b.plzstr is null and (collect_geheimk(b.id, 'p_betrieb', '<br>')='' or (geheimpd+geheimge+geheimbg=3 and exists(select * from p_betrieb_geheimk g where b.id = g.p_betrieb_id and (g.geheimk_id in (7,8,9,10,11,12) ))))) or
                          (b.ort is null and (collect_geheimk(b.id, 'p_betrieb', '<br>')='' or (geheimpd+geheimge+geheimbg=3 and exists(select * from p_betrieb_geheimk g where b.id = g.p_betrieb_id and (g.geheimk_id in (7,8,9,10,11,12) ))))) or
                          flusseinzugsgebiet is null or nace is null or int2bool(b.bgeheim) is null)/
    @result = ActiveRecord::Base.connection.execute(sql_string)
    
    @result.each do |row|
      tmp = Array.new
      erlaubt = 0
      for i in 0..@result.fields.length-1
        case i #caseabfrage und erlaubt sind notwendig um aus den drei einsen ein ja zu machen (bzw. nein, wenn nicht alles 1 ist)
        when @result.fields.length-4
          if row[@result.fields[i]].to_s.empty?
            tmp[i] = "XXX"
          else
            tmp[i] = row[@result.fields[i]].to_s
          end
        when @result.fields.length-3
          erlaubt += row[@result.fields[i]].to_i
        when @result.fields.length-2
          erlaubt += row[@result.fields[i]].to_i
        when @result.fields.length-1
          erlaubt += row[@result.fields[i]].to_i
        else
          tmp[i] = row[@result.fields[i]].to_s
        end    
      end
      if erlaubt == 3
        tmp[@result.fields.length-3] = "JA"
      else
        tmp[@result.fields.length-3] = "NEIN"
      end
      #@ergebnis wird gefüllt
      zaehler1 +=1
      @ergebnis[zaehler1] = tmp
    end
    @betriebe = zaehler1+1
  end

  def haupttaetigkeit
    jahr = session[:reporting_period]
    @result_new = []
    tmp_row = {:kennnr => ''}
    sql_string =%Q/select b.kennnr, t.htprtr, t.prtr_taet,
collect_geheimk(coalesce(t.id,0), 'p_taet', '<br>') as gks,
collect_geheimk(b.id, 'p_betrieb', '<br>') as bgks,
b.geheimpd,b.geheimge,b.geheimbg, bsource.xml3export
            from betriebe b
            join p_betrieb bsource on b.jahr = '#{jahr}' and bsource.id = b.id
            left join taetigkeit t on b.id = t.p_betrieb_id
            order by kennnr, htprtr/
    @result = ActiveRecord::Base.connection.execute(sql_string)
    @result.each do |row|
		if tmp_row[:kennnr] == row['kennnr']
			tmp_row[:taet] << row['prtr_taet']
			tmp_row[:gks] << row['gks']
			tmp_row[:found_ht] = true if row['htprtr'] == 'JA'
		else
			unless tmp_row[:found_ht] or tmp_row[:kennnr].blank?
				@result_new << tmp_row 
			end
			tmp_row = {
				:kennnr => row['kennnr'], 
				:taet => [row['prtr_taet']], 
				:found_ht => (row['htprtr'] == 'JA'),
				:gks => [row['gks']],
				:bgks =>  row['bgks'],
				:xml3export => row['xml3export'],
				:freigabe => (row['geheimpd'].to_i == 1 and row['geheimge'].to_i == 1 and row['geheimbg'].to_i == 1)
				}
		end
    end 
	@result_new << tmp_row unless tmp_row[:found_ht] or tmp_row[:kennnr].blank?
  end

  def freisetz_frachten #qs pflichtfelder freisetzungen
    jahr = session[:reporting_period]

	sql_string = %Q$select distinct b.kennnr, w.medium, w.stoffbez, w.stoffnr, w.stoffgruppenbezeichnung, w.jfracht, w.bestim, w.bvcode, w.bvmet, w.messverf,
collect_geheimk(w.id, 'p_freis', '<br>') as gks, 
b.geheimpd,b.geheimge,b.geheimbg, bsource.xml3export,
w.bvschl
from betriebe b
join freisetzung w on b.jahr = '2011' and b.id = w.p_betrieb_id
join p_betrieb bsource on bsource.id = b.id$

    result = ActiveRecord::Base.connection.execute(sql_string)
    
    @result_new = []
    result.each do |row|
		tmp_row = {:data => row, :problems => {}}
		if row['bestim'].blank?
			tmp_row[:problems]['bestim'] = {:text => 'Fehlende Angabe Bestimmungsmethode (bestim)'}
		end
		if row['jfracht'].blank?
			tmp_row[:problems]['jfracht'] = {:text => 'Fehlende Angabe Jahresfracht'}
		end
		freigabe = (row['geheimpd'].to_i == 1 and row['geheimge'].to_i == 1 and row['geheimbg'].to_i == 1)
		if row['gks'].blank? or freigabe
			if row['stoffnr'].blank?
				tmp_row[:problems]['stoffnr'] = {:text => 'Fehlende Angabe Verbrachter Stoff bei nicht vertraulich zu haltender Abwasserverbringung'}
				tmp_row[:problems]['stoffbez'] = {:text => 'Fehlende Angabe Verbrachter Stoff bei nicht vertraulich zu haltender Abwasserverbringung'}
			end
			if row['bvcode'].blank? and !('Schätzung' == row['bestim'])
				tmp_row[:problems]['bvcode'] = {:text => 'Fehlende Angabe Bestimmungsverfahren (bvcode) bei nicht geschätzter und nicht vertraulich zu haltender Abwasserverbringung'}
			else
				if row['messverf'].blank?
					case row['bvschl']
					when 'INT (M) CEN/ISO', 'INT (C) IPCC', 'INT (C) ETS', 'INT (C) UN-ECE/EMEP' then 
						tmp_row[:problems]['messverf'] = {:text => 'Fehlende Angabe Messverfahren bei nicht vertraulich zu haltender Abwasserverbringung'}
					end
				elsif row['messverf'].length > 255
					tmp_row[:problems]['messverf'] = {:text => 'Angabe Messverfahren zu lang (max. 255 Zeichen)'}
				end
			end
			#~ if row[''].blank?
				#~ tmp_row[:problems][''] = {:text => ''}
			#~ end
		else
			if row['stoffgruppenbezeichnung'].blank? 
				tmp_row[:problems]['stoffgruppenbezeichnung'] = {:text => 'Fehlende Angabe Stoffgruppe bei vertraulich zu haltender Abwasserverbringung'}
			end			
		end
		
		unless tmp_row[:problems].empty?
			unless row['gks'].blank?
				tmp_row[:data]['freigabe'] = freigabe ? 'Ja' : 'Nein'
			end
			@result_new << tmp_row
		end
    end
    
    @betriebe = @result_new.length
  end

  # Abwasserverbringung
  def abwasser
    jahr = session[:reporting_period]

	sql_string = %Q$select distinct b.kennnr, w.stoffbez, w.stoffnr, w.stoffgruppenbezeichnung, w.jfracht, w.bestim, w.bvcode, w.bvmet, w.messverf,
collect_geheimk(w.id, 'p_vabw', '<br>') as gks, 
b.geheimpd,b.geheimge,b.geheimbg, bsource.xml3export,
w.bvschl
from betriebe b
join verb_abwasser w on b.jahr = '2011' and b.id = w.p_betrieb_id
join p_betrieb bsource on bsource.id = b.id$

    result = ActiveRecord::Base.connection.execute(sql_string)
    
    @result_new = []
    result.each do |row|
		tmp_row = {:data => row, :problems => {}}
		if row['bestim'].blank?
			tmp_row[:problems]['bestim'] = {:text => 'Fehlende Angabe Bestimmungsmethode (bestim)'}
		end
		if row['jfracht'].blank?
			tmp_row[:problems]['jfracht'] = {:text => 'Fehlende Angabe Jahresfracht'}
		end
		freigabe = (row['geheimpd'].to_i == 1 and row['geheimge'].to_i == 1 and row['geheimbg'].to_i == 1)
		if row['gks'].blank? or freigabe
			if row['stoffnr'].blank?
				tmp_row[:problems]['stoffnr'] = {:text => 'Fehlende Angabe Verbrachter Stoff bei nicht vertraulich zu haltender Abwasserverbringung'}
				tmp_row[:problems]['stoffbez'] = {:text => 'Fehlende Angabe Verbrachter Stoff bei nicht vertraulich zu haltender Abwasserverbringung'}
			end
			if row['bvcode'].blank? and !('Schätzung' == row['bestim'])
				tmp_row[:problems]['bvcode'] = {:text => 'Fehlende Angabe Bestimmungsverfahren (bvcode) bei nicht geschätzter und nicht vertraulich zu haltender Abwasserverbringung'}
			else
				if row['messverf'].blank?
					case row['bvschl']
					when 'INT (M) CEN/ISO', 'INT (C) IPCC', 'INT (C) ETS', 'INT (C) UN-ECE/EMEP' then 
						tmp_row[:problems]['messverf'] = {:text => 'Fehlende Angabe Messverfahren bei nicht vertraulich zu haltender Abwasserverbringung'}
					end
				elsif row['messverf'].length > 255
					tmp_row[:problems]['messverf'] = {:text => 'Angabe Messverfahren zu lang (max. 255 Zeichen)'}
				end
			end
			#~ if row[''].blank?
				#~ tmp_row[:problems][''] = {:text => ''}
			#~ end
		else
			if row['stoffgruppenbezeichnung'].blank? 
				tmp_row[:problems]['stoffgruppenbezeichnung'] = {:text => 'Fehlende Angabe Stoffgruppe bei vertraulich zu haltender Abwasserverbringung'}
			end			
		end
		
		unless tmp_row[:problems].empty?
			unless row['gks'].blank?
				tmp_row[:data]['freigabe'] = freigabe ? 'Ja' : 'Nein'
			end
			@result_new << tmp_row
		end
    end
    
    @betriebe = @result_new.length
  end

  def abfallverbringung
  #rmi(2013-05-14): dies ist die einzige QS, die bereits von mir überarbeitet wurde --edt:nicht mehr, jetzt nur noch betriebe (2013-05-15)
    jahr = session[:reporting_period]
    @ergebnis = Array.new
    #abfallverbringung

	sql_string = %Q$Select distinct b.kennnr, v.abfart, v.verbes, v.aland,
v.astaat, v.menge , v.bestim, v.bvcode, v.bvmet, 
v.vbname, v.vbstr, v.vbstrnr, v.vbplz, v.vbort, v.vbstaat,
v.vbsstr, v.vbsstrnr, v.vbsplz, v.vbsort, v.vbsstaat,
collect_geheimk(v.id, 'p_vabf', '<br>') as gks, 
bsource.xml3export,
b.geheimpd, b.geheimge, b.geheimbg, v.abfartschl, v.alandschl
from betriebe b
join verb_abfall v on b.jahr = '#{jahr}' and b.id = v.p_betrieb_id
join p_betrieb bsource on bsource.id = b.id
order by b.kennnr$

    result = ActiveRecord::Base.connection.execute(sql_string)
    @result_new = []
    result.each do |row|
		tmp_row = {:data => row, :problems => {}}
		if row['abfartschl'].to_i==1 and row['aland'].blank?
			tmp_row[:problems]['aland'] = {:text => 'Fehlende Angabe Inland/Ausland bei gefährlichem Abfall'}
		end
		freigabe = (row['geheimpd'].to_i == 1 and row['geheimge'].to_i == 1 and row['geheimbg'].to_i == 1)
		if row['gks'].blank? or freigabe
			if row['verbes'].blank?
				tmp_row[:problems]['verbes'] = {:text => 'Fehlende Angabe Verwertung/Beseitung bei nicht vertraulich zu haltender Abfallverbringung'}
			end
			if row['bestim'].blank?
				tmp_row[:problems]['bestim'] = {:text => 'Fehlende Angabe Bestimmungsmethode bei nicht vertraulich zu haltender Abfallverbringung'}
			end
			if row['bvcode'].blank? and !('Schätzung' == row['bestim'])
				tmp_row[:problems]['bvcode'] = {:text => 'Fehlende Angabe Bestimmungsverfahren bei nicht geschätzter und nicht vertraulich zu haltender Abfallverbringung'}
			end
			#~ if row['abfartschl'].to_i==1 and row['alandschl']=='A' and row['astaat'].blank?
				#~ tmp_row[:problems]['astaat'] = {:text => 'Fehlende Angabe Verbringungsland(astaat) bei nicht vertraulich zu haltender Abfallverbringung'}
			#~ end
			if row['abfartschl'].to_i==1 and row['alandschl']=='A'
				if row['vbname'].blank?
					tmp_row[:problems]['vbname'] = {:text => 'Fehlende Angabe Name des Verbringers (vbname) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbstr'].blank?
					tmp_row[:problems]['vbstr'] = {:text => 'Fehlende Angabe Straße des Verbringers (vbstr) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbstrnr'].blank?
					tmp_row[:problems]['vbstrnr'] = {:text => 'Fehlende Angabe Hausnummer des Verbringers (vbstrnr) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbplz'].blank?
					tmp_row[:problems]['vbplz'] = {:text => 'Fehlende Angabe PLZ des Verbringers (vbplz) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbort'].blank?
					tmp_row[:problems]['vbort'] = {:text => 'Fehlende Angabe Ort des Verbringers (vbort) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbstaat'].blank?
					tmp_row[:problems]['vbstaat'] = {:text => 'Fehlende Angabe Land des Verbringers (vbstaat) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				
				if row['vbsstr'].blank?
					tmp_row[:problems]['vbsstr'] = {:text => 'Fehlende Angabe Straße des Abfallziels (vbsstr) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbsstrnr'].blank?
					tmp_row[:problems]['vbsstrnr'] = {:text => 'Fehlende Angabe Hausnummer des Abfallziels (vbsstrnr) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbsplz'].blank?
					tmp_row[:problems]['vbsplz'] = {:text => 'Fehlende Angabe PLZ des Abfallziels (vbsplz) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbsort'].blank?
					tmp_row[:problems]['vbsort'] = {:text => 'Fehlende Angabe Ort des Abfallziels (vbsort) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
				if row['vbsstaat'].blank?
					tmp_row[:problems]['vbsstaat'] = {:text => 'Fehlende Angabe Land des Abfallziels (vbsstaat) bei nicht vertraulich zu haltender Verbringung gefährlichen Abfalls ins Ausland'}
				end
			end
			#~ if row[''].blank?
				#~ tmp_row[:problems][''] = {:text => ''}
			#~ end
		end
		
		unless tmp_row[:problems].empty?
			unless row['gks'].blank?
				tmp_row[:data]['freigabe'] = freigabe ? 'Ja' : 'Nein'
			end
			@result_new << tmp_row
		end
    end
    
    @betriebe = @result_new.length
  end

  def schad_unterschr_schww
    jahr = session[:reporting_period]
    @ergebnis = Array.new
    #Schwellenwertüberschreitung
    sql_string = %Q$select distinct b.kennnr as "Kennnummer", f.medium as "Medium", f.stoffbez as "Stoff", f.jfracht as "Jahresfracht", f.schwellenwert_luft as "Schwellenwert"
      from freisetzung f, betriebe b 
      where b.jahr = '#{jahr}'
      and b.id = f.p_betrieb_id and f.medium = 'Luft' and f.schwellenwert_luft > f.jfracht
        union
      select distinct b.kennnr as "Kennnummer", f.medium as "Medium", f.stoffbez as "Stoff", f.jfracht as "Jahresfracht", f.schwellenwert_boden as "Schwellenwert"
      from freisetzung f, betriebe b 
      where b.jahr = '#{jahr}'
      and b.id = f.p_betrieb_id and f.medium = 'Boden' and f.schwellenwert_boden > f.jfracht
        union
      select distinct b.kennnr as "Kennnummer", f.medium as "Medium", f.stoffbez as "Stoff", f.jfracht as "Jahresfracht", f.schwellenwert_wasser as "Schwellenwert"
      from freisetzung f, betriebe b 
      where b.jahr = '#{jahr}'
      and b.id = f.p_betrieb_id and f.medium = 'Wasser' and f.schwellenwert_wasser > f.jfracht
      order by "Kennnummer"$
    @result = ActiveRecord::Base.connection.execute(sql_string)
    zaehler = -1
    @result.each do |row|
      tmp = Array.new # Array muss immer neu gemacht werden, sonst stehen im ergebnis nur Zeiger
      for i in 0..@result.fields.length-1
        tmp[i] = row[@result.fields[i]].to_s
      end
      zaehler +=1
      @ergebnis[zaehler] = tmp
    end
    @betriebe = zaehler+1
  end

  def koordinaten
#    jahr = session[:reporting_period]
#    puts params[:entfernung]
#    if params[:entfernung]
#      @entfernung = params[:entfernung]
#    else
#      @entfernung = "100"
#    end
#
#    @ergebnis = Array.new
#    sql_string = %Q$select distinct bld.ltext, b.kennnr
#from l_bundeslaender bld, p_betrieb b
#where b.state = 0
#and b.date_from <= (#{jahr}*10000+101)
#and b.date_to   >= (#{jahr}*10000+1231)
#and b.land_id=bld.id
#and not st_dwithin(b.geo_etrs89_utm32, bld.the_geom_etrs89_utm32, #@entfernung)
#order by bld.sortier, b.kennnr$
#    @result = ActiveRecord::Base.connection.execute(sql_string)
#    zaehler = -1
#    @result.each do |row|
#      tmp = Array.new # Array muss immer neu gemacht werden, sonst stehen im ergebnis nur Zeiger
#      for i in 0..@result.fields.length-1
#        tmp[i] = row[@result.fields[i]].to_s
#      end
#      zaehler +=1
#      @ergebnis[zaehler] = tmp
#    end
#    @betriebe = zaehler+1
  end
end
