#encoding: utf-8

class StartController < ApplicationController
  before_filter :login_required
  protect_from_forgery :except => 'naces'
  layout "application"

  BETRIEB = [
    'b.jahr as "Berichtsjahr"',
    'buland as "Bundesland"',
    'b.kennnr as "Kennnummer"',
    'b.bname1 as "Muttergesellschaft:Name Teil 1 "',
    'b.bname2 as "Muttergesellschaft:Name Teil 2 "',
    'b.betname as "Betreiber:Name"',
    'b.email as "Betreiber:E-Mail"',
    'b.bemerk as "Betreiber:Sonstiges"',
    'b.eigname as "Eigentümer:Name"',
    'b.name1 as "Betriebseinrichtung:Name Teil 1"',
    'b.name2 as "Betriebseinrichtung:Name Teil 2"',
    'b.strasse as "Betriebseinrichtung:Straße"',
    'b.nr as "Betriebseinrichtung:Hausnr."',
    'b.plzstr as "Betriebseinrichtung:PLZ"',
    'b.ort as "Betriebseinrichtung:Ort"',
    'gemeinde as "Betriebseinrichtung :Gemeinde"',
    'b.rechtsw as "Betriebseinrichtung :Rechtswert"',
    'b.hochw as "Betriebseinrichtung :Hochwert"',
    'wgs84 as "Betriebseinrichtung :WGS84"',
    'flusseinzugsgebiet as "Betriebseinrichtung :Flusseinzugsgebiet"',
    'nace as "Betriebseinrichtung:NACE"',
    'nace_text as "Betriebseinrichtung:NACE-Text"',
    'b.prodvol as "Betriebseinrichtung:Produktionsvolumen"',
    'b.anlzahl as "Betriebseinrichtung:Anlagenzahl"',
    'b.betriebh as "Betriebseinrichtung:Betriebsstunden"',
    'b.beszahl as "Betriebseinrichtung:Beschäftigtenanzahl"',
    'b.bbemerk as "Betriebseinrichtung:Bemerkung(Behörde)"',
    'luftschwelle as "Schwellenwertüberschreitung:Luft"',
    'bodenschwelle as "Schwellenwertüberschreitung:Boden"',
    'wasserschwelle as "Schwellenwertüberschreitung:Wasser"',
    'verbwasserschwelle as "Schwellenwertüberschreitung:VerbWasser"',
    'verbabfallschwelle as "Schwellenwertüberschreitung:VerbAbfall"',
    'verbgefaehrlicherabfallschwelle as "Schwellenwertüberschreitung:VerbGefaehrlicherAbfall"',
    'int2de_date(b.freigabe_date) as "Freigabe:Datum"',
    'int2time(b.freigabe_time) as "Freigabe:Uhrzeit"',
    'int2de_date(b.pruefdb_date) as "Geprüft:Datum"',
    'int2time(b.pruefdb_time) as "Geprüft:Uhrzeit"',
    'int2de_date(b.abgabeer_date) as "Erster Abgabetermin:Datum"',
    'int2time(b.abgabeer_time) as "Erster Abgabetermin:Uhrzeit"',
    'int2de_date(b.abgabele_date) as "Letzter Abgabetermin:Datum"',
    'int2time(b.abgabele_time) as "Letzter Abgabetermin:Uhrzeit"',
    'int2de_date(laenddat_date) as "Letzte Änderung(alle Daten):Datum"',
    'int2time(laenddat_time) as "Letzte Änderung(alle Daten):Uhrzeit"',
    'int2de_date(b.aenddat_date) as "Letzte Änderung:Datum"',
    'int2time(b.aenddat_time) as "Letzte Änderung:Uhrzeit"',
    'bearbeitungsstatus as "Bearbeitungsstatus"',
    'pruefstatus as "Prüfstatus:Vertraulichkeit"',
    'pruefstatusluft as "Prüfstatus:Luft"',
    'pruefstatusboden as "Prüfstatus:Boden"',
    'pruefstatuswasser as "Prüfstatus:Wasser"',
    'pruefstatusabfall as "Prüfstatus:Abfall"',
    'collect_geheimk(b.id, \'p_betrieb\', \'<br>\') as "Vertraulichkeit:Geheimhaltungsgrund"',
    'b.geheimd as "Vertraulichkeit:Darlegung"',
    'int2bool(b.geheimpd) as "Vertraulichkeit:PersBezDat"',
    'int2bool(b.geheimge) as "Vertraulichkeit:Geistiges Eig."',
    'int2bool(b.geheimbg) as "Vertraulichkeit:Betriebsg."',
    'int2bool(b.bgeheim) as "Vertraulichkeit:Behörde"',
    'b.bgeheimb as "Vertraulichkeit:Behörde(Begründung)"'
  ]
    
  BETRIEBS_EIGENSCHAFTEN_GRUPPEN = [#Format: [<<value(also beliebig, aber klein und ein Wort, mit all und none als special>>, <<[]mit Spalten oder leer, wenn alle>>, <<Anzeigename>>]
    #['steht im select', ['was soll gezeigt werden'], 'name für Java-Script'],
    ['Alle', [], 'all'],
    ['Keine', [], 'none'],
    ['Benutzerdefiniert', [], 'custom'],
    ['Minimal', ['Berichtsjahr', 'Kennnummer',
        'Betriebseinrichtung:Name Teil 1', 'Betriebseinrichtung:Name Teil 2'],
      'simple'],
    ['Gängigste',
      ['Berichtsjahr', 'Bundesland',
        'Kennnummer',
        'Betriebseinrichtung:Name Teil 1',
        'Betriebseinrichtung:Name Teil 2',
        'Betriebseinrichtung:Ort',
        'Betriebseinrichtung :Flusseinzugsgebiet',
        'Betriebseinrichtung:NACE', 'Betriebseinrichtung:NACE-Text'],
      'complicated']
  ]


  TAETIGKEIT = [
    't.jahr::varchar as "Tätigkeit:Berichtsjahr"',
    't.prtr_taet::varchar as "Tätigkeit:PRTR-Tätigkeit"',
    't.htprtr::varchar as "Tätigkeit:Haupttätigkeit"',
    't.ivu_taet::varchar as "Tätigkeit:IVU-Tätigkeit"',
    't.geheim::varchar as "Tätigkeit:Vertraulichkeit"',
    'collect_geheimk(t.id, \'p_taet\', \'<br>\')::varchar as "Tätigkeit:Geheimhaltungsgrund"',
    't.geheimd::varchar as "Tätigkeit:Vertraulichkeit Darlegung"',
    't.bgeheimb::varchar as "Tätigkeit:Behörde Vertraulichkeit Begründung"',
    '(t.aenddat_date || \' \' || t.aenddat_time)::varchar as "Tätigkeit:Letzte Änderung"'
  ]
    
	FREISETZUNG =[
    'f.jahr::varchar as "Freisetzung:Berichtsjahr"',
    'f.medium::varchar as "Freisetzung:Medium"',
    'f.stoffnr::varchar as "Freisetzung:Schadstoff Nr"',
    'f.stoffbez::varchar as "Freisetzung:Stoffbezeichnung"',
    'f.stoffgruppenbezeichnung::varchar as "Freisetzung:Stoffgruppe"',
    'f.jfracht::varchar as "Freisetzung:Jahresfracht(kg/a)"',
    'f.vfracht::varchar as "Freisetzung:Fracht versehentlich(kg/a)"',
    'f.bamenge::varchar as "Freisetzung:Bezugsabwassermenge(m<sup>3</sup>/a)"',
    'f.bestim::varchar as "Freisetzung:Bestimmungsmethode"',
    'f.bvcode::varchar as "Freisetzung:Bestimmungsverfahren"',
    'f.bvmet::varchar as "Freisetzung:Verfahrensbeschreibung"',
    'f.messverf::varchar as "Freisetzung:Messverfahren"',
    'f.geheim::varchar as "Freisetzung:Vertraulichkeit"',
    'collect_geheimk(f.id, \'p_freis\', \'<br>\')::varchar as "Freisetzung:Geheimhaltungsgrund"',
    'f.geheimd::varchar as "Freisetzung:Vertraulichkeit Darlegung"',
    'f.bgeheimb::varchar as "Freisetzung:Behörde Vertraulichkeit Begründung"',
    '(f.aenddat_date || \' \' || f.aenddat_time)::varchar as "Freisetzung:Letzte Änderung"'
  ]

  VERB_ABWASSER = [
    'w.jahr::varchar as "Verbringung von Abwasser:Berichtsjahr"',
    'w.stoffnr::varchar as "Verbringung von Abwasser:Schadstoff Nr"',
    'w.stoffbez::varchar as "Verbringung von Abwasser:Stoffbezeichnung"',
    'w.stoffgruppenbezeichnung::varchar as "Verbringung von Abwasser:Stoffgruppe"',
    'w.jfracht::varchar as "Verbringung von Abwasser:Jahresfracht(kg/a)"',
    'w.bamenge::varchar as "Verbringung von Abwasser:Abwassermenge(m<sup>3</sup>/a)"',
    'w.bestim::varchar as "Verbringung von Abwasser:Bestimmungsmethode"',
    'w.bvcode::varchar as "Verbringung von Abwasser:Bestimmungsverfahren"',
    'w.bvmet::varchar as "Verbringung von Abwasser:Verfahrensbeschreibung"',
    'w.messverf::varchar as "Verbringung von Abwasser:Messverfahren"',
    'w.geheim::varchar as "Verbringung von Abwasser:Vertraulichkeit"',
    'collect_geheimk(w.id, \'p_vabw\', \'<br>\')::varchar as "Verbringung von Abwasser:Geheimhaltungsgrund"',
    'w.geheimd::varchar as "Verbringung von Abwasser:Vertraulichkeit Darlegung"',
    'w.bgeheimb::varchar as "Verbringung von Abwasser:Behörde Vertraulichkeit Begründung"',
    'w.aenddat_date || \' \' || w.aenddat_time::varchar as "Verbringung von Abwasser:Letzte Änderung"',
    #    'w.aenddat_time as "Verbringung von Abwasser:Letzte Änderung(Uhrzeit)"'
  ]

  VERB_ABFALL = [
    'v.jahr::varchar as "Verbringung von Abfällen:Berichtsjahr"',
    'v.abfart::varchar as "Verbringung von Abfällen:Abfallart"',
    'v.aland::varchar as "Verbringung von Abfällen:im Land?"',
    'v.astaat::varchar as "Verbringung von Abfällen:Verb.land(ISO-Code)"',
    'v.verbes::varchar as "Verbringung von Abfällen:Disposition"',
    'v.menge::varchar as "Verbringung von Abfällen:Menge [t]"',
    'v.bestim::varchar as "Verbringung von Abfällen:Bestimmungsmethode"',
    'v.bvcode::varchar as "Verbringung von Abfällen:Bestimmungsverfahren"',
    'v.bvmet::varchar as "Verbringung von Abfällen:Verfahrensbeschreibung"',
    #wir z.Z. nicht geliefert(rmi): 'v.messverf::varchar as "Verbringung von Abfällen:Messverfahren"',
    '(v.vbname ||\', \'|| v.vbstr ||\' \'|| v.vbstrnr||\', \'|| v.vbplz||\' \'|| v.vbort)::varchar  as "Verbringung von Abfällen:Verwerter/Beseitiger"',
    '(v.vbsstr ||\' \'|| v.vbsstrnr||\', \'|| v.vbsplz||\' \'|| v.vbsort)::varchar  as "Verbringung von Abfällen:Verwertungs-/Beseitigungsstandort"',
    #    'v.vbname as "Verbringung von Abfällen:Verwerter/Beseitiger: Name"',
    #    'v.vbort as "Verbringung von Abfällen:Verwerter/Beseitiger: Ort"',
    #    'v.vbplz as "Verbringung von Abfällen:Verwerter/Beseitiger: Plz"',
    #    'v.vbstr as "Verbringung von Abfällen:Verwerter/Beseitiger: Straße"',
    #    'v.vbstrnr as "Verbringung von Abfällen:Verwerter/Beseitiger: Hausnr"',
    #    'v.vbsort as "Verbringung von Abfällen:Verwertungs-/Beseitigungsstandort: Ort"',
    #    'v.vbsplz as "Verbringung von Abfällen:Verwertungs-/Beseitigungsstandort: Plz"',
    #    'v.vbsstr as "Verbringung von Abfällen:Verwertungs-/Beseitigungsstandort: Straße"',
    #    'v.vbsstrnr as "Verbringung von Abfällen:Verwertungs-/Beseitigungsstandort: Straßennummer"',
    'v.geheim::varchar as "Verbringung von Abfällen:Vertraulichkeit/"',
    'collect_geheimk(v.id, \'p_vabf\', \'<br>\')::varchar as "Verbringung von Abfällen:Geheimhaltungsgrund"',
    'v.geheimd::varchar as "Verbringung von Abfällen:Vertraulichkeit Darlegung"',
    'v.bgeheimb::varchar as "Verbringung von Abfällen:Behörde Vertraulichkeit Begründung"',
    'v.bgeheimp::varchar as "Verbringung von Abfällen:Vertraulichkeit PersBezDat"',
    'v.aenddat_date || \' \' || v.aenddat_time::varchar as "Verbringung von Abfällen:Letzte Änderung"',
    #    'v.aenddat_time as "Verbringung von Abfällen:Letzte Änderung(Uhrzeit)"'
  ]

  EXTRA_EIGENSCHAFTEN_GRUPPEN = [[],[],
    #Tätigkeiten, 2
    [#Format: [<<value(also beliebig, aber klein und ein Wort, mit all und none als special>>, <<[]mit Spalten oder leer, wenn alle>>, <<Anzeigename>>]
    #['steht im select', ['was soll gezeigt werden'], 'name für Java-Script'],
      ['Alle', [], 'all'],
      ['Keine', [], 'none'],
      ['Benutzerdefiniert', [], 'custom'],
      ['Minimal', ['Tätigkeit:PRTR-Tätigkeit',
      'Tätigkeit:Haupttätigkeit'],
        'simple'],
      ['Gängigste',
        ['Tätigkeit:PRTR-Tätigkeit',
      'Tätigkeit:Haupttätigkeit','Tätigkeit:IVU-Tätigkeit'],
        'complicated']
    ],

    #Freisetzungen, 3
    [#Format: [<<value(also beliebig, aber klein und ein Wort, mit all und none als special>>, <<[]mit Spalten oder leer, wenn alle>>, <<Anzeigename>>]
    #['steht im select', ['was soll gezeigt werden'], 'name für Java-Script'],
      ['Alle', [], 'all'],
      ['Keine', [], 'none'],
      ['Benutzerdefiniert', [], 'custom'],
      ['Minimal', [
          'Freisetzung:Medium',
          'Freisetzung:Schadstoff Nr'],
        'simple'],
      ['Gängigste',
          ['Freisetzung:Medium',
          'Freisetzung:Schadstoff Nr',
          'Freisetzung:Stoffbezeichnung',
          'Freisetzung:Jahresfracht(kg/a)',
          'Freisetzung:Fracht versehentlich(kg/a)',
          'Freisetzung:Bestimmungsmethode',
          'Freisetzung:Bestimmungsverfahren',
          'Freisetzung:Verfahrensbeschreibung'],
        'complicated']
    ],

    #Abwasserverbringung, 4
    [#Format: [<<value(also beliebig, aber klein und ein Wort, mit all und none als special>>, <<[]mit Spalten oder leer, wenn alle>>, <<Anzeigename>>]
    #['steht im select', ['was soll gezeigt werden'], 'name für Java-Script'],
      ['Alle', [], 'all'],
      ['Keine', [], 'none'],
      ['Benutzerdefiniert', [], 'custom'],
      ['Minimal', [
        'Verbringung von Abwasser:Schadstoff Nr',
        'Verbringung von Abwasser:Stoffbezeichnung',
        'Verbringung von Abwasser:Jahresfracht(kg/a)'
    ],
        'simple'],
      ['Gängigste',
        ['Verbringung von Abwasser:Schadstoff Nr',
        'Verbringung von Abwasser:Stoffbezeichnung',
        'Verbringung von Abwasser:Jahresfracht(kg/a)',
        'Verbringung von Abwasser:Bestimmungsmethode',
        'Verbringung von Abwasser:Bestimmungsverfahren',
        'Verbringung von Abwasser:Verfahrensbeschreibung'],
        'complicated']
    ],

    #Abfallverbringung, 5
    [#Format: [<<value(also beliebig, aber klein und ein Wort, mit all und none als special>>, <<[]mit Spalten oder leer, wenn alle>>, <<Anzeigename>>]
    #['steht im select', ['was soll gezeigt werden'], 'name für Java-Script'],
      ['Alle', [], 'all'],
      ['Keine', [], 'none'],
      ['Benutzerdefiniert', [], 'custom'],
      ['Minimal', [
      'Verbringung von Abfällen:Abfallart',
      'Verbringung von Abfällen:im Land?',
      'Verbringung von Abfällen:Verb.land(ISO-Code)'],
        'simple'],
      ['Gängigste',
        ['Verbringung von Abfällen:Abfallart',
      'Verbringung von Abfällen:im Land?',
      'Verbringung von Abfällen:Verb.land(ISO-Code)',
      'Verbringung von Abfällen:Disposition',
      'Verbringung von Abfällen:Menge [t]',
      'Verbringung von Abfällen:Bestimmungsmethode',
      'Verbringung von Abfällen:Bestimmungsverfahren',
      'Verbringung von Abfällen:Verfahrensbeschreibung'],
        'complicated']
    ]
  ]#end EXTRA_EIGENSCHAFTEN_GRUPPEN

  SCHUTZGR = {'01' => 'Nachteilige Auswirkungen auf die internationalen Beziehungen',
              '02' => 'Nachteilige Auswirkungen auf die Verteidigung',
              '03' => 'Nachteilige Auswirkungen auf Schutzgüter der öffentlichen Sicherheit',
              '04' => 'Nachteilige Auswirkungen auf die Durchführung eines laufenden Gerichtsverfahrens',
              '05' => 'Nachteilige Auswirkungen auf den Anspruch einer Person auf ein faires Verfahren',
              '06' => 'Nachteilige Auswirkungen auf die Durchführung strafrechtlicher, ordnungswidrigkeitenrechtlicher oder disziplinarrechtlicher Ermittlungen',
              '07' => 'Offenbarung personenbezogener Daten',
              '08' => 'Verletzung von Rechten am geistigen Eigentum',
              '09' => 'Zugänglichmachung von Betriebsgeheimnissen',
              '10' => 'Zugänglichmachung von Geschäftsgeheimnissen',
              '11' => 'Steuergeheimnis',
              '12' => 'Statistikgeheimnis'
  }


  
  def index
  end

  def change_period
    session[:reporting_period] = params[:reporting_period]
    redirect_to :action => 'index'
  end

  def year #erste Seite einer Abfrage
    if params[:art]
      big_session[:abfrage] = {}
      big_session[:abfrage][:schutzgr]={}
      big_session[:abfrage][:art]=params[:art].to_i
      big_session[:abfrage][:art_text] = case params[:art].to_i
        when 1 then "Betriebseinrichtungen"
        when 2 then "Betriebseinrichtungen und Tätigkeiten"
        when 3 then "Betriebseinrichtungen und Freisetzungen"
        when 4 then "Betriebseinrichtungen und Abwasserverbringung"
        when 5 then "Betriebseinrichtungen und Abfallverbringung"
        when 6 then "Betriebseinrichtungen, Tätigkeiten, Freisetzungen und Verbringungen"
      end
      @preselected_year = session[:reporting_period].to_i
      @preselected_bula = true
    else
      @preselected_year = big_session[:abfrage][:year].to_i
      @preselected_bula = false
    end
    connection = ActiveRecord::Base.connection
    @bulaender = connection.query("SELECT ktext,ltext FROM l_bundeslaender WHERE id > 0 ORDER BY sortier")
  end


  def naces
    if params[:origin] == 'year'
      big_session[:abfrage][:year]=params[:date][:year]
      big_session[:abfrage][:bundeslaender]=params[:bundesland]._? []
    end
    @nace_abschnitte_collected = NaceAbschnitt.all.collect {|p| [ p.abschnitt+' - '+p.titel, p.id]}
    @nace_abschnitte_filtered = NaceAbschnitt.all
    big_session[:abfrage][:max_naces] = @nace_abschnitte_filtered.length
  end

  def taet_typ
    if params[:origin] == 'naces'
      big_session[:abfrage][:naces] = params[:nace]._? []
    end
  end

  def schutzgr
    if params[:origin] == 'naces'
      big_session[:abfrage][:naces] = params[:nace]._? []
    end
    if params[:origin] == 'taet_typ'
      big_session[:abfrage][:taet_typ] = params[:taet_typ]
      big_session[:abfrage][:taet_like] = params[:taet_like]
    end
  end

  def filter_columns
    if params[:origin] == 'schutzgr'
      big_session[:abfrage][:filter_logik] = params[:filter_logik]
      big_session[:abfrage][:filter] = params[:filter]
      big_session[:abfrage][:schutzgr]['betriebe b'] = params[:schutz]
      big_session[:abfrage][:schutzgr]['taetigkeit t'] = params[:schutz_taet] 
      big_session[:abfrage][:schutzgr]['freisetzung f'] = params[:schutz_freis]
      big_session[:abfrage][:schutzgr]['verb_abwasser w'] = params[:schutz_abw]
      big_session[:abfrage][:schutzgr]['verb_abfall v'] = params[:schutz_abf]
    end
    i=-1
    $columns ||= BETRIEB.collect { |col| i+=1;[col[col.index('as "')+4..col.rindex('"')-1],i]}
    $prepared ||= BETRIEBS_EIGENSCHAFTEN_GRUPPEN
    $werte ||= Array.new
    i=-1
    $werte[2] ||= TAETIGKEIT.collect { |col| i+=1;[col[col.index('as "')+4..col.rindex('"')-1],i]}
    i=-1
    $werte[3] ||= FREISETZUNG.collect { |col| i+=1;[col[col.index('as "')+4..col.rindex('"')-1],i]}
    i=-1
    $werte[4] ||= VERB_ABWASSER.collect { |col| i+=1;[col[col.index('as "')+4..col.rindex('"')-1],i]}
    i=-1
    $werte[5] ||= VERB_ABFALL.collect { |col| i+=1;[col[col.index('as "')+4..col.rindex('"')-1],i]}
  end



  def result
    if params[:origin] == 'filter_columns'
      big_session[:abfrage][:spalten] = params[:columns]
      big_session[:abfrage][:spalten_taet] = params[:columns_taet]
      big_session[:abfrage][:spalten_freis] = params[:columns_freis]
      big_session[:abfrage][:spalten_abw] = params[:columns_abw]
      big_session[:abfrage][:spalten_abf] = params[:columns_abf]
    end
    spalten = (big_session[:abfrage][:spalten].collect { |col| BETRIEB[col.to_i] } rescue BETRIEB)
    @naces = big_session[:abfrage][:naces].collect{|nace| "'#{nace[0..1]}.#{nace[2..3]}'"}
    @naces_display = (@naces.empty? || @naces.length == big_session[:abfrage][:max_naces]) ? 'Es wird nicht nach Nace-Codes gefiltert' : @naces.join(', ')
    @bulas = big_session[:abfrage][:bundeslaender].collect { |bula| "'#{bula}'" }
    @bulas_display = (@bulas.empty? || @bulas.length == 16) ? 'Es wird nicht nach Bundesländern gefiltert' : big_session[:abfrage][:bundeslaender].join(', ')

    if big_session[:abfrage][:art] == 2 #tätigkeiten
      @taet_display = "Es werden"
      @taet_display << case big_session[:abfrage][:taet_typ]
        when 'JA' then " nur Haupttätigkeiten"
        when 'NEIN' then " nur Nebentätigkeiten"
        else " alle Tätigkeiten"
      end
      @taet_display << " mit '#{big_session[:abfrage][:taet_like]}' " unless big_session[:abfrage][:taet_like].blank?
      @taet_display << "angezeigt."
    end

    @schutzgr_display = ''
    big_session[:abfrage][:schutzgr].each do |table, schutzgr|
      if schutzgr
        human_name = table_to_human(table)
        if schutzgr.length == 12
          @schutzgr_display << "Es werden nur #{human_name} mit einem Schutzgrund angezeigt.<br />"
        else
          @schutzgr_display << "Es werden nur #{human_name} mit einem der Schutzgründe #{schutzgr.collect{|val| SCHUTZGR[val]}.join(', ')} angezeigt.<br />"
        end
      end
    end
    @schutzgr_display = 'Es wird nicht nach Schutzgründen gefiltert' if @schutzgr_display == ''

    @filter_display = "<br />! Es werden nur Betriebe mit #{human_join(big_session[:abfrage][:filter].collect { |table| table_to_human(table)},', ','<b>'+(big_session[:abfrage][:filter_logik]=='notall'?' und ':' oder ')+'</b>')} angezeigt" if big_session[:abfrage][:filter]

    @uberschrift1 = Array.new #werden durch request_data_set gefüllt
    @uberschrift2 = Array.new
    #calls to request data set
    @untertabellen = []
    betriebe_result = request_data_set(spalten,'betriebe b','p_betrieb_geheimk')
    @betriebe = betriebe_result.to_a
    @betriebs_felder_anzahl = betriebe_result.num_fields - 4

    @all = (big_session[:abfrage][:art] == 6)
    if @all || big_session[:abfrage][:art] == 2
      request_extra(:spalten_taet,TAETIGKEIT,'taetigkeit t','p_taet_geheimk')
    end
    if @all || big_session[:abfrage][:art] == 3
      request_extra(:spalten_freis,FREISETZUNG,'freisetzung f','p_freis_geheimk')
    end
    if @all || big_session[:abfrage][:art] == 4
      request_extra(:spalten_abw,VERB_ABWASSER,'verb_abwasser w','p_vabw_geheimk')
    end
    if @all || big_session[:abfrage][:art] == 5
      request_extra(:spalten_abf,VERB_ABFALL,'verb_abfall v','p_vabf_geheimk')
    end
    puts "***DEBUG: #{big_session[:abfrage]}***" 
    if big_session[:abfrage][:filter] # filtert betriebe die keine zeile in einer notwendigen kategorie haben
      tmp_betriebe = []
      tmp_untertabellen_data = @untertabellen.collect { |i| [] }
      while tmp_betrieb = @betriebe.shift
        save_them = extra_filtered(tmp_betrieb['id']) # returns true if any extra was found for this betrieb
        if save_them
          tmp_betriebe.push(tmp_betrieb)
        end
        @untertabellen.each_index do |i|
          untertabelle = @untertabellen[i]
          tmp_untertabellen_data[i] ||= []
          while untertabelle[:data].first && untertabelle[:data].first['id']==tmp_betrieb['id']
           tmp_untertabellen_eintrag = untertabelle[:data].shift
           tmp_untertabellen_data[i].push tmp_untertabellen_eintrag if save_them
          end
        end
      end
      @betriebe = tmp_betriebe
	  puts "***DEBUG: tmp_untertabellen_data: #{tmp_untertabellen_data}***"
      
      @untertabellen.each_index { |i| @untertabellen[i][:data] = tmp_untertabellen_data[i] }
    end
    #puts "***DEBUG: #{@untertabellen.inspect}***"
    @extra_rows = @untertabellen.inject(0) do |sum,untertabelle| 
	  #puts "***DEBUG: #{untertabelle.inspect}***"
      sum += untertabelle[:data].length #rescue 0
    end
  end

#
#  fetches data from the database
#
#
  def request_data_set(spalten,table,geheimk,join='') #table muss dabei kürzel für entsprechend der konstanten oben haben 
    where = "WHERE true"
    where << " AND b.nace IN (#{@naces.join(",")})" unless @naces.empty? || @naces.length == big_session[:abfrage][:max_naces]
    where << " AND b.buland IN (#{@bulas.join(",")})" unless @bulas.empty? || @bulas.length == 16
    where << " AND b.jahr='#{big_session[:abfrage][:year]}'"
    if table=='taetigkeit t'
      where << " AND t.htprtr = '#{big_session[:abfrage][:taet_typ]}'" if big_session[:abfrage][:taet_typ]._?('all') != 'all'
      such_txt = big_session[:abfrage][:taet_like]
      where << " AND (t.prtr_taet_key LIKE '%#{such_txt}%' OR t.prtr_taet LIKE '%#{such_txt}%')" unless big_session[:abfrage][:taet_like].blank?
    end
    if big_session[:abfrage][:schutzgr][table]
        gks = big_session[:abfrage][:schutzgr][table].join(',')
        join << " JOIN #{geheimk} gk ON gk.#{geheimk[0..-9]}_id = #{table[-1]}.id AND gk.geheimk_id IN (#{gks})"
        #where << " AND EXISTS (SELECT null FROM #{geheimk} WHERE #{geheimk[0..-9]}_id = #{table[-1]}.id AND geheimk_id IN (#{gks}))"
    end
    order = ' ORDER BY b.jahr, b.buland, b.kennnr'
    sql_statement = "SELECT DISTINCT b.id,b.kennnr, b.buland, b.jahr, #{spalten.join(",")} FROM #{table}
#{join}
#{where}
#{order}"
    result = ActiveRecord::Base.connection.execute(sql_statement)
    fields = result.fields
    fields.shift(4)
    vorher = fields[0].split(":").first;
    zaehler = 0;
    fields.each do |field|
      feld_name = field.split(':')
      unless vorher.eql?(feld_name.first)
        @uberschrift1.push([vorher,zaehler]);
        vorher = feld_name.first
        zaehler = 0;
      end
      zaehler+=1;
      @uberschrift2.push(feld_name)
    end
    @uberschrift1.push([vorher,zaehler]);
    return result
  end

  def request_extra(sess,const,table,geheimk)
      spalten = collect_extra_columns(sess,const)
      unless spalten.empty?
        join = " JOIN betriebe b ON #{table[-1]}.p_betrieb_id = b.id \n" 
        if big_session[:abfrage][:schutzgr]['betriebe b']       
            join << " JOIN p_betrieb_geheimk pbgk ON pbgk.p_betrieb_id = b.id AND pbgk.geheimk_id IN (#{big_session[:abfrage][:schutzgr]['betriebe b'].join(',')})"
        end
        offset = @untertabellen.last.nil? ? (@betriebs_felder_anzahl) : (@untertabellen.last[:col_offset] + @untertabellen.last[:col_count])
        result = request_data_set(spalten,table,geheimk,join)
        @untertabellen.push({
			:data =>result.to_a,
			:col_offset => offset,
			:col_count => result.num_fields-4,
			:name =>table[0..-3]})
      end
  end

  def collect_extra_columns(sess,const)
    if big_session[:abfrage][sess].blank?
      return @all ? [] : const
    else
      return big_session[:abfrage][sess].collect {|col| const[col.to_i]}
    end
  end

  def table_to_human(table)
    return case table
      when 'betriebe b' then 'Betriebe'
      when 'taetigkeit','taetigkeit t' then 'Tätigkeiten'
      when 'freisetzung','freisetzung f' then 'Freisetzungen'
      when 'verb_abwasser','verb_abwasser w' then 'Verbringungen mit dem Abwasser'
      when 'verb_abfall','verb_abfall v' then 'Verbringungen von Abfall'
    end
  end

  def extra_filtered(bid)
    if big_session[:abfrage][:filter_logik] == 'notone'
      tmp = false
      big_session[:abfrage][:filter].each do |filter|
        cur_untertabelle = @untertabellen.detect{|untertabelle| untertabelle[:name] == filter}[:data].first
        if cur_untertabelle && cur_untertabelle['id']==bid
          tmp = true
          break
        end
      end
    else
      tmp = true
      big_session[:abfrage][:filter].each do |filter|
        cur_untertabelle = @untertabellen.detect{|untertabelle| untertabelle[:name] == filter}[:data].first
        unless cur_untertabelle && cur_untertabelle['id']==bid
          tmp = false
          break
        end
      end
    end
    return tmp
  end

  def human_join(ary, sep, last_sep)
    return ary[0] if ary.length == 1
    str=''
    0.upto(ary.length-3) do |i|
      str<<ary[i]+sep
    end
    str << ary[ary.length-2] << last_sep << ary[ary.length-1]
    return str
  end
end
