#encoding: utf-8

class StatistikController < ApplicationController
  before_filter :login_required
  layout "application"
  helper :tools

  def index
    @optionen = spezielle_informationen.keys
  end

  def gen_info
    connection = ActiveRecord::Base.connection
    @gen_info = []
    @laender = connection.query("SELECT ktext FROM l_bundeslaender ORDER BY id")
    @laender[0][0]="DE"
    jahr = session[:reporting_period] #is used in following eval
    for statement in GENERAL_INFORMATION do
      alle_laender = false #is used in following eval
      per_land = connection.query(eval(statement.last))
      alle_laender = true #is used in following eval
      alle = connection.query(eval(statement.last))
      @gen_info.push([statement.first, alle, per_land])
    end
  end

  def single
    @values = ActiveRecord::Base.connection.execute(spezielle_informationen[params[:page]])
  end

  def all
    gen_info
    @tables = []
    statements = spezielle_informationen
    for table in statements.keys do
      @tables.push([table, ActiveRecord::Base.connection.execute(statements[table])])
    end
  end

#  def general_information(alle_laender = true)
#
#  end

  def spezielle_informationen
    jahr = session[:reporting_period]
    return {
    "Branchenhäufigkeiten nach Anzahl mit Haupttätigkeit Anh. I und Branchengruppe" =>
      %Q/select    count(lt.*) as "Anzahl Meldungen",
      -- coalesce (p.name1,'')||' '|| coalesce(p.name2,'') as "betriebseinrichtung",
      lt.schl as "Schlüssel",
      lt.ktext as "Tätigkeit Anh. I",
      lbg.name as "Branchengruppe" from p_betrieb p
      left join p_taet t
        on p.id = t.p_betrieb_id
      left join l_taetigkeiten_anhang1_eprtr lt
        on t.nrprtr_id = lt.id
      left join l_prtr_branchengruppen lbg
        on lt.prtr_branchengruppe_id = lbg.id
      where p.state = 0
         and p.date_from <= (#{jahr}*10000+101)
         and p.date_to   >= (#{jahr}*10000+1231)
         and t.htprtr = 1 group by lt.schl, lt.ktext, lbg.name
      order by count(lt.*) desc;/,

    "Branchenhäufigkeiten nach Anzahl mit Tätigkeit Anh. I und Branchengruppe" =>
      %Q/
select
  count(lt.*) as "Anzahl Meldungen",
  -- coalesce (p.name1,'')||' '|| coalesce(p.name2,'') as "betriebseinrichtung",
  lt.schl as "Schlüssel",
  lt.ktext as "Tätigkeit Anh. I",
  lbg.name as "Branchengruppe"
from p_betrieb p
  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id
where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
group by lt.schl, lt.ktext, lbg.name
order by count(lt.*) desc
;/,

    "Branchengruppenhäufigkeiten nach Anzahl (Nur Haupttätigkeiten)" =>
      %Q/select
  count(lbg.name) as "Anzahl Meldungen",
  lbg.name as "Branchengruppe"
from p_betrieb p
  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id
where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and t.htprtr = 1
group by lbg.name
order by count(lt.*) desc;/,

    "Branchengruppenhäufigkeiten nach Anzahl" =>
      %Q/select
  count(lbg.name) as "Anzahl Meldungen",
  lbg.name as "Branchengruppe"
from p_betrieb p
  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id
where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
group by lbg.name
order by count(lt.*) desc
;/,

    "Summarische Frachten aus Freisetzungen je Stoff und Kompartiment" =>
      %Q$select
  replace(sum(f.jfracht)::varchar, '.', ',') as "Summenfracht [kg/a]",
  ls.ktext as "Stoffname",
  lk.ktext as "Kompartiment"
from p_betrieb p
  left join p_freis f
    on p.id = f.p_betrieb_id
  left join l_stoffe ls
    on f.stoffnr_id = ls.id
  left join l_kompartimente lk
    on f.medium_id = lk.id
where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and stoffnr_id is not null
group by ls.ktext, lk.ktext
order by sum(f.jfracht) desc
;$,

    "Summarische Frachten aus Freisetzungen je Stoff und Branchengruppe" =>
      %Q$select
  replace(sum(f.jfracht)::varchar, '.', ',') as "Summenfracht [kg/a]",
  ls.ktext as "Stoffname",
  lbg.name as "Branchengruppe"

from p_betrieb p
  left join p_freis f
    on p.id = f.p_betrieb_id
  left join l_stoffe ls
    on f.stoffnr_id = ls.id
  left join l_kompartimente lk
    on f.medium_id = lk.id

  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id

where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and stoffnr_id is not null
  and t.htprtr = 1
group by ls.ktext, lbg.name
order by sum(f.jfracht) desc
;$,

    "Summarische Frachten aus Freisetzungen je Stoff, Kompartiment und Branchengruppe" =>
      %Q$select
  replace(sum(f.jfracht)::varchar, '.', ',') as "Summenfracht [kg/a]",
  ls.ktext as "Stoffname",
  lk.ktext as "Kompartiment",
  lbg.name as "Branchengruppe"

from p_betrieb p
  left join p_freis f
    on p.id = f.p_betrieb_id
  left join l_stoffe ls
    on f.stoffnr_id = ls.id
  left join l_kompartimente lk
    on f.medium_id = lk.id

  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id

where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and stoffnr_id is not null
  and t.htprtr = 1
group by ls.ktext, lk.ktext, lbg.name
order by sum(f.jfracht) desc
;$,

    "Summarische Frachten aus Freisetzungen je Stoff und Tätigkeit Anh. I" =>
      %Q$select
  -- f.jfracht,
  replace(sum(f.jfracht)::varchar, '.', ',') as "Summenfracht [kg/a]",
  ls.ktext as "Stoffname",
  -- lk.ktext as "Kompartiment",
  lt.schl as "Schlüssel",
  lt.ktext as "Tätigkeit Anh. I",
  lbg.name as "Branchengruppe"

from p_betrieb p
  left join p_freis f
    on p.id = f.p_betrieb_id
  left join l_stoffe ls
    on f.stoffnr_id = ls.id
  left join l_kompartimente lk
    on f.medium_id = lk.id

  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id

where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and stoffnr_id is not null
  and t.htprtr = 1
group by ls.ktext, lt.schl, lt.ktext, lbg.name
order by sum(f.jfracht) desc
;$,

    "Summarische Frachten aus Freisetzungen je Stoff, Kompartiment und Tätigkeit Anh. I" =>
      %Q$select
  replace(sum(f.jfracht)::varchar, '.', ',') as "Summenfracht [kg/a]",
  ls.ktext as "Stoffname",
  lk.ktext as "Kompartiment",
  lt.schl as "Schlüssel",
  lt.ktext as "Tätigkeit Anh. I",
  lbg.name as "Branchengruppe"

from p_betrieb p
  left join p_freis f
    on p.id = f.p_betrieb_id
  left join l_stoffe ls
    on f.stoffnr_id = ls.id
  left join l_kompartimente lk
    on f.medium_id = lk.id

  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id

where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and stoffnr_id is not null
  and t.htprtr = 1
group by ls.ktext, lk.ktext, lt.schl, lt.ktext, lbg.name
order by sum(f.jfracht) desc
;$,

    "Summarische Frachten aus Freisetzungen je Stoff, Kompartiment und Nace-Code" =>
      %Q$select
  replace(sum(f.jfracht)::varchar, '.', ',') as "Summenfracht [kg/a]",
  ls.ktext as "Stoffname",
  lk.ktext as "Kompartiment",
  lwz.schl as "Nace-Code",
  lwz.ktext as "Wirtschaftszweig"

from p_betrieb p
  left join p_freis f
    on p.id = f.p_betrieb_id
  left join l_stoffe ls
    on f.stoffnr_id = ls.id
  left join l_kompartimente lk
    on f.medium_id = lk.id

  left join l_nace_wirtschaftszweige lwz
    on lwz.id = p.nace_id

where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and stoffnr_id is not null
group by ls.ktext, lk.ktext, lwz.schl, lwz.ktext
order by sum(f.jfracht) desc
;$,

    "Alle Frachten aus Freisetzungen" =>
      %Q$select
  coalesce(p.kennnr,'') || ' ' || coalesce (p.name1,'') || ' ' || coalesce(p.name2,'') as "Betriebseinrichtung",
  replace(f.jfracht::varchar, '.', ',') as "Fracht [kg/a]",
  ls.ktext as "Stoffname",
  lk.ktext as "Kompartiment",
  lt.schl as "Schlüssel",
  lt.ktext as "Tätigkeit Anh. I",
  lbg.name as "Branchengruppe"

from p_betrieb p
  left join p_freis f
    on p.id = f.p_betrieb_id
  left join l_stoffe ls
    on f.stoffnr_id = ls.id
  left join l_kompartimente lk
    on f.medium_id = lk.id

  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id

where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and stoffnr_id is not null
  and t.htprtr = 1
--  and t.nrprtr_id <> 3 -- nicht 1.c (GFA)
--  and lbg.id = 1 -- Energiesektor
-- group by ls.ktext, lk.ktext
order by p.kennnr, f.jfracht desc;$,


    "Alle Verbringungen von Schadstoffen mit dem Abwasser" =>
      %Q$select
  coalesce(p.kennnr,'') as "Kennnummer",
  coalesce (p.name1,'') || ' ' || coalesce(p.name2,'') as "Betriebseinrichtung",
  replace(vaw.jfracht::varchar, '.', ',') as "Fracht [kg/a]",
  ls.ktext as "Stoffname",
  lt.schl as "Schlüssel",
  lt.ktext as "Tätigkeit Anh. I",
  lbg.name as "Branchengruppe"

from p_betrieb p
  left join p_vabw vaw
    on p.id = vaw.p_betrieb_id
  left join l_stoffe ls
    on vaw.stoffnr_id = ls.id

  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id

where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and stoffnr_id is not null
  and t.htprtr = 1
--  and t.nrprtr_id <> 3 -- nicht 1.c (GFA)
--  and lbg.id = 1 -- Energiesektor
-- group by ls.ktext, lk.ktext
order by p.kennnr, vaw.jfracht desc;$,

    "Alle Verbringungen von Abfällen" =>
      %Q$select
  coalesce(p.kennnr,'') as "Kennnummer",
  coalesce (p.name1,'') || ' ' || coalesce(p.name2,'') as "Betriebseinrichtung",
  replace(vabf.menge::varchar, '.', ',') as "Menge [t/a]",
  ls.ktext as "Abfalltyp",
  lvb.ktext as "Disposition",
  lt.ktext as "Tätigkeit Anh. I",
  lbg.name as "Branchengruppe"

from p_betrieb p
  left join p_vabf vabf
    on p.id = vabf.p_betrieb_id
  left join l_abfalltypen ls
    on vabf.abfart_id = ls.id
  left join l_ia lia
    on vabf.aland_id = lia.id
  left join l_disposition_abfall lvb
    on vabf.verbes_id = lvb.id

  left join p_taet t
    on p.id = t.p_betrieb_id
  left join l_taetigkeiten_anhang1_eprtr lt
    on t.nrprtr_id = lt.id
  left join l_prtr_branchengruppen lbg
    on lt.prtr_branchengruppe_id = lbg.id

where p.state = 0
  and p.date_from <= (#{jahr}*10000+101)
  and p.date_to   >= (#{jahr}*10000+1231)
  and vabf.abfart_id is not null
  and t.htprtr = 1
--  and t.nrprtr_id <> 3 -- nicht 1.c (GFA)
--  and lbg.id = 1 -- Energiesektor
-- group by ls.ktext, lk.ktext
order by p.kennnr, vabf.menge desc;$
    }
  end

  GENERAL_INFORMATION = [
      ["Anzahl der Betriebe",
       %q^"select #{'p.land_id,' unless alle_laender}count(distinct p.id)
  from p_betrieb p
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Betriebe mit angegebener Haupttätigkeit (aHT)",
        %q^"select #{'p.land_id,' unless alle_laender}count(distinct p.id)
  from p_betrieb p
    left join p_taet t
      on p.id = t.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and t.htprtr = 1#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      [
        "Anzahl der Betriebe mit Freisetzungen",
        %q^"select #{'p.land_id,' unless alle_laender}count( distinct p.id)
  from p_betrieb p
    left join p_freis f
      on p.id = f.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and f.p_betrieb_id is not null#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Betriebe mit Verbringung von Abwasser (VAbw)",
       %q^"select #{'p.land_id,' unless alle_laender}count(distinct p.id)
  from p_betrieb p
    left join p_vabw vaw
      on p.id = vaw.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and vaw.p_betrieb_id is not null#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Betriebe mit Verbringung von Abfall (VAbf)",
        %q^"select #{'p.land_id,' unless alle_laender}count(distinct p.id)
  from p_betrieb p
    left join p_vabf vaf
      on p.id = vaf.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and vaf.p_betrieb_id is not null#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Betriebe mit aHT, Freis., VAbw und VAbf",
        %q^"select #{'p.land_id,' unless alle_laender}count(distinct p.id)
  from p_betrieb p
    left join p_taet t
      on p.id = t.p_betrieb_id
    left join p_freis f
      on p.id = f.p_betrieb_id
    left join p_vabw vaw
      on p.id = vaw.p_betrieb_id
    left join p_vabf vaf
      on p.id = vaf.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and t.htprtr = 1
    and f.p_betrieb_id is not null
    and vaw.p_betrieb_id is not null
    and vaf.p_betrieb_id is not null#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Tätigkeiten",
        %q^"select #{'p.land_id,' unless alle_laender}count(distinct p.id)
  from p_betrieb p
    left join p_taet t
      on p.id = t.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and t.id is not null#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Freisetzungen",
        %q^"select #{'p.land_id,' unless alle_laender}count(p.id)
  from p_betrieb p
    left join p_freis f
      on p.id = f.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and f.id is not null#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Verbringungen von Abwasser",
        %q^"select #{'p.land_id,' unless alle_laender}count(p.id)
  from p_betrieb p
    left join p_vabw vaw
      on p.id = vaw.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and vaw.id is not null#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Verbringungen von Abfall",
        %q^"select #{'p.land_id,' unless alle_laender}count(p.id)
  from p_betrieb p
    left join p_vabf vaf
      on p.id = vaf.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and vaf.id is not null#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der Freisetzungen von Betrieben mit aHT",
        %q^"select #{'p.land_id,' unless alle_laender}count(distinct f.id)
  from p_betrieb p
    inner join p_freis f
      on p.id = f.p_betrieb_id
    inner join p_taet t
      on p.id = t.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and t.htprtr = 1#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der VAwb von Betrieben mit aHT",
        %q^"select #{'p.land_id,' unless alle_laender}count(distinct vaw.id)
  from p_betrieb p
    inner join p_vabw vaw
      on p.id = vaw.p_betrieb_id
    inner join p_taet t
      on p.id = t.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and t.htprtr = 1#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ],

      ["Anzahl der VAwf von Betrieben mit aHT",
        %q^"select #{'p.land_id,' unless alle_laender}count(vaf.id)
  from p_betrieb p
    inner join p_vabf vaf
      on p.id = vaf.p_betrieb_id
    inner join p_taet t
      on p.id = t.p_betrieb_id
  where p.state = 0
    and p.date_from <= (#{jahr}*10000+101)
    and p.date_to   >= (#{jahr}*10000+1231)
    and t.htprtr = 1#{('
  group by p.land_id
  order by p.land_id') unless alle_laender};"^
      ]
    ]

end
