#encoding: utf-8

class UsersController < ApplicationController
  before_filter :login_required
  layout "application"
  
  # GET /users
  # GET /users.xml
  def index
    if session[:user].is_admin?
      @users = User.all(:order => 'team_id, loginname')
    else
      if session[:user].is_team_admin?
        @users = User.find(session[:user].id).team.users
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>"
        redirect_to :controller => :start, :action => :index and return false
      end
    end

    respond_to do |format|
      unless session[:nojs]
        format.html # index.html.erb
        format.xml  { render :xml => @users }
      else
        format.html { render :action => 'index_nojs.html.erb' }
      end
    end
  end

  # GET /users/new
  # GET /users/new.xml
  def new
    if session[:user].is_admin?
      @user = User.new
    else
      if session[:user].is_team_admin?
        @user = User.new
        @user.team_id = session[:user].team_id
      else 
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>"
        redirect_to :controller => :start, :action => :index and return false
      end
    end

    respond_to do |format|
      format.html # new.html.erb
      format.xml  { render :xml => @user }
    end
  end

  # GET /users/1/edit
  def edit_role
    if session[:user].is_admin?
      @user = User.find(params[:id])
    else
      flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>"
      redirect_to :controller => :start, :action => :index and return false
    end

    respond_to do |format|
      format.html # edit_role.html.erb
      format.xml  { render :xml => @user }
    end
  end

  # GET /users/1/edit
  def edit_pwd
    if session[:user].is_admin?
      @user = User.find(params[:id])
    else
      if session[:user].is_team_admin?
        @user = User.find(params[:id])
        unless @user.team_id == session[:user].team_id
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>"
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>"
        redirect_to :controller => :start, :action => :index and return false
      end
    end
    @user.password = ''

    respond_to do |format|
      format.html # edit_pwd.html.erb
      format.xml  { render :xml => @user }
    end
  end

  def show_password_fields
    @user = User.find(params[:id])
    respond_to do |format|
      format.html { render :partial => "pwd_field"}
    end
  end

  def hide_password_fields
    @user = User.find(params[:id])
    respond_to do |format|
      format.html { render :partial => "pwd_btn", :locals => {:user => @user}}
    end
  end

  def show_role_fields
    @user = User.find(params[:id])
    respond_to do |format|
      format.html { render :partial => "role_field"}
    end
  end

  def hide_role_fields
    @user = User.find(params[:id])
    respond_to do |format|
      format.html { render :partial => "role_btn", :locals => {:user => @user}}
    end
  end

  def activate
    if session[:user].is_admin?
      @user = User.find(params[:id])
    else
      if session[:user].is_team_admin?
        @user = User.find(params[:id])
        unless @user.team_id == session[:user].team_id && @user.admin_level == 0
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
        redirect_to :controller => :start, :action => :index and return false
      end
    end

    respond_to do |format|
      unless session[:nojs]
        format.html { render :partial => "status", :locals => {:user => @user}}
      else
        if @user.update_attributes(:disabled => params[:disable]?1:0 )
          flash[:notice] = 'Der Benutzerstatus wurde erfolgreich geändert.'
        else
          flash[:notice] = 'Der Benutzerstatus konnte nicht geändert werden.'
        end
        format.html { redirect_to :action => 'index' }
      end
    end
  end

  # POST /users
  # POST /users.xml
  def create
    if session[:user].is_admin?
      @user = User.new(params[:user])
    else
      if session[:user].is_team_admin?
        @user = User.new(params[:user])
        @user.team_id = session[:user].team_id
        @user.admin_level = 0
      else 
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
        redirect_to :controller => :users, :action => :index and return false
      end
    end

    respond_to do |format|
      if @user.save
        flash[:notice] = 'Der Benutzer wurde erfolgreich angelegt.'
        format.html { redirect_to :action => :index}
        format.xml  { render :xml => @user, :status => :created, :location => @user }
      else
        format.html { render :action => "new" }
        format.xml  { render :xml => @user.errors, :status => :unprocessable_entity }
      end
    end
  end

  # PUT /users/1
  # PUT /users/1.xml
  def update_pwd
    if session[:user].is_admin?
      @user = User.find(params[:id])
    else
      if session[:user].is_team_admin?
        @user = User.find(params[:id])
        unless (@user.team_id == session[:user].team_id && @user.admin_level == 0) || @user.id == session[:user].id
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
        redirect_to :controller => :start, :action => :index and return false
      end
    end

    respond_to do |format|
      # die zu überschreibenden attribute werden hier explizit angegeben, da sonst jemand, der nur team_admin Rechte hat seine rolle ändern
      @user.update_attributes(:password=>params[:user][:password], :password_confirmation => params[:user][:password_confirmation])
      if @user.save
        flash[:notice] = 'Das Passwort wurde erfolgreich geändert.'
        format.html { redirect_to :action => :index }
        format.xml  { head :ok }
      else
        format.html { render :action => "edit_pwd"}
        format.xml  { render :xml => @user.errors, :status => :unprocessable_entity }
      end
    end
  end

  # PUT /users/1
  # PUT /users/1.xml
  def update_role
    if session[:user].is_admin?
      @user = User.find(params[:id])
    else
      flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
      redirect_to :controller => :start, :action => :index and return false
    end

    respond_to do |format|
      if @user.update_attributes(params[:user])
        flash[:notice] = 'Die Benutzerrolle wurde erfolgreich geändert.'
        format.html { redirect_to :action => :index }
        format.xml  { head :ok }
      else
        flash[:notice] = @user.to_json
        format.html { render :action => "edit_role" }
        format.xml  { render :xml => @user.errors, :status => :unprocessable_entity }
      end
    end
  end

  def delete
    begin
      destroy
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = 'Der Benutzer konnte nicht gelöscht werden, da er nicht in der Datenbank gefunden wurde.<br />
      Evtl. haben Sie doppelt auf das Kreuz geklickt. Vergewissern Sie sich bitte, ob der Nutzer nicht bereits gelöscht ist.'

      respond_to do |format|
        format.html { redirect_to(users_url) }
        format.xml  { head :ok }
      end
    end
  end

  # DELETE /users/1
  # DELETE /users/1.xml
  def destroy
    if session[:user].is_admin?
      @user = User.find(params[:id])
    else
      if session[:user].is_team_admin?
        @user = User.find(params[:id])
        unless (@user.team_id == session[:user].team_id && @user.admin_level == 0) || @user.id == session[:user].id
          flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
          redirect_to :controller => :users, :action => :index and return false
        end
      else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
        redirect_to :controller => :start, :action => :index and return false
      end
    end
    if @user.destroy
        flash[:notice] = 'Der Benutzer wurde erfolgreich gelöscht.'
    else
        flash[:notice] = 'Der Benutzer konnte nicht gelöscht werden.'
    end

    respond_to do |format|
      format.html { redirect_to :action => :index }
      format.xml  { head :ok }
    end
  end
end
