#encoding: utf-8

module StartHelper

  #   <%= option_groups_from_collection_for_select(@nace_abschnitte_filtered, :NaceZweigs, :anzeige, :schl, :anzeige, big_session[:abfrage][:naces]) %>
  def option_groups_from_collection_for_select(collection, selected_keys = nil)
    collection.inject("") do |options_for_select, group|
      group_label_string = group.anzeige
      options_for_select += "<optgroup label=\"#{html_escape(group_label_string)}\" title=\"#{html_escape(group_label_string)}\">"
      options_for_select += group.NaceZweigs.inject("") do |options, element|
          text, value = [element.anzeige.to_s, element.schl.to_s]
          selected_attribute = ' selected="selected"' if selected_keys && selected_keys.include?(value)
          options << %(<option value="#{html_escape(value)}"#{selected_attribute}>#{html_escape(text)}</option>)
      end
      options_for_select += '</optgroup>'
    end
  end

  def options_for_select(container, selected = nil)
     container = container.to_a if Hash === container
     options_for_select = container.inject([]) do |options, element|
       text, value = option_text_and_value(element)
       selected_attribute = ' selected="selected"' if option_value_selected?(value, selected)
       options << %(<option value="#{html_escape(value.to_s)}" #{selected_attribute} title=\"#{html_escape(text.to_s)}\">#{html_escape(text.to_s)}</option>)
     end
     options_for_select.join("\n")
   end

  def extra_filtered(extras, bid)
    tmp = false
    big_session[:abfrage][:filter].each do |filter|
      if extras.detect{|extra| extra[3] == filter}[0].first && extras.detect{|extra| extra[3] == filter}[0].first['id']==bid
        tmp = true
        break
      end
    end
    return tmp
  end

  def schritt
    current_found = false
    steps = [
      ['Jahr und Bundesland', :year],
      ['Nace-Codes',:naces],
      ['Schutzgründe und Pflichtattribute',:schutzgr],
      ['Spalten',:filter_columns],
      ['Ergebnis',:result]
    ]
    steps.insert(2, ['Haupt/Nebentätigkeit',:taet_typ]) if (big_session[:abfrage][:art]==2 rescue false)
    steps.collect do |step|
      if current_found
        step[0]
      else
        if step[1].to_s == @controller.action_name
          current_found = true
          '<b>'+step[0]+'</b>'
        else
          link_to step[0], :action => step[1]
        end
      end
    end.join(' | ')
  end

end
