#encoding: utf-8

module ToolsHelper

  def col_class
    @x = @x==0 ? 1 : 0
  end

  def row_class(new = false)
    if new 
      @x = nil
      @y = @y==0 ? 1 : 0
    end
    return @y
  end

  def ntprtr()
    i=1
    str=''
    while i < @taet.num_tuples
      str << '<li>' + (@taet[i]["prtr_taet"] || ' - ') + ' (IVU: '+(@taet[i]["ivu_taet"] || ' - ')+') </li>'
      i+=1
    end
    return str
  end


  $star = false

  def reset
    $star = false
  end
  
  def chop_anhang(txt)
    if txt.include?('lt. Anhang II E-PRTR-VO')
      $star = true
      return txt.chomp(' lt. Anhang II E-PRTR-VO')+'*'
    else
      return txt
    end
  end

  def  german_format_cell(row, col, schadstoff_nummer)
    in_txt = row[col]
    txt=row[col]
    align='left'
    return '<td class="zeile'+$x.to_s+'" align="center"> - </td>' if txt.blank?
    return '<td class="zeile'+$x.to_s+'" align="center"> - </td>' if txt =~ /\s*,\s+,\s*/
    return '<td class="zeile' + $x.to_s + '" align="center">' + @vertraulich_text + '</td>' if txt == @vertraulich_text
    n = /^[0-9]{3}$/u.match(txt)

    #c = /^[0-9]+[-][0-9]+[-][0-9]+$/u.match(txt) # CAS-Nummer
    if col=='CAS-Nummer' || col=='CAS-<br />Nummer' || n
      align = 'right'
    elsif col =~ /^Schadstoffbezeichnung.+/u && !@geheim
      txt = "<a href=\"javascript: top.tabbar.externalSwitch(1,'/typo3/index.php?id=423&stuffId=#{schadstoff_nummer}');\">" + txt + "</a>"
    else
      m = /^([0-9.,]+)(.*)$/u.match(txt)
      if m
        numeric_part = m[1]
        numeric_part.gsub!(/,0?$/u, "")
        # Round to three significant digits:
        begin
          sf3_number = sprintf("%.2e", numeric_part).to_f.to_s
          sf3_number.gsub!(/\.0$/u, '')
          germane = number_with_delimiter(sf3_number, :delimiter => ".", :separator => ",")
          txt = germane + m[2]
          align = 'right'
        rescue Exception => schepper
          # puts "Crashed with <#{schepper}>."
          # print schepper.backtrace[0..7].join("\n")
          txt = in_txt
        ensure
        end
      end
      if (txt.include?('<key>'))
        meth = txt.split('<method>')
        g = meth[1].split('<key>')
        txt = meth[0]+' (<a href="#glossar" title="'+g[1]+'">'+g[0]+'</a>)' rescue meth[0]
      end
    end
    return '<td class="zeile'+$x.to_s+'" align="'+align+'">'+txt+'</td>'
  end

  def  german_format(txt)
    return ' - ' if txt.blank?
      m = /^([0-9.,]+)(.*)$/u.match(txt)
      if m
        numeric_part = m[1]
        numeric_part.gsub!(/,0?$/u, "")
        # Round to three significant digits:
        sf3_number = sprintf("%.2e", numeric_part).to_f.to_s
        sf3_number.gsub!(/\.0$/u, '')
        germane = number_with_delimiter(sf3_number, :delimiter => ".", :separator => ",") rescue txt
        txt = germane + m[2]
      end
    return txt
  end

  def abfall_gk()
    no_waste = "Es wurden keine Verbringungen von Abfällen angegeben."
    dang_waste = "Es wurden gefährliche Abfälle verbracht."
    nondang_waste = "Es wurden nicht gefährliche Abfälle verbracht."
    both_waste = "Es wurden gefährliche und nicht gefährliche Abfälle verbracht."
    suff = " Alle weiteren Informationen zur Verbringung von Abfällen sind vertraulich."
    if @abfall.num_tuples == 0
      return no_waste
    elsif @abfall.num_tuples == 2
      return both_waste + suff
    end
    # Bleibt nur ein Tupel übrig:
    
    # puts "Abfall: <#{@abfall[0].to_s}>"

    if @abfall[0]["abfart_id"] == "1"
      return dang_waste + suff
    else
      return nondang_waste + suff
    end
    return "Diese Information ist vertraulich."
  end

end
