-- SQL-Skript für diverse Korrekturen an den e-PRTR Daten
--
-- (c) ENDA GmbH & Co. KG, 2011
--
-- * INT (M) -> OTH (M) für die Bestimmungsverfahren (bvcode_id), die keine Beschreibung (messverf) haben
-- * INT (C) -> OTH (C) für die Bestimmungsverfahren (bvcode_id), die keine Beschreibung (messverf) haben
-- * Wenn Ermittlungsart C-calculated und (Freisetzung Wasser oder Verbringung mit dem Abwasser), dann:
-- ** INT (C) IPCC        -> OTH (C)
-- ** INT (C) ETS         -> OTH (C)
-- ** INT (C) UN-ECE/EMEP -> OTH (C)
--
-- 2011-03-23, Rev. 2, mlt: Einführung der 'returning'-Änderungsinformation für tabellarische Dokumentation
-- 2011-03-23, Rev. 1, mlt: Ergänzung der INT (C) XY -> OTH (C) Regeln und Statements
-- 2011-03-22, Rev. 0, mlt: Erstellung


-- * INT(M) -> OTH(M) für die Berechnungsverfahren, die keine Beschreibung (messverf = designation) haben

--p_freis

UPDATE p_freis f SET bvcode_id = 9  -- OTH (M)
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE f.p_betrieb_id = b.id
  and f.bvcode_id = 4               -- INT (M)
  and f.messverf is null
returning 4401 as korrektur, 'Freisetzungen: INT(M) -> OTH(M), wenn zum Bestimmungsverfahren  keine Beschreibung (messverf) vorliegt' as beschreibung, b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, f.id as p_freis_id;

UPDATE p_freis f SET bvcode_id = 8  -- OTH (C)
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE f.p_betrieb_id = b.id
  and f.bvcode_id = 3               -- INT (C)
  and f.messverf is null
returning 4402 as korrektur, 'Freisetzungen: INT(C) -> OTH(C), wenn zum Bestimmungsverfahren  keine Beschreibung (messverf) vorliegt' as beschreibung, b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, f.id as p_freis_id;


--p_vabw

UPDATE p_vabw v SET bvcode_id = 9   -- OTH (M)
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE v.p_betrieb_id = b.id
  and v.bvcode_id = 4               -- INT (M)
  and v.messverf is null
returning 4403 as korrektur, 'Abwasser: INT (M) -> OTH (M), wenn zum Bestimmungsverfahren keine Beschreibung (messverf) vorliegt' as beschreibung, b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, v.id as p_vabw_id;

UPDATE p_vabw v SET bvcode_id = 8   -- OTH (C)
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
WHERE v.p_betrieb_id = b.id
  and v.bvcode_id = 3               -- INT (C)
  and v.messverf is null
returning 4404 as korrektur, 'Abwasser: INT (C) -> OTH (C), wenn zum Bestimmungsverfahren keine Beschreibung (messverf) vorliegt' as beschreibung, b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, v.id as p_vabw_id;


-- * Wenn Ermittlungsart C-calculated und (Freisetzung Wasser oder Verbringung mit dem Abwasser), dann:
-- ** INT (C) IPCC        -> OTH (C)
-- ** INT (C) ETS         -> OTH (C)
-- ** INT (C) UN-ECE/EMEP -> OTH (C)

--p_freis

update p_freis f set bvcode_id = 8  -- OTH (C)
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
where f.p_betrieb_id = b.id
  and f.bvcode_id in (15, 16, 17)   -- INT (C) IPCC, INT (C) ETS, INT (C) UN-ECE/EMEP
  and f.bestim_id = 1               -- C - calculated
  and f.medium_id = 3               -- Wasser
returning 4411 as korrektur,
  'Freisetzungen: Bestimmungsverfahren INT (C) IPCC, INT (C) ETS und INT (C) UN-ECE/EMEP -> OTH (C), wenn Ermittlungsart C = calculated und Medium Wasser' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, f.id as p_freis_id;

--p_vabw

update p_vabw v SET bvcode_id = 8   -- OTH (C)
from p_betrieb b
  inner join k_laender_fuer_aktualisierung ka
    on b.date_from = ka.jahr * 10000 +  101
    and b.date_to  = ka.jahr * 10000 + 1231
    and b.land_id  = ka.land_id
where v.p_betrieb_id = b.id
  and v.bvcode_id in (15, 16, 17)   -- INT (C) IPCC, INT (C) ETS, INT (C) UN-ECE/EMEP
  and v.bestim_id = 1               -- C - calculated
returning 4412 as korrektur,
  'Abwasser: Bestimmungsverfahren INT (C) IPCC, INT (C) ETS und INT (C) UN-ECE/EMEP -> OTH (C), wenn Ermittlungsart C = calculated' as beschreibung,
  b.land_id, b.jahr, to_char(current_timestamp, 'YYYY-MM-DD HH24:MI:SS') as am,
  b.kennnr, coalesce (b.name1,'')||' '|| coalesce(b.name2,'') as "betriebseinrichtung",
  b.id as p_betrieb_id, v.id as p_vabw_id;


