#encoding: utf-8

# Filters added to this controller apply to all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

$eprtr_version = "0.2.3" if !$eprtr_version

class ApplicationController < ActionController::Base
#  helper :all # include all helpers, all the time
  protect_from_forgery # See ActionController::RequestForgeryProtection for details
  after_filter :save_big_session

  # Scrub sensitive parameters from your log
  # filter_parameter_logging :password

  #overrides normal session[:key], returns normal corresponding value except for :user and :user_id
  class ActionController::Session::AbstractStore::SessionHash
    def [](key)
      load! unless @loaded
      return (User.find(super) rescue nil) if key == :user #returns the user-object instead of the id
      return super(:user) if key == :user_id #returns the user-id stored in session[:user]
      super
    end
  end

  def big_session
    session[:session_store] ||= Digest::MD5.hexdigest(session[:user_id].to_s+'haha'+Time.now.to_s+Time.now.nsec.to_s)
    raise "Illegal Filename" if session[:session_store][0]=='.'
    @big_session ||= ENDASession.new(session[:session_store])
    @big_session_loaded = true
    return @big_session
  end

  def save_big_session
    @big_session.save if @big_session_loaded
  end

  def destroy_big_session
    big_session.destroy
    @big_session = nil
    @big_session_loaded = false
  end

  class ENDASession
    def initialize(session_id)
      @file = session_id
      begin
        File.open("#{RAILS_ROOT}/tmp/sessions/#{@file}") do |f|
          @hash = Marshal.load(f)
        end
      rescue Errno::ENOENT
        @hash={}
      end
    end

    def []=(key,value)
      @hash[key]=value
    end

    def destroy
      File.delete("#{RAILS_ROOT}/tmp/sessions/#{@file}") rescue false
    end

    def save
      File.open("#{RAILS_ROOT}/tmp/sessions/#{@file}", 'w') do |f|
        Marshal.dump(@hash,f)
      end
    end

    def [](key)
      return @hash[key]
    end
  end

  def login_required
    unless session[:user]
      flash[:notice] = "<b style=\"color:red\">Sie müssen eingeloggt sein, um diese Seite zu sehen!</b>"
      redirect_to :controller => :login, :action => :index, :goal => request.path_parameters['controller'] and return false
    end
    if session[:user].disabled == 1
      flash[:notice] = "<b style=\"color:red\">Ihr Benutzerkonto wurde deaktiviert! Bei Fragen wenden Sie sich bitte an Ihren Systemadministrator.</b>"
      redirect_to :controller => :login, :action => :logout and return false
    end
  end

  class Float
    def to_3signdigits

      f = ("%.3G" % self).to_f

      if f >= 100
        s = "%.0f" % f
      elsif f >= 10
        s = "%.1f" % f
      elsif f >= 1
        s = "%.2f" % f
      elsif f >= 0.1
        s = "%.3f" % f
      elsif f >= 0.01
        s = "%.4f" % f
      elsif f >= 0.001
        s = "%.5f" % f
      elsif f >= 0.0001
        s = "%.6f" % f
      elsif f >= 0.00001
        s = "%.7f" % f
      elsif f >= 0.000001
        s = "%.8f" % f
      elsif f >= 0.0000001
        s = "%.9f" % f
      else
        s = "%.10f" % f
      end

      return s
    end
  end

end
