#encoding: utf-8

# Methods added to this helper will be available to all templates in the application.
module ApplicationHelper
  $x=0
  def zeile
    if $x==0
      $x=1
    else
      $x=0
    end
  end

  def reset_x
    $x=0
  end

  def get_years
    years = Rails.cache.read("reporting_years")
    unless years
      years = ActiveRecord::Base.connection.execute("SELECT DISTINCT jahr FROM p_betrieb ORDER BY jahr").collect { |j| j['jahr'].to_i }
      Rails.cache.write("reporting_years",years)
    end
    return years
  end
  
  def list_years
    years = get_years
    str = '|'
    years.each do |i|
      str <<  " #{wrap_link_or_not(i.to_s, i==session[:reporting_period].to_i)} |"
    end
    return str
  end

  def big_session
    @controller.big_session
  end

  private
  def wrap_link_or_not(str, do_not)
    return do_not ? str : link_to(str, :controller => 'start', :action => 'change_period', :reporting_period => str)
  end

end
