#encoding: utf-8

class TeamsController < ApplicationController

  before_filter :login_required
  layout "application"

  
  # GET /teams
  # GET /teams.xml
  def index
    if session[:user].is_admin?
      @teams = Team.all
    else
      flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>"
      redirect_to :controller => :start, :action => :index and return false
    end

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @teams }
    end
  end

  # GET /teams/new
  # GET /teams/new.xml
  def new
    if session[:user].is_admin?
      @team = Team.new
    else
      flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diesen Bereich!</b>"
      redirect_to :controller => :start, :action => :index and return false
    end

    respond_to do |format|
      format.html # new.html.erb
      format.xml  { render :xml => @team }
    end
  end

  # GET /teams/1/edit
  def edit
    @team = Team.find(params[:id])
  end

  # POST /users
  # POST /users.xml
  def create
    if session[:user].is_admin?
      #wegen problem dass im insert statement für die assoziationstabelle eine id, und zwar eine bereits benutzte, übergeben wird
      @team = Team.new({:name => params[:team][:name]})
      #@team = Team.new( params[:team])
    else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
        redirect_to :controller => :users, :action => :index and return false
    end

    respond_to do |format|
      if @team.save
        params[:team][:permission_ids].each {|p| Team.connection.execute("insert into permissions_teams (team_id, permission_id) values( #{@team.id}, #{p})") }
        flash[:notice] = 'Die Benutzerrolle wurde erfolgreich angelegt.'
        format.html { redirect_to :action => :index }
        format.xml  { render :xml => @team, :status => :created, :location => @team }
      else
        format.html { render :action => "new" }
        format.xml  { render :xml => @team.errors, :status => :unprocessable_entity }
      end
    end
  end

  # PUT /teams/1
  # PUT /teams/1.xml
  def update
    if session[:user].is_admin?
      @team = Team.find(params[:id])
      params[:team][:permission_ids] ||= []
    else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
        redirect_to :controller => :users, :action => :index and return false
    end

    respond_to do |format|
      if @team.update_attributes(params[:team])
        flash[:notice] = 'Die Benutzerrolle wurde erfolgreich angepasst.'
        format.html { redirect_to :action => "index" }
        format.xml  { head :ok }
      else
        format.html { render :action => "edit" }
        format.xml  { render :xml => @team.errors, :status => :unprocessable_entity }
      end
    end
  end

  def delete
    begin
      destroy
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = 'Die Benutzerrolle konnte nicht gelöscht werden, da sie nicht in der Datenbank gefunden wurde.<br />
      Evtl. haben Sie doppelt auf das Kreuz geklickt. Vergewissern Sie sich bitte, ob sie nicht bereits gelöscht ist.'

      respond_to do |format|
        format.html { redirect_to(teams_url) }
        format.xml  { head :ok }
      end
    end
  end

  # DELETE /teams/1
  # DELETE /teams/1.xml
  def destroy
    if session[:user].is_admin?
      @team = Team.find(params[:id])
      if @team.destroy
          flash[:notice] = 'Die Benutzerrolle wurde erfolgreich gelöscht.'
      else
          flash[:notice] = 'Die Benutzerrolle konnte nicht gelöscht werden.'
      end
    else
        flash[:notice] = "<b style=\"color:red\">Sie haben keine Berechtigung für diese Operation!</b>"
        redirect_to :controller => :users, :action => :index and return false
    end

    respond_to do |format|
      format.html { redirect_to(teams_url) }
      format.xml  { head :ok }
    end
  end
end
