#!/usr/bin/ruby
# -*- coding: utf-8 -*-
#
# e-PRTR XML-0 Import
# (c) ENDA, 2010
#
# by mlt
#
# Purpose:
# Read Data from e-PRTR XML-0 file and sophistically import it
# into the federal e-PRTR quality assurance database as driven by ENDA GmbH & Co. KG
#
# Hints:
# XML-File is found by MY_CONSTANT_XML0_PATH constant here in this file
# Database connection is set in xml0_importer_rb.get_connection
# 
# ToDo:
# * File Selection to replace MY_CONSTANT_XML0_PATH
#
# Rel-1-0-2

begin
  load 'xml0_importer.rb'
  require 'libglade2'
  load '../../../ruby_enda/lib/stnd.rb'
  load 'test1.rb'
  load "gui_callbacks.rb"
  require 'rubygems'
  require 'xml/libxml'
  # require 'iconv'
  require 'logger'
  # require 'activerecord'
  require 'dbi'

  include RbConfig

  APPNAME = "e-PRTR XML-0 Importer"
  APPVERSION = "1.0.2"
  ABOUT = <<EOS

(c) ENDA, 2010

Besuchen Sie die Homepage der Firma ENDA unter
http://www.enda.eu
für Informationen über die ENDA GmbH & Co. KG
EOS

  # MY_CONSTANT_XML0_PATH = "../daten/XML0_98-20100216-121843.xml"
  MY_CONSTANT_XML0_PATH = "../daten/export_xml0-01-16-20120105.xml"
  # MY_CONSTANT_XML0_PATH = "../daten/XML0_T1.xml"
  # MY_CONSTANT_XML0_PATH = "../daten/XML0_T2.xml"
  # MY_CONSTANT_XML0_PATH = "../daten/XML0_T3.xml"
  # MY_CONSTANT_XML0_PATH = "../daten/XML0_T4.xml"
  
  class Gui
    include Gui_callbacks
    # include GetText
    attr :glade

    def initialize(path_or_data, root = nil, domain = nil, localedir = nil, flag = GladeXML::FILE)
      # bindtextdomain(domain, localedir, nil, "UTF-8")
      @glade = GladeXML.new(path_or_data, root, domain, localedir, flag) {|handler| method(handler)}
    end
  end

  # Main program
  if __FILE__ == $0
    # Set values as your own application.
    PROG_PATH = "xml0_import.glade"

    # Einziger Unterschied, wenn diese Zeile kommt, ist, dass beim About-Dialog der "Mitwirkende" Knopf noch ein kleines Sternchen hat:
    # Gnome::Program.new(Test4::NAME, Test4::VERSION)

    gui = Gui.new(PROG_PATH, nil, APPNAME)
    print gui.glade.to_s, " Glade Filename: <", gui.glade.filename, ">\n"

    Gtk.main
  end

rescue Exception => rumms
  puts "Unexpected Exc <#{rumms}>"
  print rumms.backtrace.join("\n")
end
