#!/usr/bin/ruby
# -*- coding: utf-8 -*-
#
# e-PRTR XML-2 Import
# (c) 2016, 2010, 2009 Matthias Lüttgert, ENDA GmbH & Co. KG
# (c) 2009 Matthias Lüttgert, Torsten Lüdtke, RISA GmbH
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
#
# Purpose:
# Read XML2-Format and put it to the E-PRTR-Database
# UTF8 encoding: äöüßÄÖÜ
#
# Rel-2-1-0, 2016-05-26, mlt: Migration ActiveRecord v2 auf v4, Ruby v1.9 auf v2.3
# Rel-2-0-3, 2010-05-19
#   Schema-Parsing: Exception fangen, ausführliche Ausgabe erzeugen
#   vabf.vbsstaat_id eingeführt
#   vabf.vbstaat_id eingeführt

begin
  require 'rubygems'
  require 'xml/libxml'
  require 'rexml/document'
  require 'rbconfig'
  require 'yaml'
  # require 'iconv'
  require 'logger'

  load 'lib/db_controller.rb'
  load 'lib/db_classes.rb'
  load 'lib/p_betrieb.rb'
  load 'lib/p_betrieb_geheimk.rb'
  load 'lib/p_taet.rb'
  load 'lib/p_taet_geheimk.rb'
  load 'lib/p_freis.rb'
  load 'lib/p_freis_geheimk.rb'
  load 'lib/p_vabf.rb'
  load 'lib/p_vabf_geheimk.rb'
  load 'lib/p_vabw.rb'
  load 'lib/p_vabw_geheimk.rb'

  $SHARES_PATH = '/home/uba'
  # $PROJECT_PATH = "#{$SHARES_PATH}/prj/e_prtr_kampa_f2016"
  # $PROJECT_PATH = "#{$SHARES_PATH}/prj/e_prtr_kampa_t2016"
  $PROJECT_PATH = "#{$SHARES_PATH}/prj/e_prtr_kampa_t2016_iteration1"
  # $PROJECT_PATH = "#{$SHARES_PATH}/prj/e_prtr_kampa_h2013_enda"

  APPNAME = "XML-2 Import to E-PRTR-Database"
  APPVERSION = "2.1.0"
  ABOUT = <<EOS

(c) ENDA GmbH & Co. KG, 2010, 2016

Besuchen Sie die für weitere Informationen
die Homepage der ENDA GmbH & Co. KG unter
https://enda.eu
EOS

  class Importer
    def initialize (path2xmlfile, xmlfile, path2xsdfile, xsdfile, path2logfile)
      @xmlfile = path2xmlfile + "/" + xmlfile
      @xsdfile = path2xsdfile + "/" + xsdfile
      @logfile = path2logfile + "/" + xmlfile + ".log"
    end

    def check_year_and_state (jahr, land_id)
      f = File.new(@xmlfile)
      rexmldoc = REXML::Document.new(f)
      ok = REXML::XPath.match(rexmldoc.root, "//p_betrieb[JAHR='#{jahr}' and LAND=#{land_id}]")
      fail = REXML::XPath.match(rexmldoc.root, "//p_betrieb[JAHR!='#{jahr}' or LAND!=#{land_id}]")
      return [ok,fail]
      return [rexmldoc.elements["//p_betrieb[JAHR='#{jahr}' and LAND=#{land_id}]"],
        rexmldoc.elements["//p_betrieb[JAHR!='#{jahr}' or LAND!=#{land_id}]"]
      ]
      
    end
    
    def prepare
      XML::default_line_numbers = true
      @xmldoc = XML::Document.file(@xmlfile)
      File.delete(@logfile) if File.exists?(@logfile)
      
      schemafile = open(@xsdfile) { |f| f.read }
      schema = XML::Schema.from_string(schemafile)
      
      if !schema
        puts "Schema konnte nicht geladen werden."
        return false
      end
      
      puts "Zeit: "+ now + " vor Validierung der Eingabe"
      
      begin
        if !@xmldoc.validate_schema(schema)
          puts "ACHTUNG! Die Datei <#{@xmlfile}> entspricht nicht dem Schema <#{@xsdfile}>!"
          puts "Die Konvertierung kann nicht vorgenommen werden."
          return false
        else
          puts "Erfolg: Die Datei <#{@xmlfile}> entspricht dem Schema <#{@xsdfile}>!"
          return true
        end
      rescue Exception => wumm
        puts "Exception <#{wumm}>."
        puts
        puts "ACHTUNG! Die Datei <#{@xmlfile}> entspricht nicht dem Schema <#{@xsdfile}>!"
        puts "Die Konvertierung kann nicht vorgenommen werden."
        puts
        return false
      end
    end

    
    def import(owner_id)
      root = @xmldoc.root
      @log = Logger.new(@logfile)
      puts "Root element: #{root.name}"
      arbcount = 0

      root.find('/bube_xml_2/arb/p_betrieb').each do |arb|
        arbcount += 1
        pbetrieb = P_Betrieb.new(owner_id, @log)

        node = arb.find_first('JAHR')
        pbetrieb.set_jahr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('AENDDAT')
        pbetrieb.set_aenddat(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('KENNNR')
        pbetrieb.set_kennnr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('AKENNNR')
        pbetrieb.set_akennnr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('REFKATBT')
        pbetrieb.set_refkatbt(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('REFKATBS')
        pbetrieb.set_refkatbs(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('LAND')
        pbetrieb.set_land(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BEHNR')
        pbetrieb.set_behnr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('ASTNR')
        pbetrieb.set_astnr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('EINLEITNR')
        pbetrieb.set_einleitnr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('ERZEUGNR')
        pbetrieb.set_erzeugnr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BNAME1')
        pbetrieb.set_bname1(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BNAME2')
        pbetrieb.set_bname2(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('NAME1')
        pbetrieb.set_name1(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('NAME2')
        pbetrieb.set_name2(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BETNAME')
        pbetrieb.set_betname(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('EIGNAME')
        pbetrieb.set_eigname(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('STRASSE')
        pbetrieb.set_strasse(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('NR')
        pbetrieb.set_nr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PLZSTR')
        pbetrieb.set_plzstr(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('ORT')
        pbetrieb.set_ort(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('GEMDE')
        pbetrieb.set_gemde(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('RECHTSW')
        pbetrieb.set_rechtsw(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('HOCHW')
        pbetrieb.set_hochw(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('GREFSYS')
        pbetrieb.set_koordinatensystem(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('FLEZGEB')
        pbetrieb.set_flezgeb(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('NACE')
        pbetrieb.set_nace(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PRTRINFO')
        pbetrieb.set_prtrinfo(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PRODVOL')
        pbetrieb.set_prodvol(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('ANLZAHL')
        pbetrieb.set_anlzahl(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BETRIEBH')
        pbetrieb.set_betriebh(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BESZAHL')
        pbetrieb.set_beszahl(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('EMAIL')
        pbetrieb.set_email(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BEMERK')
        pbetrieb.set_bemerk(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('GEHEIMK')
        pbetrieb.set_geheimk(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('GEHEIMPD')
        pbetrieb.set_geheimpd(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('GEHEIMGE')
        pbetrieb.set_geheimge(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('GEHEIMBG')
        pbetrieb.set_geheimbg(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('GEHEIMD')
        pbetrieb.set_geheimd(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('FREISL')
        pbetrieb.set_freisl(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('FREISB')
        pbetrieb.set_freisb(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('FREISW')
        pbetrieb.set_freisw(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('VERBW')
        pbetrieb.set_verbw(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('VERBAG')
        pbetrieb.set_verbag(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('VERBANG')
        pbetrieb.set_verbang(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('FREIGABE')
        pbetrieb.set_freigabe(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('ABGABEER')
        pbetrieb.set_abgabeer(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('ABGABELE')
        pbetrieb.set_abgabele(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BEARB')
        pbetrieb.set_bearb(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PRUEFG')
        pbetrieb.set_pruefg(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BGEHEIM')
        pbetrieb.set_bgeheim(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BGEHEIMB')
        pbetrieb.set_bgeheimb(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('BBEMERK')
        pbetrieb.set_bbemerk(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PRUEFL')
        pbetrieb.set_pruefl(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PRUEFB')
        pbetrieb.set_pruefb(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PRUEFW')
        pbetrieb.set_pruefw(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PRUEFA')
        pbetrieb.set_pruefa(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('PRUEFDB')
        pbetrieb.set_pruefdb(node.content, node.line_num()) unless node.to_s == ""

        node = arb.find_first('LAENDDAT')
        pbetrieb.set_laenddat(node.content, node.line_num()) unless node.to_s == ""

        pbetrieb.save

        errors = pbetrieb.errors

        if pbetrieb.hasnewid
          arb.find('p_taet_Relation/p_taet').each do |taet|
            taetigkeit = P_Taetigkeit.new(pbetrieb.get_id, pbetrieb.get_kennnr,
              pbetrieb.get_land_id, owner_id, @log)

            node = taet.find_first('JAHR')
            taetigkeit.set_jahr(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('REFKAT')
            taetigkeit.set_refkat(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('NRPRTR')
            taetigkeit.set_nrprtr(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('HTPRTR')
            taetigkeit.set_htprtr(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('NRIVU')
            taetigkeit.set_nrivu(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('GEHEIM')
            taetigkeit.set_geheim(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('GEHEIMK')
            taetigkeit.set_geheimk(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('GEHEIMD')
            taetigkeit.set_geheimd(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('BGEHEIMB')
            taetigkeit.set_bgeheimb(node.content, node.line_num()) unless node.to_s == ""

            node = taet.find_first('AENDDAT')
            taetigkeit.set_aenddat(node.content, node.line_num()) unless node.to_s == ""

            taetigkeit.save

            errors += taetigkeit.errors
          end

          arb.find('p_freis_Relation/p_freis').each do |freis|
            freisetzung = P_Freisetzung.new(pbetrieb.get_id, pbetrieb.get_kennnr,
              pbetrieb.get_land_id, owner_id, @log)

            node = freis.find_first('JAHR')
            freisetzung.set_jahr(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('REFKAT')
            freisetzung.set_refkat(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('MEDIUM')
            freisetzung.set_medium(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('STOFFNR')
            freisetzung.set_stoffnr(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('JFRACHT')
            freisetzung.set_jfracht(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('NBIOFRACHT')
            freisetzung.set_nbiofracht(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('VFRACHT')
            freisetzung.set_vfracht(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('BAMENGE')
            freisetzung.set_bamenge(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('BESTIM')
            freisetzung.set_bestim(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('BVCODE')
            freisetzung.set_bvcode(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('BVMET')
            freisetzung.set_bvmet(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('MESSVERF')
            freisetzung.set_messverf(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('GEHEIM')
            freisetzung.set_geheim(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('GEHEIMK')
            freisetzung.set_geheimk(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('GEHEIMD')
            freisetzung.set_geheimd(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('BGEHEIMB')
            freisetzung.set_bgeheimb(node.content, node.line_num()) unless node.to_s == ""

            node = freis.find_first('AENDDAT')
            freisetzung.set_aenddat(node.content, node.line_num()) unless node.to_s == ""

            freisetzung.save

            errors += freisetzung.errors
          end

          arb.find('p_vabw_Relation/p_vabw').each do |vabw|
            vabwasser = P_VAbwasser.new(pbetrieb.get_id, pbetrieb.get_kennnr,
              pbetrieb.get_land_id, owner_id, @log)

            node = vabw.find_first('JAHR')
            vabwasser.set_jahr(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('REFKAT')
            vabwasser.set_refkat(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('STOFFNR')
            vabwasser.set_stoffnr(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('JFRACHT')
            vabwasser.set_jfracht(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('BAMENGE')
            vabwasser.set_bamenge(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('BESTIM')
            vabwasser.set_bestim(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('BVCODE')
            vabwasser.set_bvcode(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('BVMET')
            vabwasser.set_bvmet(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('MESSVERF')
            vabwasser.set_messverf(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('GEHEIM')
            vabwasser.set_geheim(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('GEHEIMK')
            vabwasser.set_geheimk(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('GEHEIMD')
            vabwasser.set_geheimd(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('BGEHEIMB')
            vabwasser.set_bgeheimb(node.content, node.line_num()) unless node.to_s == ""

            node = vabw.find_first('AENDDAT')
            vabwasser.set_aenddat(node.content, node.line_num()) unless node.to_s == ""

            vabwasser.save

            errors += vabwasser.errors
          end

          arb.find('p_vabf_Relation/p_vabf').each do |vabf|
            vabfall = P_VAbfall.new(pbetrieb.get_id, pbetrieb.get_kennnr,
              pbetrieb.get_land_id, owner_id, @log)

            node = vabf.find_first('JAHR')
            vabfall.set_jahr(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('REFKAT')
            vabfall.set_refkat(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('ABFART')
            vabfall.set_abfart(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('ALAND')
            vabfall.set_aland(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('ASTAAT')
            vabfall.set_astaat(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VERBES')
            vabfall.set_verbes(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('MENGE')
            vabfall.set_menge(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('BESTIM')
            vabfall.set_bestim(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('BVCODE')
            vabfall.set_bvcode(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('BVMET')
            vabfall.set_bvmet(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('MESSVERF')
            vabfall.set_messverf(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBNAME')
            vabfall.set_vbname(node.content, node.line_num()) unless node.to_s == ""

            # mlt, 2010-03-29:
            node = vabf.find_first('VBSTAAT')
            vabfall.set_vbstaat(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBORT')
            vabfall.set_vbort(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBPLZ')
            vabfall.set_vbplz(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBSTR')
            vabfall.set_vbstr(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBSTRNR')
            vabfall.set_vbstrnr(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBSSTAAT')
            vabfall.set_vbsstaat(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBSORT')
            vabfall.set_vbsort(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBSPLZ')
            vabfall.set_vbsplz(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBSSTR')
            vabfall.set_vbsstr(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('VBSSTRNR')
            vabfall.set_vbsstrnr(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('GEHEIM')
            vabfall.set_geheim(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('GEHEIMK')
            vabfall.set_geheimk(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('GEHEIMD')
            vabfall.set_geheimd(node.content, node.line_num()) unless node.to_s == ""
            
            node = vabf.find_first('BGEHEIMP')
            vabfall.set_bgeheimp(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('BGEHEIMB')
            vabfall.set_bgeheimb(node.content, node.line_num()) unless node.to_s == ""

            node = vabf.find_first('AENDDAT')
            vabfall.set_aenddat(node.content, node.line_num()) unless node.to_s == ""

            vabfall.save

            errors += vabfall.errors
          end
        end


        if errors == 0
          # Betrieb.update_all("process = null", ["process = ?", owner_id])
          # BetriebGK.update_all("process = null", ["process = ?", owner_id])
          # BetriebVorgaenger.update_all("process = null", ["process = ?", owner_id])
          # Taetigkeit.update_all("process = null", ["process = ?", owner_id])
          # TaetigkeitGK.update_all("process = null", ["process = ?", owner_id])
          # Freisetzung.update_all("process = null", ["process = ?", owner_id])
          # FreisetzungGK.update_all("process = null", ["process = ?", owner_id])
          # VAbfall.update_all("process = null", ["process = ?", owner_id])
          # VAbfallGK.update_all("process = null", ["process = ?", owner_id])
          # VAbwasser.update_all("process = null", ["process = ?", owner_id])
          # VAbwasserGK.update_all("process = null", ["process = ?", owner_id])

          Betrieb.where("process = ?", owner_id).update_all("process = null")
          BetriebGK.where("process = ?", owner_id).update_all("process = null")
          BetriebVorgaenger.where("process = ?", owner_id).update_all("process = null")
          Taetigkeit.where("process = ?", owner_id).update_all("process = null")
          TaetigkeitGK.where("process = ?", owner_id).update_all("process = null")
          Freisetzung.where("process = ?", owner_id).update_all("process = null")
          FreisetzungGK.where("process = ?", owner_id).update_all("process = null")
          VAbfall.where("process = ?", owner_id).update_all("process = null")
          VAbfallGK.where("process = ?", owner_id).update_all("process = null")
          VAbwasser.where("process = ?", owner_id).update_all("process = null")
          VAbwasserGK.where("process = ?", owner_id).update_all("process = null")

        else
          @log.error("Betrieb " + arbcount.to_s + " ido = " + pbetrieb.get_ido.to_s +
            ", Total errors = " + errors.to_s)
          # Alle geänderten Datensätze müssen wieder zurück gesetzt werden
          # Betrieb.update_all("process = null, state = 0", ["state > 0 and process = ?", owner_id])
          Betrieb.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          BetriebGK.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          BetriebVorgaenger.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          Taetigkeit.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          TaetigkeitGK.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          Freisetzung.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          FreisetzungGK.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          VAbfall.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          VAbfallGK.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          VAbwasser.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")
          VAbwasserGK.where("state > 0 and process = ?", owner_id).update_all("process = null, state = 0")

          # Alle neuen Datensätze müssen wieder aus der Datenbank entfernt werden
          VAbwasserGK.destroy_all(["process = ?", owner_id])
          VAbwasser.destroy_all(["process = ?", owner_id])
          VAbfallGK.destroy_all(["process = ?", owner_id])
          VAbfall.destroy_all(["process = ?", owner_id])
          FreisetzungGK.destroy_all(["process = ?", owner_id])
          Freisetzung.destroy_all(["process = ?", owner_id])
          TaetigkeitGK.destroy_all(["process = ?", owner_id])
          Taetigkeit.destroy_all(["process = ?", owner_id])
          BetriebVorgaenger.destroy_all(["process = ?", owner_id])
          BetriebGK.destroy_all(["process = ?", owner_id])
          Betrieb.destroy_all(["process = ?", owner_id])
          @log.error("Verarbeitung gescheitert! Datensätze wurden wieder aus der Datenbank gelöscht.")
        end
      end

      
      begin
        con = ActiveRecord::Base.connection();
        con.execute("select risa_adjust_sequences()")
#        con.execute("select risa_gis_rechnen()") wird
      rescue Exception => e
        @log.error("Fehler: "+e.message)
        puts "Fehler: "+e.message
      end
      puts "XML-Datei '" + @xmlfile + "' wurde verarbeitet"
      @log.close
    end
  end

  def now
    return Time.now.strftime("%Y-%m-%d %H:%M:%S")
  end

  def now_date
    return Time.now.strftime("%Y%m%d")
  end

  def now_time
    return Time.now.strftime("%H%M%S")
  end

  def istimestampbigger(currentdate, currenttime, date, time)
    if currentdate > date
      return true
    elsif currentdate == date and currenttime > time
      return true
    end

    return false
  end

  def get_laststate(rs)
    unless rs == nil
      return rs.state + 1
    else
      return 1
    end
  end

  
# die Standard Importer

  def full_import2007er
    xsdpath = "./schemata"
    path = "#{$PROJECT_PATH}/daten/xml/xml2_importdaten_2007"
    logpath = "#{$PROJECT_PATH}/daten/xml/xml2_importlogs_2007"
    Dir.glob(path + "/*.xml").each { |name|
      puts "START des Imports der Datei " + File.basename(name) + " am/um " + now
      toimport = Importer.new(path, File.basename(name), xsdpath, "xml_2.xsd", logpath)
      if toimport.prepare()
        toimport.import(1)
      end
      puts "----------------"
    }
    puts "ABSCHLUSS des 2007er Imports am/um " + now
    puts
  end

  def full_import2008er
    xsdpath = "./schemata"
    path = "#{$PROJECT_PATH}/daten/xml/xml2_importdaten_2008"
    logpath = "#{$PROJECT_PATH}/daten/xml/xml2_importlogs_2008"
    Dir.glob(path + "/*.xml").each { |name|
      puts "START des Imports der Datei " + File.basename(name) + " am/um " + now
      toimport = Importer.new(path, File.basename(name), xsdpath, "xml_2.xsd", logpath)
      if toimport.prepare()
        toimport.import(1)
      end
      puts "----------------"
    }
    puts "ABSCHLUSS des 2008er Imports am/um " + now
    puts
  end

  def full_import2009er
    xsdpath = "./schemata"
    path = "#{$PROJECT_PATH}/daten/xml/xml2_importdaten_2009"
    logpath = "#{$PROJECT_PATH}/daten/xml/xml2_importlogs_2009"
    Dir.glob(path + "/*.xml").each { |name|
      puts "START des Imports der Datei " + File.basename(name) + " am/um " + now
      toimport = Importer.new(path, File.basename(name), xsdpath, "xml_2.xsd", logpath)
      if toimport.prepare()
        toimport.import(1)
      end
      puts "----------------"
    }
    puts "ABSCHLUSS des 2009er Imports am/um " + now
    puts
  end


  def full_import2010er
    xsdpath = "./schemata"
    path = "#{$PROJECT_PATH}/daten/xml/xml2_importdaten_2010"
    logpath = "#{$PROJECT_PATH}/daten/xml/xml2_importlogs_2010"
    Dir.glob(path + "/*.xml").each { |name|
      puts "START des Imports der Datei " + File.basename(name) + " am/um " + now
      toimport = Importer.new(path, File.basename(name), xsdpath, "xml_2.xsd", logpath)
      if toimport.prepare()
        toimport.import(1)
      end
      puts "----------------"
    }
    puts "ABSCHLUSS des 2010er Imports am/um " + now
    puts
  end

  
  def custom_import
    xsdpath = "./schemata"
    path = "#{$PROJECT_PATH}/daten/xml/xml2_importdaten_2007"
    logpath = "#{$PROJECT_PATH}/daten/xml/xml2_importlogs_2007"
    name = 'BW_2007_7_20130201.xml'
      puts "START des Imports der Datei " + File.basename(name) + " am/um " + now
      toimport = Importer.new(path, File.basename(name), xsdpath, "xml_2.xsd", logpath)
      if toimport.prepare()
        toimport.import(1)
      end
    puts "ABSCHLUSS des Imports am/um " + now
    puts
  end
  
  #TODO: full_import mit zuerst prepare und laender löschen und dann alle ausführen
  def laender_loeschen
    to_import = []
    Dir.foreach "#{Dir.pwd}/#{ARGV[0]}" do |ydir|
      if jahr = /xml2_importdaten_(\d{4})/.match(ydir)[1] rescue false
        puts "Für das Jahr #{jahr} werden neu importiert:"
        Dir.foreach "#{Dir.pwd}/#{ARGV[0]}/#{ydir}" do |bldir|
          if bl = /([A-Z]{2})_#{Regexp.escape(jahr)}_.*\.xml/.match(bldir)[1] rescue false
            puts bldir
            puts bl
            h = {"jahr" => jahr, "bl" => bl}
            to_import.push h
          end
        end
      end
    end
  end
  
  def full_import()
    imports = []
    years = []
    fails = []
    ignored_folders = []
    ignored_files = []
    statements = ["delete from k_laender_fuer_aktualisierung;"]
    xsdpath = "./schemata"
    base_path = "#{$PROJECT_PATH}/daten/xml"
    # base_path = $PROJECT_PATH
    puts "base_path ist: <#{base_path}>"

    Dir.foreach(base_path) do |ydir|
      if jahr = /xml2_importdaten_(\d{4})/.match(ydir)[1] rescue false
        path = "#{base_path}/xml2_importdaten_#{jahr}"
        logpath = "#{base_path}/xml2_importlogs_#{jahr}"
        puts "Für das Jahr #{jahr} werden die Daten aus dem Pfad #{path} neu importiert:"

        Dir.glob(path + "/*.xml").each do |name|
          # if bl = /^([A-Z]{2}).*\.xml/.match(File.basename(name))[1] rescue false
          if bl = /^xml2-uba-([0-9]{2})-.*\.xml/.match(File.basename(name))[1] rescue false
            land_id = bl.gsub(/^0/,'')
            puts "land_id: #{land_id}, bl (alt): #{bl}\n"
            bl = ActiveRecord::Base.connection().execute("SELECT ktext FROM l_bundeslaender WHERE id = '#{land_id}'").first['ktext'];
            puts "bl: <#{bl}>\n"
            toimport = Importer.new(path, File.basename(name), xsdpath, "xml_2.xsd", logpath)
            if toimport.prepare()
              xpath_check = toimport.check_year_and_state(jahr, land_id)
              if xpath_check[1].empty?
                years.push jahr #hier weil sonst evtl nicht konsistent mit k_laender_f...
                imports.push({:jahr => jahr, :bl => bl, :land_id => land_id, :filename => File.basename(name), :importer => toimport, :count => xpath_check[0].length})
                statements.push("insert into k_laender_fuer_aktualisierung values ( #{land_id}, #{jahr}, '#{DateTime.now.strftime('%Y-%m-%d %H:%M')}');")
                statements.push("delete from k_suppressoren where land_id = #{land_id} and jahr = #{jahr}")
              else
                fails.push({:file => name, :reason => "Enthält #{xpath_check[1].length} Einträge aus anderem Jahr oder anderem Bundesland"})
              end
            else
              fails.push({:file => name, :reason => 'Stimmt nicht mit dem Schema überein'})
            end
          else
            ignored_files.push File.basename(name)
          end
        end
      else
        ignored_folders.push ydir
      end
    end
    puts "Ignoriere Ordner: #{ignored_folders.sort.join(', ')}"
    puts "Ignoriere Dateien: #{ignored_files.sort.join(', ')}"
    puts "---------------------------------------------------"
    unless fails.empty?
      warn "Folgende Dateien waren Fehlerhaft:"
      fails.each do |f|
        warn "#{f[:name]}: #{f[:reason]}"
      end
    end
    imports = imports.sort_by! { |i| i[:jahr]+i[:bl] }
    imports.each do |i|
      puts "Importiere #{i[:bl]} (land_id=#{i[:land_id]}) für #{i[:jahr]} (#{i[:count]} Betriebe)"
    end
    if @no_prepare
      puts "Die Tabelle k_laender_fuer_aktualisierung wird aber nicht geändert und es werden keine Daten vorher gelöscht."
    else
      puts "Vor dem Import werden die BL/Jahr Kombinationen in k_laender_fuer_aktualisierung übernommen \
        und alle betroffenen Einträge gelöscht"
    end
    puts "Ist das OK? Soll ich fortfahren? [j/N]"
    answer = STDIN.gets.chomp
    unless answer[0...1] == 'j'
      puts "Breche ab nach Nutzerwunsch..."
      exit 0
    else
      unless @no_prepare
        puts "Bereite Länder in der Datenbank vor (siehe logs)"
        years.uniq!
        years.each do |jahr|
          statements.concat(eval(%Q^"#{IO.read("sql/21_drop_gis_easy_daten.sql")}"^).split(";"))
        end
        statements.concat(IO.read("sql/25_delete_landdaten.sql").split(";"))
        statements.each do |stmt|
          @main_log.info %Q^Executing "#{stmt.strip}" \n affected #{ActiveRecord::Base.connection.execute(stmt).cmdtuples()} rows^
        end
      end
      imports.each do |toimport|
        puts "Importiere #{toimport[:bl]} #{toimport[:jahr]}"
        toimport[:importer].import(1)
        puts "----------------"
      end
      puts "


      --------------------------------------------------------------
      Führe vervollständigende Skripte aus"
      statements = IO.read("sql/completing.sql").split(";")
      statements.each do |statement|
        @main_log.info "Executing #{statement.strip} \n affected #{ActiveRecord::Base.connection.execute(statement).cmdtuples()} rows"
      end
    end
	
  end


  @main_log = Logger.new("logs/import_#{DateTime.now.strftime('%Y-%m-%d_%H%M%S')}.log")

#  custom_import
  @no_prepare = (ARGV[1] == '--no-prepare' rescue false)
   full_import()
#  full_import("#{ARGV[0]}")
#  full_import2007er
#  full_import2008er
#  full_import2009er
#  full_import2010er
rescue Exception => rumms
  puts "Unexpected Exception: <#{rumms}>"
  print rumms.backtrace.join("\n")
end
