# -*- coding: utf-8 -*-
#
# e-PRTR XML-2 Import
# (c) 2009, 2010 Matthias Lüttgert, ENDA GmbH & Co. KG
# (c) 2009 Matthias Lüttgert, Torsten Lüdtke, RISA GmbH
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
class P_Betrieb

  def initialize(owner_id, log)
    @errors     = 0
    @land_id    = -1
    @behnr_id   = -1
    @gemde_id   = -1
    @koordinatensystem_id  = -1
    @flezgeb_id = -1
    @nace_id    = -1
    @freisl_id  = -1
    @freisb_id  = -1
    @freisw_id  = -1
    @verbw_id   = -1
    @verbag_id  = -1
    @verbang_id = -1
    @bearb_id   = -1
    @pruefg_id  = -1
    @pruefl_id  = -1
    @pruefb_id  = -1
    @pruefw_id  = -1
    @pruefa_id  = -1
    @owner_id   = owner_id
    @log        = log
  end

  def errors
    return @errors
  end

  def set_refkatbt(v, l)
    @refkatbt = v
  end

  def set_refkatbs(v, l)
    @refkatbs = v
  end

  def set_kennnr(v, l)
    @kennnr = v
  end

  def set_akennnr(v, l)
    @akennnr = v
  end

  def set_land(v, l)
    @land = v

    bland = Bundesland.where(["bland = ?", @land]).first
    # bland = Bundesland.find(:first, :conditions =>["bland = ?", @land])

    if bland == nil
      @land_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Bundeslandschlüssel '" +
          @land + "' (LAND) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @land_id = bland.id
    end
  end

  def set_behnr(v, l) # elist1002 mit bland_id
    @behnr = v

    behoerde = Behoerden.where(["bland_id = ? and schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @land_id, @behnr, @zeitstempel, @zeitstempel]).first

    if behoerde == nil
      behoerde = Behoerden.where(["bland_id = 0 and schl = ? and " +
          "(date_from <= ? or date_from is null) and " +
          "(date_to >= ? or date_to is null)",
          @behnr, @zeitstempel, @zeitstempel]).first

      if behoerde == nil
        @behnr_id = -1
        @errors += 1
        @log.error("Fehler in Zeile " + l.to_s + "! Behördenschlüssel '" +
            @behnr + "' (BEHNR) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      else
        @behnr_id = behoerde.id
      end
    else
      @behnr_id = behoerde.id
    end
  end

  def set_astnr(v, l)
    @astnr = v
  end

  def set_einleitnr(v, l)
    @einleitnr = v
  end

  def set_erzeugnr(v, l)
    @erzeugnr = v
  end

  def set_bname1(v, l)
    @bname1 = v
  end

  def set_bname2(v, l)
    @bname2 = v
  end

  def set_name1(v, l)
    @name1 = v
  end

  def set_name2(v, l)
    @name2 = v
  end

  def set_betname(v, l)
    @betname = v
  end

  def set_eigname(v, l)
    @eigname = v
  end

  def set_strasse(v, l)
    @strasse = v
  end

  def set_nr(v, l)
    @nr = v
  end

  def set_plzstr(v, l)
    @plzstr = v
  end

  def set_ort(v, l)
    @ort = v
  end

  def set_gemde(v, l) # elist1003 mit bland_id
    @gemde = v

    gemeinde = Gemeinde.where(["bland_id = ? and schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @land_id, @gemde, @zeitstempel, @zeitstempel]).first

    if gemeinde == nil
      gemeinde = Gemeinde.where(["bland_id = 0 and schl = ? and " +
          "(date_from <= ? or date_from is null) and " +
          "(date_to >= ? or date_to is null)",
          @gemde, @zeitstempel, @zeitstempel]).first

      if gemeinde == nil
        @gemde_id = -1
        # @errors += 1
        @log.error("Warnung in Zeile " + l.to_s + "! Gemeindeschlüssel '" +
            @gemde + "' (GEMDE) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      else
        @gemde_id = gemeinde.id
      end
    else
      @gemde_id = gemeinde.id
    end
  end

  def set_rechtsw(v, l)
    @rechtsw = v
  end

  def set_hochw(v, l)
    @hochw = v
  end

  def set_koordinatensystem(v, l) # ersetzt georefsys
    koordinatensystem = KoordinatenSystem.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        v.to_i.to_s, @zeitstempel, @zeitstempel]).first
    
    if koordinatensystem.nil?
      @log.warn("Warnung in Zeile " + l.to_s + "! GeoReferenzschlüssel '" +
          v + "' (GREFSYS) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      @koordinatensystem_id = nil
    else
      @koordinatensystem_id = koordinatensystem.id
    end
  end

  def set_flezgeb(v, l) # elist1007 ohne bland_id
    @flezgeb = v

    flusseinzugsgebiet = Flusseinzugsgebiet.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @flezgeb, @zeitstempel, @zeitstempel]).first

    if flusseinzugsgebiet == nil
      @flezgeb_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Flusseinzugsgebietsschlüssel '" +
          @flezgeb + "' (FLEZGEB) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @flezgeb_id = flusseinzugsgebiet.id
    end
  end

  def set_nace(v, l) # slist1004 ohne bland_id
    @nace = v

    nacecode = NaceCode.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @nace, @zeitstempel, @zeitstempel]).first

    if nacecode == nil
      @nace_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Nace-Code-Schlüssel '" +
          @nace + "' (NACE) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @nace_id = nacecode.id
    end
  end

  def set_prtrinfo(v, l)
    @prtrinfo = v
  end

  def set_prodvol(v, l)
    @prodvol = v
  end

  def set_anlzahl(v, l)
    @anlzahl = v
  end

  def set_betriebh(v, l)
    @betriebh = v
  end

  def set_beszahl(v, l)
    @beszahl = v
  end

  def set_email(v, l)
    @email = v
  end

  def set_bemerk(v, l)
    @bemerk = v
  end

  def set_geheimk(v, l) # elist2012 ohne bland_id
    @geheimk = v

    unless @geheimk == ""
      gk = @geheimk.gsub(/,/, ';').split(";")

      @geheimk_id = Array.new(gk.length, -1)

      gk.length.times do |g|

        vv = VertraulichkeitsV.where(["schl = ? and " +
            "(date_from <= ? or date_from is null) and " +
            "(date_to >= ? or date_to is null)",
            gk[g].strip, @zeitstempel, @zeitstempel]).first

        if vv == nil
          @geheimk_id[g] = -1
          @errors += 1
          @log.error("Fehler in Zeile " + l.to_s + "! Vertraulichkeitsvorschriftsschlüssel '" +
              gk[g].strip + "' (GEHEIMK) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
        else
          @geheimk_id[g] = vv.id
        end
      end
    end
  end

  def set_geheimpd(v, l)
    @geheimpd = v
  end

  def set_geheimge(v, l)
    @geheimge = v
  end

  def set_geheimbg(v, l)
    @geheimbg = v
  end

  def set_geheimd(v, l)
    @geheimd = v
  end

  def set_freisl(v, l) # slist2001 ohne bland_id
    @freisl = v

    swue = Schwellenwertueberschreitung.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @freisl, @zeitstempel, @zeitstempel]).first

    if swue == nil
      @freisl_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Schwellenwertüberschreitungsschlüssel '" +
          @freisl + "' (FREISL) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @freisl_id = swue.id
    end
  end

  def set_freisb(v, l) # slist2001 ohne bland_id
    @freisb = v

    swue = Schwellenwertueberschreitung.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @freisb, @zeitstempel, @zeitstempel]).first

    if swue == nil
      @freisb_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Schwellenwertüberschreitungsschlüssel '" +
          @freisb + "' (FREISB) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @freisb_id = swue.id
    end
  end

  def set_freisw(v, l) # slist2001 ohne bland_id
    @freisw = v

    swue = Schwellenwertueberschreitung.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @freisw, @zeitstempel, @zeitstempel]).first

    if swue == nil
      @freisw_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Schwellenwertüberschreitungsschlüssel '" +
          @freisw + "' (FREISW) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @freisw_id = swue.id
    end
  end

  def set_verbw(v, l) # slist2001 ohne bland_id
    @verbw = v

    swue = Schwellenwertueberschreitung.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @verbw, @zeitstempel, @zeitstempel]).first

    if swue == nil
      @verbw_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Schwellenwertüberschreitungsschlüssel '" +
          @verbw + "' (VERBW) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @verbw_id = swue.id
    end
  end

  def set_verbag(v, l) # slist2001 ohne bland_id
    @verbag = v

    swue = Schwellenwertueberschreitung.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @verbag, @zeitstempel, @zeitstempel]).first

    if swue == nil
      @verbag_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Schwellenwertüberschreitungsschlüssel '" +
          @verbag + "' (VERBAG) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @verbag_id = swue.id
    end
  end

  def set_verbang(v, l) # slist2001 ohne bland_id
    @verbang = v

    swue = Schwellenwertueberschreitung.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @verbang, @zeitstempel, @zeitstempel]).first

    if swue == nil
      @verbang_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Schwellenwertüberschreitungsschlüssel '" +
          @verbang + "' (VERBANG) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @verbang_id = swue.id
    end
  end

  def set_freigabe(v, l)
    @freigabe = v

    unless @freigabe == ""
      @freigabe_date = @freigabe.to_s[0..7]
      @freigabe_time = @freigabe.to_s[9, 2] + @freigabe.to_s[12, 2] + "00"
    end
  end

  def set_abgabeer(v, l)
    @abgabeer = v

    unless @abgabeer == ""
      @abgabeer_date = @abgabeer.to_s[0..7]
      @abgabeer_time = @abgabeer.to_s[9, 2] + @abgabeer.to_s[12, 2] + "00"
    end
  end

  def set_abgabele(v, l)
    @abgabele = v

    unless @abgabele == ""
      @abgabele_date = @abgabele.to_s[0..7]
      @abgabele_time = @abgabele.to_s[9, 2] + @abgabele.to_s[12, 2] + "00"
    end
  end

  def set_bearb(v, l) # slist0002 ohne bland_id
    @bearb = v

    bearbeitungsstatus = Bearbeitungsstatus.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @bearb, @zeitstempel, @zeitstempel]).first

    if bearbeitungsstatus == nil
      @bearb_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Bearbeitungsstatusschlüssel '" +
          @bearb + "' (BEARB) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @bearb_id = bearbeitungsstatus.id
    end
  end

  def set_pruefg(v, l) # slist1010 ohne bland_id
    @pruefg = v

    pruefstatusv = PruefstatusV.where(["schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @pruefg, @zeitstempel, @zeitstempel]).first

    if pruefstatusv == nil
      @pruefg_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Prüfstatusvorschriftsschlüssel '" +
          @pruefg + "' (PRUEFG) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @pruefg_id = pruefstatusv.id
    end
  end

  def set_bgeheim(v, l)
    @bgeheim = v
  end

  def set_bgeheimb(v, l)
    @bgeheimb = v
  end

  def set_bbemerk(v, l)
    @bbemerk = v
  end

  def set_pruefl(v, l) # slist1009 mit bland_id
    @pruefl = v

    pruefstatus = Pruefstatus.where(["bland_id = ? and schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @land_id, @pruefl, @zeitstempel, @zeitstempel]).first

    if pruefstatus == nil
      pruefstatus = Pruefstatus.where(["bland_id = 0 and schl = ? and " +
          "(date_from <= ? or date_from is null) and " +
          "(date_to >= ? or date_to is null)",
          @pruefl, @zeitstempel, @zeitstempel]).first

      if pruefstatus == nil
        @pruefl_id = -1
        @errors += 1
        @log.error("Fehler in Zeile " + l.to_s + "! Prüfstatusschlüssel '" +
            @pruefl + "' (PRUEFL) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      else
        @pruefl_id = pruefstatus.id
      end
    else
      @pruefl_id = pruefstatus.id
    end
  end

  def set_pruefb(v, l) # slist1009 mit bland_id
    @pruefb = v

    pruefstatus = Pruefstatus.where(["bland_id = ? and schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @land_id, @pruefb, @zeitstempel, @zeitstempel]).first

    if pruefstatus == nil
      pruefstatus = Pruefstatus.where(["bland_id = 0 and schl = ? and " +
          "(date_from <= ? or date_from is null) and " +
          "(date_to >= ? or date_to is null)",
          @pruefb, @zeitstempel, @zeitstempel]).first

      if pruefstatus == nil
        @pruefb_id = -1
        @errors += 1
        @log.error("Fehler in Zeile " + l.to_s + "! Prüfstatusschlüssel '" +
            @pruefb + "' (PRUEFB) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      else
        @pruefb_id = pruefstatus.id
      end
    else
      @pruefb_id = pruefstatus.id
    end
  end

  def set_pruefw(v, l) # slist1009 mit bland_id
    @pruefw = v

    pruefstatus = Pruefstatus.where(["bland_id = ? and schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @land_id, @pruefw, @zeitstempel, @zeitstempel]).first

    if pruefstatus == nil
      pruefstatus = Pruefstatus.where(["bland_id = 0 and schl = ? and " +
          "(date_from <= ? or date_from is null) and " +
          "(date_to >= ? or date_to is null)",
          @pruefw, @zeitstempel, @zeitstempel]).first

      if pruefstatus == nil
        @pruefw_id = -1
        @errors += 1
        @log.error("Fehler in Zeile " + l.to_s + "! Prüfstatusschlüssel '" +
            @pruefw + "' (PRUEFW) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      else
        @pruefw_id = pruefstatus.id
      end
    else
      @pruefw_id = pruefstatus.id
    end
  end

  def set_pruefa(v, l) # slist1009 mit bland_id
    @pruefa = v

    pruefstatus = Pruefstatus.where(["bland_id = ? and schl = ? and " +
        "(date_from <= ? or date_from is null) and " +
        "(date_to >= ? or date_to is null)",
        @land_id, @pruefa, @zeitstempel, @zeitstempel]).first

    if pruefstatus == nil
      pruefstatus = Pruefstatus.where(["bland_id = 0 and schl = ? and " +
          "(date_from <= ? or date_from is null) and " +
          "(date_to >= ? or date_to is null)",
          @pruefa, @zeitstempel, @zeitstempel]).first

      if pruefstatus == nil
        @pruefa_id = -1
        @errors += 1
        @log.error("Fehler in Zeile " + l.to_s + "! Prüfstatusschlüssel '" +
            @pruefa + "' (PRUEFA) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      else
        @pruefa_id = pruefstatus.id
      end
    else
      @pruefa_id = pruefstatus.id
    end
  end

  def set_pruefdb(v, l)
    @pruefdb = v

    unless @pruefdb == ""
      @pruefdb_date = @pruefdb.to_s[0..7]
      @pruefdb_time = @pruefdb.to_s[9, 2] + @pruefdb.to_s[12, 2] + "00"
    end
  end

  def set_laenddat(v, l)
    @laenddat = v

    unless @laenddat == ""
      @laenddat_date = @laenddat.to_s[0..7]
      @laenddat_time = @laenddat.to_s[9, 2] + @laenddat.to_s[12, 2] + "00"
    end
  end

  def set_jahr(v, l)
    @jahr = v
    @zeitstempel = v + "0101"
    @datumvon    = v + "0101"
    @datumbis    = v + "1231"
  end

  def set_aenddat(v, l)
    @aenddat = v

    unless @aenddat == ""
      @aenddat_date = @aenddat.to_s[0..7]
      @aenddat_time = @aenddat.to_s[9, 2] + @aenddat.to_s[12, 2] + "00"
    end
  end

  def get_refkatbt
    return @refkatbt
  end

  def get_refkatbs
    return @refkatbs
  end

  def get_kennnr
    return @kennnr
  end

  def get_akennnr
    return @akennnr
  end

  def get_land_id
    return @land_id
  end

  def get_behnr_id
    return @behnr_id
  end

  def get_astnr
    return @astnr
  end

  def get_einleitnr
    return @einleitnr
  end

  def get_erzeugnr
    return @erzeugnr
  end

  def get_bname1
    return @bname1
  end

  def get_bname2
    return @bname2
  end

  def get_name1
    return @name1
  end

  def get_name2
    return @name2
  end

  def get_betname
    return @betname
  end

  def get_eigname
    return @eigname
  end

  def get_strasse
    return @strasse
  end

  def get_nr
    return @nr
  end

  def get_plzstr
    return @plzstr
  end

  def get_ort
    return @ort
  end

  def get_gemde_id
    return @gemde_id
  end

  def get_rechtsw
    return @rechtsw
  end

  def get_hochw
    return @hochw
  end

  def get_grefsys_id
    return @grefsys_id
  end

  def get_flezgeb_id
    return @flezgeb_id
  end

  def get_nace_id
    return @nace_id
  end

  def get_prtrinfo
    return @prtrinfo
  end

  def get_prodvol
    return @prodvol
  end

  def get_anlzahl
    return @anlzahl
  end

  def get_betriebh
    return @betriebh
  end

  def get_beszahl
    return @beszahl
  end

  def get_email
    return @email
  end

  def get_bemerk
    return @bemerk
  end

  def get_geheimpd
    if @geheimpd == "J" || @geheimpd == "T" || @geheimpd == "j" || @geheimpd == "t"
      return 1
    else
      return 0
    end
  end

  def get_geheimge
    if @geheimge == "J" || @geheimge == "T" || @geheimge == "j" || @geheimge == "t"
      return 1
    else
      return 0
    end
  end

  def get_geheimbg
    if @geheimbg == "J" || @geheimbg == "T" || @geheimbg == "j" || @geheimbg == "t"
      return 1
    else
      return 0
    end
  end

  def get_geheimd
    return @geheimd
  end

  def get_freisl_id
    return @freisl_id
  end

  def get_freisb_id
    return @freisb_id
  end

  def get_freisw_id
    return @freisw_id
  end

  def get_verbw_id
    return @verbw_id
  end

  def get_verbag_id
    return @verbag_id
  end

  def get_verbang_id
    return @verbang_id
  end

  def get_freigabe_date
    return @freigabe_date
  end

  def get_freigabe_time
    return @freigabe_time
  end

  def get_abgabeer_date
    return @abgabeer_date
  end

  def get_abgabeer_time
    return @abgabeer_time
  end

  def get_abgabele_date
    return @abgabele_date
  end

  def get_abgabele_time
    return @abgabele_time
  end

  def get_bearb_id
    return @bearb_id
  end

  def get_pruefg_id
    return @pruefg_id
  end

  def get_bgeheim
    if @bgeheim == "J" || @bgeheim == "T" || @bgeheim == "j" || @bgeheim == "t"
      return 1
    else
      return 0
    end
  end

  def get_bgeheimb
    return @bgeheimb
  end

  def get_bbemerk
    return @bbemerk
  end

  def get_pruefl_id
    return @pruefl_id
  end

  def get_pruefb_id
    return @pruefb_id
  end

  def get_pruefw_id
    return @pruefw_id
  end

  def get_pruefa_id
    return @pruefa_id
  end

  def get_pruefdb_date
    return @pruefdb_date
  end

  def get_pruefdb_time
    return @pruefdb_time
  end

  def get_laenddat_date
    return @laenddat_date
  end

  def get_laenddat_time
    return @laenddat_time
  end

  def get_jahr
    return @jahr
  end

  def get_aenddat_date
    return @aenddat_date
  end

  def get_aenddat_time
    return @aenddat_time
  end

  def get_ido
    return @ido
  end

  def get_id
    return @id
  end

  def check()
    lastid = Betrieb.order("id desc").first
    if lastid
      @next_id = lastid.id + 1
    else
      @next_id = 1
    end

    lastido = Betrieb.order("ido desc").first
    # alte Syntax: lastido = Betrieb.find(:first, :order => "ido desc")
    if lastido
      @next_ido = lastido.ido + 1
    else
      @next_ido = 1
    end

    # Memo
    # betrieb = Betrieb.where("kennnr = ? and land_id = ? and jahr = ? and state = 0",
    #                       @kennnr, @land_id, @jahr).order("aenddat_date desc, aenddat_time desc").first

    # puts "@kennnr, @land_id, @jahr, @aenddat_date, @aenddat_time: #{@kennnr}, #{@land_id}, #{@jahr}, #{@aenddat_date}, #{@aenddat_time}"
    
    # Finde heraus, ob der Betrieb in dem Jahr mit dem gleichen Änderungszeitstempel vorhanden ist
    betrieb = Betrieb.where("kennnr = ? and land_id = ? and jahr = ? and " +
                            "aenddat_date = ? and aenddat_time = ?",
                            @kennnr, @land_id, @jahr, @aenddat_date, @aenddat_time).first

    if betrieb
      @last_id  = betrieb.id
      @last_ido = betrieb.ido
      return "do_nothing"
    end

    # Finde heraus, ob der Betrieb in dem Jahr mit einem anderen Änderungszeitstempel vorhanden ist
    betrieb = Betrieb.where("kennnr = ? and land_id = ? and jahr = ? and state = 0",
                            @kennnr, @land_id, @jahr).order("aenddat_date desc, aenddat_time desc").first
      
    if betrieb
      @last_id  = betrieb.id
      @last_ido = betrieb.ido
      @ts_aenddat_date = betrieb.aenddat_date
      @ts_aenddat_time = betrieb.aenddat_time
      return "timestamp_update"
    end

    # Vielleicht ist der Betrieb ja auch in einem anderen Jahr vorhanden
    betrieb = Betrieb.where("kennnr = ? and land_id = ? and jahr <> ? and state = 0",
                            @kennnr, @land_id, @jahr).first
    
    if betrieb
      @last_id  = betrieb.id
      @last_ido = betrieb.ido
      return "year_insert"
    end

    return "insert"
  end

  def hasnewid
    return @hasnewid
  end

  def save
    checkstate = self.check()

    if checkstate == "do_nothing"

      @log.error("Der Betrieb mit der Kennnummer '" + @kennnr +
        "' ist mit dem gleichen Zeitstempel bereits vorhanden! Wird ignoriert.")

      @id  = @last_id
      @ido = @last_ido
      @hasnewid = false
      return

    elsif checkstate == "timestamp_update"

      timestampresult = istimestampbigger(@aenddat_date.to_i, @aenddat_time.to_i,
          @ts_aenddat_date.to_i, @ts_aenddat_time.to_i)
        
      if timestampresult == true

        self.update()

        @id  = @next_id
        @ido = @last_ido
        @hasnewid = true

      else

        @log.error("Der Datensatz für den Betrieb mit der Kennnummer '" + @kennnr +
          "' hat einen älteren Zeitstempel als der aktuelle! Wird ignoriert.")

        @id  = @last_id
        @ido = @last_ido
        @hasnewid = false
        return

      end

    elsif checkstate == "year_insert"

      @id  = @next_id
      @ido = @last_ido
      @hasnewid = true

    elsif checkstate == "insert"

      @id  = @next_id
      @ido = @next_ido
      @hasnewid = true

    end

    Betrieb.new do |b|
      b.id            = @id
      b.ido           = @ido
      b.state         = 0
      b.date_from     = @datumvon
      b.time_from     = 0
      b.date_to       = @datumbis
      b.time_to       = 0
      b.date_create   = now_date
      b.time_create   = now_time
      b.owner_id      = @owner_id
      b.creator_id    = @owner_id
      b.operation_id  = 4
      b.process       = @owner_id
      b.refkatbt      = @refkatbt      unless @refkatbt.to_s == ""
      b.refkatbs      = @refkatbs      unless @refkatbs.to_s == ""
      b.kennnr        = @kennnr        unless @kennnr.to_s == ""
      b.land_id       = @land_id
      b.behnr_id      = @behnr_id      unless @behnr_id == -1
      b.astnr         = @astnr         unless @astnr.to_s == ""
      b.einleitnr     = @einleitnr     unless @einleitnr.to_s == ""
      b.erzeuger      = @erzeugnr      unless @erzeugnr.to_s == ""
      b.bname1        = @bname1        unless @bname1.to_s == ""
      b.bname2        = @bname2        unless @bname2.to_s == ""
      b.name1         = @name1         unless @name1.to_s == ""
      b.name2         = @name2         unless @name2.to_s == ""
      b.betname       = @betname       unless @betname.to_s == ""
      b.eigname       = @eigname       unless @eigname.to_s == ""
      b.strasse       = @strasse       unless @strasse.to_s == ""
      b.nr            = @nr            unless @nr.to_s == ""
      b.plzstr        = @plzstr        unless @plzstr.to_s == ""
      b.ort           = @ort           unless @ort.to_s == ""
      b.gemde_id      = @gemde_id      unless @gemde_id == -1
      b.rechtsw       = @rechtsw       unless @rechtsw.to_s == ""
      b.hochw         = @hochw         unless @hochw.to_s == ""
      b.koordinatensystem_id    = @koordinatensystem_id unless @koordinatensystem_id == -1
      b.flezgeb_id    = @flezgeb_id    unless @flezgeb_id == -1
      b.nace_id       = @nace_id       unless @nace_id == -1
      b.prtrinfo      = @prtrinfo      unless @prtrinfo.to_s == ""
      b.prodvol       = @prodvol       unless @prodvol.to_s == ""
      b.anlzahl       = @anlzahl       unless @anlzahl.to_s == ""
      b.betriebh      = @betriebh      unless @betriebh.to_s == ""
      b.beszahl       = @beszahl       unless @beszahl.to_s == ""
      b.email         = @email         unless @email.to_s == ""
      b.bemerk        = @bemerk        unless @bemerk.to_s == ""
      b.geheimpd      = self.get_geheimpd
      b.geheimge      = self.get_geheimge
      b.geheimbg      = self.get_geheimbg
      b.geheimd       = @geheimd       unless @geheimd.to_s == ""
      b.freisl_id     = @freisl_id     unless @freisl_id == -1
      b.freisb_id     = @freisb_id     unless @freisb_id == -1
      b.freisw_id     = @freisw_id     unless @freisw_id == -1
      b.verbw_id      = @verbw_id      unless @verbw_id == -1
      b.verba_id      = @verbag_id     unless @verbag_id == -1
      b.verbang_id    = @verbang_id    unless @verbang_id == -1
      b.freigabe_date = @freigabe_date unless @freigabe_date.to_s == ""
      b.freigabe_time = @freigabe_time unless @freigabe_time.to_s == ""
      b.abgabeer_date = @abgabeer_date unless @abgabeer_date.to_s == ""
      b.abgabeer_time = @abgabeer_time unless @abgabeer_time.to_s == ""
      b.abgabele_date = @abgabele_date unless @abgabele_date.to_s == ""
      b.abgabele_time = @abgabele_time unless @abgabele_time.to_s == ""
      b.bearb_id      = @bearb_id      unless @bearb_id == -1
      b.pruefg_id     = @pruefg_id     unless @pruefg_id == -1
      b.bgeheim       = self.get_bgeheim
      b.bgeheimb      = @bgeheimb      unless @bgeheimb.to_s == ""
      b.bbemerk       = @bbemerk       unless @bbemerk.to_s == ""
      b.pruefl_id     = @pruefl_id     unless @pruefl_id == -1
      b.pruefb_id     = @pruefb_id     unless @pruefb_id == -1
      b.pruefw_id     = @pruefw_id     unless @pruefw_id == -1
      b.pruefa_id     = @pruefa_id     unless @pruefa_id == -1
      b.pruefdb_date  = @pruefdb_date  unless @pruefdb_date.to_s == ""
      b.pruefdb_time  = @pruefdb_time  unless @pruefdb_time.to_s == ""
      b.laenddat_date = @laenddat_date unless @laenddat_date.to_s == ""
      b.laenddat_time = @laenddat_time unless @laenddat_time.to_s == ""
      b.jahr          = @jahr          unless @jahr.to_s == ""
      b.aenddat_date  = @aenddat_date  unless @aenddat_date.to_s == ""
      b.aenddat_time  = @aenddat_time  unless @aenddat_time.to_s == ""
      b.xml3export    = 1
      
      begin
        b.save!
      rescue
        puts "Fehler beim Speichern der Kennnummer '" + @kennnr + "' in p_betrieb"
      end

      unless @akennnr.to_s == ""
        if @akennnr.strip != b.kennnr.strip
          # puts "Aloha! alt: <#{@akennnr}>, neu: <#{b.kennnr}>"
          # TODO: Eigentlich müsste hier geprüft werden, ob vielleicht ein Satz mit Vorgänger
          # vorhanden ist und nun dieser Vorgänger "entfernt" wurde. Dann müsste ... nein.
          # Nein, alles o.k.. Es wird in update immer inkrementiert und hier
          # muss aber KEINE Zuordnung rein. Alles prima.

          betrieb = Betrieb.where("kennnr = ? and land_id = ? and jahr < ? and state = 0",
                                   @akennnr, @land_id, @jahr).order("jahr desc").first
          # Original:
          # betrieb = Betrieb.where(["kennnr = ? and land_id = ? and jahr < ? and state = 0",
          #                          @akennnr, @land_id, @jahr],
          #                         :order => "jahr desc").first
          
          if betrieb
            lastid = BetriebVorgaenger.order("id desc").first
            if lastid
              @idbv = lastid.id + 1
            else
              @idbv = 1
            end
            
            lastido = BetriebVorgaenger.order("ido desc").first
            if lastido
              @idobv = lastido.ido + 1
            else
              @idobv = 1
            end
            
            BetriebVorgaenger.new do |bv|
              bv.id                      = @idbv
              bv.ido                     = @idobv
              bv.state                   = 0
              bv.date_from               = @datumvon
              bv.time_from               = 0
              bv.date_to                 = @datumbis
              bv.time_to                 = 0
              bv.date_create             = now_date
              bv.time_create             = now_time
              bv.owner_id                = @owner_id
              bv.creator_id              = @owner_id
              bv.operation_id            = 4
              bv.process                 = @owner_id
              bv.p_betrieb_id            = @id
              bv.p_betrieb_vorgaenger_id = betrieb.id
              
              begin
                bv.save!
              rescue
                puts "Fehler beim Speichern der alten Kennnummer '" + @akennnr + "' in p_betrieb_vorgaenger"
              end
            end
          end
        end
      end
    end

    unless @geheimk.to_s == ""
      @geheimk_id.length.times do |g|
        betriebgk = P_Betrieb_GeheimK.new(@id, @kennnr, @geheimk_id[g],
          @owner_id, @datumvon, @datumbis)
        betriebgk.save
      end
    end

  end


  def update
    # Setze den Datensatz in p_betrieb auf die höchste state + 1
    rs = Betrieb.where("ido = ? and state > 0", @last_ido).order("state desc").first

    Betrieb.update(@last_id, :state => get_laststate(rs), :process => @owner_id)

    # TODO
    # Setze die abhängigen Datensätze in p_betrieb_vorgaenger jeweils auf die höchste state + 1
    if bv = BetriebVorgaenger.find(:all, :conditions =>["p_betrieb_id = ? and state = 0", @last_id])
      bv.each do |bvl|
        rs = BetriebVorgaenger.where(["ido = ? and state > 0", bvl.ido], :order => "state desc").first
        BetriebVorgaenger.update(bvl.id, :state => get_laststate(rs), :process => @owner_id)
      end
    end

    # Setze die abhängigen Datensätze in p_betrieb_geheimk jeweils auf die höchste state + 1
    if gk = BetriebGK.find(:all, :conditions =>["p_betrieb_id = ? and state = 0", @last_id])
      gk.each do |g|
        rs = BetriebGK.where(["ido = ? and state > 0", g.ido],
          :order => "state desc").first
        BetriebGK.update(g.id, :state => get_laststate(rs), :process => @owner_id)
      end
    end

    # Setze die abhängigen Datensätze in p_freis jeweils auf die höchste state + 1
    if fs = Freisetzung.find(:all, :conditions =>["p_betrieb_id = ? and state = 0", @last_id])
      fs.each do |f|
        rs = Freisetzung.where(["ido = ? and state > 0", f.ido],
          :order => "state desc").first
        Freisetzung.update(f.id, :state => get_laststate(rs), :process => @owner_id)

        # Setze die abhängigen Datensätze in p_freis_geheimk jeweils auf die höchste state + 1
        if gk = FreisetzungGK.find(:all, :conditions =>["p_freis_id = ? and state = 0", f.id])
          gk.each do |g|
            rs = FreisetzungGK.where(["ido = ? and state > 0", g.ido],
              :order => "state desc").first
            FreisetzungGK.update(g.id, :state => get_laststate(rs), :process => @owner_id)
          end
        end
      end
    end

    # Setze die abhängigen Datensätze in p_taet jeweils auf die höchste state + 1
    if tk = Taetigkeit.find(:all, :conditions =>["p_betrieb_id = ? and state = 0", @last_id])
      tk.each do |t|
        rs = Taetigkeit.where(["ido = ? and state > 0", t.ido],
          :order => "state desc").first
        Taetigkeit.update(t.id, :state => get_laststate(rs), :process => @owner_id)

        # Setze die abhängigen Datensätze in p_taet_geheimk jeweils auf die höchste state + 1
        if gk = TaetigkeitGK.find(:all, :conditions =>["p_taet_id = ? and state = 0", t.id])
          gk.each do |g|
            rs = TaetigkeitGK.where(["ido = ? and state > 0", g.ido],
              :order => "state desc").first
            TaetigkeitGK.update(g.id, :state => get_laststate(rs), :process => @owner_id)
          end
        end
      end
    end

    # Setze die abhängigen Datensätze in p_vabf jeweils auf die höchste state + 1
    if va = VAbfall.find(:all, :conditions =>["p_betrieb_id = ? and state = 0", @last_id])
      va.each do |v|
        rs = VAbfall.where(["ido = ? and state > 0", v.ido],
          :order => "state desc").first
        VAbfall.update(v.id, :state => get_laststate(rs), :process => @owner_id)

        # Setze die abhängigen Datensätze in p_vabf_geheimk jeweils auf die höchste state + 1
        if gk = VAbfallGK.find(:all, :conditions =>["p_vabf_id = ? and state = 0", v.id])
          gk.each do |g|
            rs = VAbfallGK.where(["ido = ? and state > 0", g.ido],
              :order => "state desc").first
            VAbfallGK.update(g.id, :state => get_laststate(rs), :process => @owner_id)
          end
        end
      end
    end

    # Setze die abhängigen Datensätze in p_vabw jeweils auf die höchste state + 1
    if va = VAbwasser.find(:all, :conditions =>["p_betrieb_id = ? and state = 0", @last_id])
      va.each do |v|
        rs = VAbwasser.where(["ido = ? and state > 0", v.ido],
          :order => "state desc").first
        VAbwasser.update(v.id, :state => get_laststate(rs), :process => @owner_id)

        # Setze die abhängigen Datensätze in p_vabw_geheimk jeweils auf die höchste state + 1
        if gk = VAbwasserGK.find(:all, :conditions =>["p_vabw_id = ? and state = 0", v.id])
          gk.each do |g|
            rs = VAbwasserGK.where("ido = ? and state > 0", g.ido).order("state desc").first
            VAbwasserGK.update(g.id, :state => get_laststate(rs), :process => @owner_id)
          end
        end
      end
    end
  end
end
