# -*- coding: utf-8 -*-
#
# e-PRTR XML-2 Import
# (c) 2009, 2010 Matthias Lüttgert, ENDA GmbH & Co. KG
# (c) 2009 Matthias Lüttgert, Torsten Lüdtke, RISA GmbH
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
class P_Betrieb_GeheimK

  def initialize(p_betrieb_id, kennnr, geheimk_id, owner_id, datumvon, datumbis)
    @errors       = 0
    @p_betrieb_id = p_betrieb_id
    @kennnr       = kennnr
    @geheimk_id   = geheimk_id
    @owner_id     = owner_id
    @datumvon     = datumvon
    @datumbis     = datumbis
  end

  def errors
    return @errors
  end

  def save
    lastid = BetriebGK.order("id desc").first
    unless lastid == nil
      @id = lastid.id + 1
    else
      @id = 1
    end

    lastido = BetriebGK.order("ido desc").first
    unless lastido == nil
      @ido = lastido.ido + 1
    else
      @ido = 1
    end

    BetriebGK.new do |bgk|
      bgk.id            = @id
      bgk.ido           = @ido
      bgk.state         = 0
      bgk.date_from     = @datumvon
      bgk.time_from     = 0
      bgk.date_to       = @datumbis
      bgk.time_to       = 0
      bgk.date_create   = now_date
      bgk.time_create   = now_time
      bgk.owner_id      = @owner_id
      bgk.creator_id    = @owner_id
      bgk.operation_id  = 4
      bgk.process       = @owner_id
      bgk.p_betrieb_id  = @p_betrieb_id
      bgk.geheimk_id    = @geheimk_id

      begin
        bgk.save!
      rescue Exception => rumms
        puts "Fehler beim Speichern in p_betrieb_geheimk. rumms: <#{rumms}>"
      end
    end
  end
end
