# -*- coding: utf-8 -*-
#
# e-PRTR XML-2 Import
# (c) 2009, 2010 Matthias Lüttgert, ENDA GmbH & Co. KG
# (c) 2009 Matthias Lüttgert, Torsten Lüdtke, RISA GmbH
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
class P_VAbwasser

  def initialize(p_betrieb_id, kennnr, land_id, owner_id, log)
    @errors       = 0
    @stoffnr_id   = -1
    @bestim_id    = -1
    @bvcode_id    = -1
    @p_betrieb_id = p_betrieb_id
    @kennnr       = kennnr
    @land_id      = land_id
    @owner_id     = owner_id
    @log          = log
  end

  def errors
    return @errors
  end

  def set_refkat(v, l)
    @refkat = v
  end

  def set_stoffnr(v, l) 
    @stoffnr = v

    # Die Stoffnummer kann via XML2 einen Stoff oder eine Stoffgruppe ausweisen
    # Herausfinden kann man das nur über die Länge des Schlüssels, der  bei Stoffen
    # dreistellig, bei der Stoffgruppe nur zweistellig ist

    if @stoffnr.length == 3
      stoff = Stoff.where("schl = ? and " +
                          "(date_from <= ? or date_from is null) and " +
                          "(date_to >= ? or date_to is null)",
                          @stoffnr, @zeitstempel, @zeitstempel).first
      if stoff == nil
        @stoffnr_id = -1
        @errors += 1
        @log.error("Fehler in Zeile " + l.to_s + "! Stoffschlüssel '" +
            @stoffnr + "' (STOFFNR) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      else
        @stoffnr_id = stoff.id
      end

      @schadstoffgruppen_id = -1
    else
      schadstoffgruppe = Schadstoffgruppe.where("schl = ? and " +
                                                "(date_from <= ? or date_from is null) and " +
                                                "(date_to >= ? or date_to is null)",
                                                @stoffnr, @zeitstempel, @zeitstempel).first
      if schadstoffgruppe == nil
        @schadstoffgruppen_id = -1
        @errors += 1
        @log.error("Fehler in Zeile " + l.to_s + "! Schadstoffgruppenschlüssel '" +
            @stoffnr + "' (STOFFNR) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
      else
        @schadstoffgruppen_id = schadstoffgruppe.id
      end

      @stoffnr_id = -1
    end
  end

  def set_jfracht(v, l)
    @jfracht = v
  end

  def set_bamenge(v, l)
    @bamenge = v
  end

  def set_bestim(v, l) # slist1201 ohne bland_id
    @bestim = v

    best = Bestimmungsmethode.where("schl = ? and " +
                                    "(date_from <= ? or date_from is null) and " +
                                    "(date_to >= ? or date_to is null)",
                                    @bestim, @zeitstempel, @zeitstempel).first
    if best == nil
      @bestim_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Bestimmungsmethodenschlüssel '" +
          @bestim + "' (BESTIM) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @bestim_id = best.id
    end
  end

  def set_bvcode(v, l) # elist2006 ohne bland_id
    @bvcode = v

    best = Bestimmungsverfahren.where("schl = ? and " +
                                      "(date_from <= ? or date_from is null) and " +
                                      "(date_to >= ? or date_to is null)",
                                      @bvcode, @zeitstempel, @zeitstempel).first
    if best == nil
      @bvcode_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Bestimmungsverfahrensschlüssel '" +
          @bvcode + "' (BVCODE) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @bvcode_id = best.id
    end
  end

  def set_bvmet(v, l)
    @bvmet = v
  end

  def set_messverf(v, l)
    @messverf = v
  end

  def set_geheim(v, l)
    @geheim = v
  end

  def set_geheimk(v, l) # elist2012 ohne bland_id
    @geheimk = v

    unless @geheimk == ""
      gk = @geheimk.gsub(/,/, ';').split(";")

      @geheimk_id = Array.new(gk.length, -1)

      gk.length.times do |g|

        vv = VertraulichkeitsV.where("schl = ? and " +
                                     "(date_from <= ? or date_from is null) and " +
                                     "(date_to >= ? or date_to is null)",
                                     gk[g].strip, @zeitstempel, @zeitstempel).first
        if vv == nil
          @geheimk_id[g] = -1
          @errors += 1
          @log.error("Fehler in Zeile " + l.to_s + "! Vertraulichkeitsvorschriftsschlüssel '" +
              gk[g].strip + "' (GEHEIMK) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
        else
          @geheimk_id[g] = vv.id
        end
      end
    end
  end

  def set_geheimd(v, l)
    @geheimd = v
  end

  def set_bgeheimb(v, l)
    @bgeheimb = v
  end

  def set_jahr(v, l)
    @jahr = v
    @zeitstempel = v + "0101"
    @datumvon    = v + "0101"
    @datumbis    = v + "1231"
  end

  def set_aenddat(v, l)
    @aenddat = v

    unless @aenddat == ""
      @aenddat_date = @aenddat.to_s[0..7]
      @aenddat_time = @aenddat.to_s[9, 2] + @aenddat.to_s[12, 2] + "00"
    end
  end

  def get_refkat
    return @refkat
  end

  def get_medium_id
    return @medium_id
  end

  def get_stoffnr_id
    return @stoffnr_id
  end

  def get_schadstoffgruppen_id
    return @schadstoffgruppen_id
  end

  def get_jfracht
    return @jfracht
  end

  def get_bamenge
    return @bamenge
  end

  def get_bestim_id
    return @bestim_id
  end

  def get_bvcode_id
    return @bvcode_id
  end

  def get_bvmet
    return @bvmet
  end

  def get_messverf
    return @messverf
  end

  def get_geheim
    if @geheim == "J" || @geheim == "T" || @geheim == "j" || @geheim == "t"
      return 1
    else
      return 0
    end
  end

  def get_geheimd
    return @geheimd
  end

  def get_bgeheimb
    return @bgeheimb
  end

  def get_jahr
    return @jahr
  end

  def get_aenddat_date
    return @aenddat_date
  end

  def get_aenddat_time
    return @aenddat_time
  end

  def get_ido
    return @ido
  end

  def save
    lastid = VAbwasser.order("id desc").first
    unless lastid == nil
      @id = lastid.id + 1
    else
      @id = 1
    end

    lastido = VAbwasser.order("ido desc").first
    unless lastido == nil
      @ido = lastido.ido + 1
    else
      @ido = 1
    end

    VAbwasser.new do |va|
      va.id            = @id
      va.ido           = @ido
      va.state         = 0
      va.date_from     = @datumvon
      va.time_from     = 0
      va.date_to       = @datumbis
      va.time_to       = 0
      va.date_create   = now_date
      va.time_create   = now_time
      va.owner_id      = @owner_id
      va.creator_id    = @owner_id
      va.operation_id  = 4
      va.process       = @owner_id
      va.p_betrieb_id  = @p_betrieb_id
      va.refkat        = @refkat               unless @refkat.to_s == ""
      va.stoffnr_id    = @stoffnr_id           unless @stoffnr_id == -1
      va.sgruppe_id    = @schadstoffgruppen_id unless @schadstoffgruppen_id == -1
      va.jfracht       = @jfracht              unless @jfracht.to_s == ""
      va.bamenge       = @bamenge              unless @bamenge.to_s == ""
      va.bestim_id     = @bestim_id            unless @bestim_id == -1
      va.bvcode_id     = @bvcode_id            unless @bvcode_id == -1
      va.bvmet         = @bvmet                unless @bvmet.to_s == ""
      va.messverf      = @messverf             unless @messverf.to_s == ""
      va.geheim        = self.get_geheim
      va.geheimd       = @geheimd              unless @geheimd.to_s == ""
      va.bgeheimb      = @bgeheimb             unless @bgeheimb.to_s == ""
      va.jahr          = @jahr                 unless @jahr.to_s == ""
      va.aenddat_date  = @aenddat_date         unless @aenddat_date.to_s == ""
      va.aenddat_time  = @aenddat_time         unless @aenddat_time.to_s == ""

      begin
        va.save!
      rescue
        puts "Fehler beim Speichern in p_vabw"
      end
    end

    unless @geheimk.to_s == ""
      @geheimk_id.length.times do |g|
        vabwassergk = P_VAbwasser_GeheimK.new(@id, @kennnr, @geheimk_id[g],
          @owner_id, @datumvon, @datumbis)
        vabwassergk.save
      end
    end
  end
end
