-- 2012-03-16, mlt, Rev.02: Erhöhung der Ausfallsicherheit bei der Verarbeitung der ETRS89 UTM33 Koordinaten
--                          aus Brandenburg. Drei Fallunterscheidungen für den Rechtswert eingeführt, zwei davon
--                          mit Korrekturen des Rechtswerts.
--                          Berechnung erfolgreich getestet.


-- Hier wird aber erstmal für alle neu-importierten Betriebe gesagt, dass sie exportiert werden sollen
update p_betrieb p
set xml3export = 1, ausschlussgrund = null
from k_laender_fuer_aktualisierung ka
where p.date_from = ka.jahr * 10000 + 101
  and p.land_id = ka.land_id;


-- Korrektur ETRS89_UTM32:
-- update spatial_ref_sys set proj4text = '+proj=utm +zone=32 +ellps=GRS80 +datum=WGS84 +units=m +no_defs ' where srid = 25832;


-- KOORDINATENBERECHNUNG --


-- GK, 2. Streifen:
update p_betrieb b
set geo_src_gk2 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31466),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31466), 4326),
    geo_etrs89_utm32 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31466), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id in (3, 5, 7, 10)
  and b.rechtsw >= 2000000 and b.rechtsw < 3000000;

-- GK, 3. Streifen:
update p_betrieb b
set geo_src_gk3 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31467),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31467), 4326),
    geo_etrs89_utm32 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31467), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id in (1, 2, 3, 4, 5, 6, 7, 8, 10, 15, 16)
  and b.rechtsw >= 3000000 and b.rechtsw < 4000000;

-- GK, 4. Streifen:
update p_betrieb b
set geo_src_gk4 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31468),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31468), 4326),
    geo_etrs89_utm32 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31468), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id in (1, 3, 8, 9, 13, 14, 15, 16)
  and b.rechtsw >= 4000000 and b.rechtsw < 5000000;

-- GK, 5. Streifen: Brauchen wir derzeit nicht.
update p_betrieb b
set geo_src_gk5 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31469),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31469), 4326),
    geo_etrs89_utm32 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 31469), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id in (8, 13, 14, 15, 16)
  and b.rechtsw >= 5000000 and rechtsw < 6000000;

-- ETRS89 UTM32
update p_betrieb b
set geo_etrs89_utm32 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw-32000000 || ' ' || b.hochw || ')', 25832),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw-32000000 || ' ' || b.hochw || ')', 25832), 4326)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.rechtsw >= 32000000
  and b.rechtsw < 33000000;

-- BBs ETRS89 UTM33 (Die Fachleute in Brandenburg stellen dem sechstelligen Rechtwert nach ETRS89UTM33 mal eine 3, mal eine 33 und mal nichts voran):
update p_betrieb b
set geo_etrs89_utm33 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw-33000000 || ' ' || b.hochw || ')', 25833),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw-33000000 || ' ' || b.hochw || ')', 25833), 4326),
    geo_etrs89_utm32 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw-33000000 || ' ' || b.hochw || ')', 25833), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.rechtsw >= 33000000
  and b.rechtsw < 34000000;

-- BBs ETRS89 UTM33 (Die Fachleute in Brandenburg stellen dem sechstelligen Rechtwert nach ETRS89UTM33 mal eine 3, mal eine 33 und mal nichts voran):
update p_betrieb b
set geo_etrs89_utm33 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw-3000000 || ' ' || b.hochw || ')', 25833),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw-3000000 || ' ' || b.hochw || ')', 25833), 4326),
    geo_etrs89_utm32 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw-3000000 || ' ' || b.hochw || ')', 25833), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id = 12
  and b.rechtsw > 3000000
  and b.rechtsw < 4000000;

-- BBs ETRS89 UTM33 (Die Fachleute in Brandenburg stellen dem sechstelligen Rechtwert nach ETRS89UTM33 mal eine 3, mal eine 33 und mal nichts voran):
update p_betrieb b
set geo_etrs89_utm33 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 25833),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 25833), 4326),
    geo_etrs89_utm32 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 25833), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and b.land_id = 12
  and b.rechtsw < 1000000;

-- BEs Soldner:
update p_betrieb b
set geo_soeldner = ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 3068),
    geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 3068), 4326),
    geo_etrs89_utm32 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 3068), 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and (b.koordinatensystem_id = 3 or (b.koordinatensystem_id is null and b.land_id = 11))
  and b.rechtsw < 100000
  and b.hochw < 100000;

-- ETRS 1989 UTM Zone 32N (EPSG: 25832) - kurze Koordinaten (6/7) (bisher nur Hamburg)
-- ODER: falsche GREFSYS=2 (statt 5) angegeben (bisher nur NW)
update p_betrieb b
set geo_wgs84 = st_transform(ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 25832), 4326),
    geo_etrs89_utm32 = ST_GeometryFromText('POINT ' || '(' || b.rechtsw || ' ' || b.hochw || ')', 25832)
from k_laender_fuer_aktualisierung ka
where b.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and (b.koordinatensystem_id = 5 OR (b.koordinatensystem_id = 2 AND b.land_id = 5 AND b.rechtsw < 1000000 ));


-- Fülle Schadstoffgruppen aus Schadstoffen

update p_freis pf set sgruppe_id = lsg.id
from l_schadstoffgruppen lsg, l_stoffe ls,
  k_laender_fuer_aktualisierung ka, p_betrieb b
where pf.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and pf.p_betrieb_id = b.id
  and pf.stoffnr_id = ls.id
  and ls.sgruppe_id = lsg.id;

update p_vabw pvw set sgruppe_id = lsg.id
from l_schadstoffgruppen lsg, l_stoffe ls,
  k_laender_fuer_aktualisierung ka, p_betrieb b
where pvw.date_from = ka.jahr * 10000 + 101
  and b.land_id = ka.land_id
  and pvw.p_betrieb_id = b.id
  and pvw.stoffnr_id = ls.id
  and ls.sgruppe_id = lsg.id;


-- SEQUENZEN AUFFRISCHEN --
select risa_adjust_sequences();
select model.risa_adjust_sequences();


-- vacuum full analyze;
