# -*- coding: utf-8 -*-
#
# e-PRTR XML-2 Import
# (c) 2009, 2010 Matthias Lüttgert, ENDA GmbH & Co. KG
# (c) 2009 Matthias Lüttgert, Torsten Lüdtke, RISA GmbH
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
class P_Taetigkeit

  def initialize(p_betrieb_id, kennnr, land_id, owner_id, log)
    @errors       = 0
    @nrprtr_id    = -1
    @nrivu_id     = -1
    @p_betrieb_id = p_betrieb_id
    @kennnr       = kennnr
    @land_id      = land_id
    @owner_id     = owner_id
    @log          = log
  end

  def errors
    return @errors
  end

  def set_refkat(v, l)
    @refkat = v
  end

  def set_nrprtr(v, l) # slist1103 ohne bland_id
    @nrprtr = v

    prtrtaetigkeit = PRTRTaetigkeit.where("schl like ? and " +
                                          "(date_from <= ? or date_from is null) and " +
                                          "(date_to >= ? or date_to is null)",
                                          @nrprtr, @zeitstempel, @zeitstempel).first
    
    if prtrtaetigkeit == nil
      @nrprtr_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! PRTR-Tätigkeitsschlüssel '" +
          @nrprtr + "' (NRPRTR) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @nrprtr_id = prtrtaetigkeit.id
    end
  end

  def set_htprtr(v, l)
    @htprtr = v
  end

  def set_nrivu(v, l) #slist1102 ohne bland_id
    @nrivu = v.strip
    
    if @nrivu == "998"
      @nrivu_id = nil
      return
    end
    
    ivutaetigkeit = IVUTaetigkeit.where("schl = ? and " +
                                        "(date_from <= ? or date_from is null) and " +
                                        "(date_to >= ? or date_to is null)",
                                        @nrivu, @zeitstempel, @zeitstempel).first
    
    if ivutaetigkeit == nil
      @nrivu_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! IVU-Tätigkeitsschlüssel '" +
          @nrivu + "' (NRIVU) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @nrivu_id = ivutaetigkeit.id
    end
  end

  def set_geheim(v, l)
    @geheim = v
  end

  def set_geheimk(v, l) # elist2012 ohne bland_id
    @geheimk = v

    unless @geheimk == ""
      gk = @geheimk.gsub(/,/, ';').split(";")

      @geheimk_id = Array.new(gk.length, -1)

      gk.length.times do |g|

        vv = VertraulichkeitsV.where("schl = ? and " +
                                     "(date_from <= ? or date_from is null) and " +
                                     "(date_to >= ? or date_to is null)",
                                     gk[g].strip, @zeitstempel, @zeitstempel).first
        if vv == nil
          @geheimk_id[g] = -1
          @errors += 1
          @log.error("Fehler in Zeile " + l.to_s + "! Vertraulichkeitsvorschriftsschlüssel '" +
              gk[g].strip + "' (GEHEIMK) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
        else
          @geheimk_id[g] = vv.id
        end
      end
    end
  end

  def set_geheimd(v, l)
    @geheimd = v
  end

  def set_bgeheimb(v, l)
    @bgeheimb = v
  end

  def set_jahr(v, l)
    @jahr = v
    @zeitstempel = v + "0101"
    @datumvon    = v + "0101"
    @datumbis    = v + "1231"
  end

  def set_aenddat(v, l)
    @aenddat = v

    unless @aenddat == ""
      @aenddat_date = @aenddat.to_s[0..7]
      @aenddat_time = @aenddat.to_s[9, 2] + @aenddat.to_s[12, 2] + "00"
    end
  end

  def get_refkat
    return @refkat
  end

  def get_nrprtr_id
    return @nrprtr_id
  end

  def get_htprtr
    if @htprtr == "J" || @htprtr == "T" || @htprtr == "j" || @htprtr == "t"
      return 1
    else
      return 0
    end
  end

  def get_nrivu_id
    return @nrivu_id
  end

  def get_geheim
    if @geheim == "J" || @geheim == "T" || @geheim == "j" || @geheim == "t"
      return 1
    else
      return 0
    end
  end

  def get_geheimd
    return @geheimd
  end

  def get_bgeheimb
    return @bgeheimb
  end

  def get_jahr
    return @jahr
  end

  def get_aenddat_date
    return @aenddat_date
  end

  def get_aenddat_time
    return @aenddat_time
  end

  def get_ido
    return @ido
  end

  def save
    lastid = Taetigkeit.order("id desc").first
    unless lastid == nil
      @id = lastid.id + 1
    else
      @id = 1
    end

    lastido = Taetigkeit.order("ido desc").first
    unless lastido == nil
      @ido = lastido.ido + 1
    else
      @ido = 1
    end

    Taetigkeit.new do |t|
      t.id            = @id
      t.ido           = @ido
      t.state         = 0
      t.date_from     = @datumvon
      t.time_from     = 0
      t.date_to       = @datumbis
      t.time_to       = 0
      t.date_create   = now_date
      t.time_create   = now_time
      t.owner_id      = @owner_id
      t.creator_id    = @owner_id
      t.operation_id  = 4
      t.process       = @owner_id
      t.p_betrieb_id  = @p_betrieb_id
      t.refkat        = @refkat       unless @refkat.to_s == ""
      t.nrprtr_id     = @nrprtr_id    unless @nrprtr_id == -1
      t.htprtr        = self.get_htprtr
      t.nrivu_id      = @nrivu_id     unless @nrivu_id == -1
      t.geheim        = self.get_geheim
      t.geheimd       = @geheimd      unless @geheimd.to_s == ""
      t.bgeheimb      = @bgeheimb     unless @bgeheimb.to_s == ""
      t.jahr          = @jahr         unless @jahr.to_s == ""
      t.aenddat_date  = @aenddat_date unless @aenddat_date.to_s == ""
      t.aenddat_time  = @aenddat_time unless @aenddat_time.to_s == ""

      begin
        t.save!
      rescue
        puts "Fehler beim Speichern in p_taet"
      end

    end

    unless @geheimk.to_s == ""
      @geheimk_id.length.times do |g|
        taetigkeitgk = P_Taetigkeit_GeheimK.new(@id, @kennnr, @geheimk_id[g],
          @owner_id, @datumvon, @datumbis)
        taetigkeitgk.save
      end
    end
  end
end
