# -*- coding: utf-8 -*-
#
# e-PRTR XML-2 Import
# (c) 2009, 2010 Matthias Lüttgert, ENDA GmbH & Co. KG
# (c) 2009 Matthias Lüttgert, Torsten Lüdtke, RISA GmbH
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
class P_Taetigkeit_GeheimK

  def initialize(p_taet_id, kennnr, geheimk_id, owner_id, datumvon, datumbis)
    @errors     = 0
    @p_taet_id  = p_taet_id
    @kennnr     = kennnr
    @geheimk_id = geheimk_id
    @owner_id   = owner_id
    @datumvon   = datumvon
    @datumbis   = datumbis
  end

  def errors
    return @errors
  end

  def save
    lastid = TaetigkeitGK.order("id desc").first
    unless lastid == nil
      @id = lastid.id + 1
    else
      @id = 1
    end

    lastido = TaetigkeitGK.order("ido desc").first
    unless lastido == nil
      @ido = lastido.ido + 1
    else
      @ido = 1
    end

    TaetigkeitGK.new do |tgk|
      tgk.id            = @id
      tgk.ido           = @ido
      tgk.state         = 0
      tgk.date_from     = @datumvon
      tgk.time_from     = 0
      tgk.date_to       = @datumbis
      tgk.time_to       = 0
      tgk.date_create   = now_date
      tgk.time_create   = now_time
      tgk.owner_id      = @owner_id
      tgk.creator_id    = @owner_id
      tgk.operation_id  = 4
      tgk.process       = @owner_id
      tgk.p_taet_id     = @p_taet_id
      tgk.geheimk_id    = @geheimk_id

      begin
        tgk.save!
      rescue Exception => rumms
        puts "Fehler beim Speichern in p_taet_geheimk. rumms: <#{rumms}>"
      end
    end
  end
end
